/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.RecognitionException;
import fuego.parser.TokenStreamException;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.FuegoLexer;
import oracle.bpm.compiler.FuegoParser;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeParser;
import oracle.bpm.type.TypeRef;

class TypeSpecParser
extends TypeParser
implements MessageListener {
    private ObjectClass currentClass;
    private CilException error;
    private FuegoParser parser;

    public TypeSpecParser(FuegoParser parser) {
        this.parser = parser;
        this.currentClass = new ObjectClass(null, null);
    }

    @Override
    public synchronized TypeRef parse(String typeSpec, ComponentCatalog catalog, TypeDescription context) throws IllegalTypeException {
        try {
            return this.parseType(typeSpec, context, catalog);
        }
        catch (CompilerException e) {
            Msg key = e.getKey();
            assert (key != null) : "Missing message for exception : " + e.getClass();
            throw new IllegalTypeException(key);
        }
    }

    @Override
    public void reportError(CilException exception) {
        this.error = exception;
    }

    @Override
    public void reportWarning(CilException exception) {
    }

    private TypeRef parseType(String typeSpec, TypeDescription context, ComponentCatalog catalog) throws CompilerException {
        SourceCode code = SourceCode.create(typeSpec, this.parser.getLexer().getLanguage());
        try {
            this.parser.reset();
            FuegoLexer lexer = this.parser.getLexer();
            lexer.setCode(typeSpec);
            this.parser.setMessageListener(this);
            this.error = null;
            this.parser.typeSpec();
            if (this.error != null) {
                throw this.error;
            }
            TypeSpec type = (TypeSpec)this.parser.getAST();
            type.setCatalog(catalog);
            this.currentClass.setCatalog(catalog);
            type.setParent(this.currentClass);
            this.currentClass.setTypeDescription(context != null ? context : TypeFactory.getAny());
            TypeDescription result = type.checkType().getTypeDescription();
            if (this.error != null) {
                throw this.error;
            }
            TypeDescription typeDescription = result;
            return typeDescription;
        }
        catch (TokenStreamException e) {
            throw new CompilerParserException(e, code, true);
        }
        catch (RecognitionException e) {
            throw new CompilerParserException(e, code, true);
        }
        catch (CompilerException e) {
            throw e;
        }
        catch (Throwable unexpected) {
            throw new InternalException(null, unexpected);
        }
        finally {
            this.currentClass.setTypeDescription(TypeFactory.getAny());
        }
    }
}

