/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.AmbiguousComponentNameException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidDeclarationException;
import oracle.bpm.compiler.InvalidExpr;
import oracle.bpm.compiler.InvalidNodeException;
import oracle.bpm.compiler.InvalidParameterException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.MalformedTypeException;
import oracle.bpm.compiler.NList;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.ComponentNotFoundException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeMappings;
import oracle.bpm.type.TypeRef;

public class TypeSpec
extends Ternary {
    private ComponentCatalog catalog;
    private boolean ordered;

    public TypeSpec(AST name) {
        this(name, null, null);
    }

    public TypeSpec(TypeDescription real) {
        this(real, (Node)null);
    }

    public TypeSpec(AST name, AST parameters, AST arraySpec) {
        super(name, NList.make(parameters), NList.make(arraySpec));
    }

    TypeSpec() {
    }

    TypeSpec(TypeDescription type, Token token) {
        super(token);
        this.setTypeDescription(type);
    }

    TypeSpec(TypeDescription type, Node init) {
        this.setTypeDescription(type);
        if (init != null) {
            this.initialize(init);
            this.copyTreePositionFrom(init);
        }
    }

    public static String getAbstractConfigName(TypeDescription type) {
        String config = null;
        while (config == null && type != null) {
            config = type.asObject().getProperty("configName");
            type = type.getParent();
        }
        return config;
    }

    public static boolean isModule(TypeDescription type) {
        return type.isModule() || TypeSpec.isJavaPackage(type);
    }

    public static TypeDescription findType(Node name) throws TypeException {
        ObjectClass cl = name.getCurrentClass();
        TypeDescription context = cl != null ? cl.getTypeDescription() : null;
        TypeDescription result = TypeSpec.findType(name, null, null, false, context, name.getCatalog());
        if (cl != null) {
            cl.declareDependency(result);
        }
        return result;
    }

    public static TypeSpec make(AST typeName, AST parameters, AST arraySpec) {
        if (typeName instanceof TypeSpec && parameters == null && arraySpec == null) {
            return (TypeSpec)typeName;
        }
        return new TypeSpec(typeName, parameters, arraySpec);
    }

    @Override
    public String getText() {
        String result = this.ordered ? "ordered " : "";
        return result + "type";
    }

    @Override
    public String getTypeText() {
        return this.getTypeDescription().getText();
    }

    public void setOrdered(boolean v) {
        this.ordered = v;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    protected TypeDescription getDeclarationFor(Node child) {
        return this.getTypeDescription();
    }

    static void checkValid(TypeDescription type, Node node) {
        TypeSpec.checkValid(type, node, null);
    }

    static void checkValid(TypeDescription type, Node node, TypeDescription member) {
        TypeException error;
        if (type.isUnknown() || type.isNone()) {
            error = new MalformedTypeException(node, type);
            error.setMember(member);
            node.reportError(error);
        }
        if (TypeSpec.isModule(type)) {
            error = new InvalidDeclarationException(node, type);
            error.setMember(member);
            node.reportError(error);
        }
        if (type.isArray() || type.isIterator() || type.isSet()) {
            TypeDescription elementType = type.getElementType();
            TypeSpec.checkValid(elementType, node, member);
            TypeDescription indexType = type.getIndexType();
            if (indexType != null) {
                TypeSpec.checkValid(indexType, node, member);
            }
        }
    }

    static TypeDescription findType(Node name, TypeDescription[] typeParameters, int[] intParameters, boolean caseInsensitive, TypeDescription context, ComponentCatalog catalog) throws TypeException {
        String typeText;
        Node last;
        if (!(!(name instanceof TypeSpec) || intParameters != null && intParameters.length != 0 || typeParameters != null && typeParameters.length != 0)) {
            return name.getTypeDescription();
        }
        Completion completion = null;
        if (name instanceof QualifiedName && (last = name.getFirst().getLast()).isCompletion()) {
            completion = (Completion)last;
        }
        if ((typeText = name.getTypeText()) == null) {
            throw new NoSuchComponentException(name);
        }
        if (typeText.equals(context.getName())) {
            return context;
        }
        if (caseInsensitive) {
            int index;
            TypeRef foundType = TypeSpec.findNoFail(catalog, typeText.toUpperCase());
            if (foundType == null && (index = typeText.lastIndexOf(46)) != -1) {
                String module = typeText.substring(0, index);
                String last2 = typeText.substring(index + 1);
                foundType = TypeSpec.findNoFail(catalog, module + '.' + last2.toUpperCase());
            }
            if (foundType != null) {
                typeText = foundType.getText();
            }
        }
        TypeDescription result = TypeSpec.makeType(typeText, typeParameters, intParameters, name, context, catalog);
        if (completion != null && result != null) {
            name.setTypeDescription(result);
            completion.complete(12, name);
        }
        return result;
    }

    void setCatalog(ComponentCatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    ComponentCatalog getCatalog() {
        return this.catalog != null ? this.catalog : super.getCatalog();
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    @Override
    TypeDescription getDeclaration() {
        return this.getTypeDescription();
    }

    boolean isCaseInsensitive() {
        return false;
    }

    boolean isOrdered() {
        return this.ordered;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getParent() instanceof Deref) {
            return null;
        }
        if (this.getKind() != -1) {
            return this;
        }
        this.setTypeDescription(this.findType());
        return this;
    }

    TypeDescription findType() throws TypeException {
        ObjectClass cl = this.getCurrentClass();
        TypeDescription context = cl.getTypeDescription();
        return this.findType(context);
    }

    TypeDescription findType(TypeDescription context) throws TypeException {
        Node arraySpec;
        TypeDescription t;
        Node name = this.getOp1();
        if (name == null) {
            throw new InvalidNodeException(this);
        }
        if (name.isCompletion()) {
            name.complete(10, null);
        }
        if (name instanceof InvalidExpr) {
            name.checkType();
        }
        assert (name instanceof QualifiedName || name instanceof TypeSpec) : "Invalid AST: \n" + this.dump();
        Node parameters = this.getOp2();
        int[] intParameters = null;
        TypeDescription[] typeParameters = null;
        Node p = parameters.getFirst();
        if (p != null) {
            int i;
            if (p instanceof IntConst) {
                intParameters = new int[parameters.childCount()];
                i = 0;
                while (p != null) {
                    assert (p instanceof IntConst) : "Invalid AST";
                    intParameters[i++] = (int)((IntConst)p).getValue();
                    p = p.getNext();
                }
            } else if (p instanceof TypeSpec) {
                parameters = parameters.checkType();
                typeParameters = new TypeDescription[parameters.childCount()];
                i = 0;
                while (p != null) {
                    assert (p instanceof TypeSpec) : "Invalid AST";
                    typeParameters[i++] = p.getTypeDescription();
                    p = p.getNext();
                }
            } else assert (false) : "Invalid AST (parameters for TypeSpec)" + Node.show((AST)p);
        }
        ComponentCatalog catalog = this.getCatalog();
        TypeDescription result = TypeSpec.findType(name, typeParameters, intParameters, this.isCaseInsensitive(), context, catalog);
        if ("java".equals(result.getComponentType()) && !result.isEnum() && (t = TypeMappings.getType(result.getJavaType())) != null) {
            result = t;
        }
        if ((arraySpec = this.getOp3()) != null) {
            arraySpec = arraySpec.checkType();
            for (Node n = arraySpec.getFirst(); n != null; n = n.getNext()) {
                if (n instanceof Void) {
                    result = TypeFactory.getArray(result);
                    continue;
                }
                if (n instanceof TypeSpec) {
                    TypeSpec index = (TypeSpec)n;
                    TypeDescription indexType = index.getTypeDescription().primitiveEquivalent(false);
                    result = index.isOrdered() ? TypeFactory.getSortedMap(result, indexType) : TypeFactory.getMap(result, indexType);
                    continue;
                }
                assert (false) : "Illegal Node in AST - Should be a TypeSpec" + Node.show((AST)n);
            }
        }
        return result;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    private static boolean isJavaPackage(TypeDescription type) {
        String isPackage = type.isObject() ? type.asObject().getProperty("isPackage") : "";
        return "true".equals(isPackage);
    }

    private static TypeRef findNoFail(ComponentCatalog catalog, String typeText) {
        try {
            return catalog.find(typeText);
        }
        catch (AmbiguousTypeNameException e) {
            return null;
        }
    }

    private static TypeDescription makeType(String typeText, TypeDescription[] typeParameters, int[] intParameters, Node name, TypeDescription context, ComponentCatalog catalog) throws AmbiguousComponentNameException, NoSuchComponentException {
        TypeDescription result;
        try {
            LanguageSpec currentLanguage;
            boolean isModule;
            result = TypeFactory.forName(typeText, catalog, intParameters, typeParameters, context);
            if (typeParameters != null) {
                TypeRef[] parameters = result.getTypeParameters();
                if (parameters == null || parameters.length != typeParameters.length) {
                    name.reportError(new InvalidParameterException(name, typeText));
                }
            } else if (intParameters != null) {
                int length = intParameters.length;
                int expectedParamCount = result.getIntParameterCount();
                if (length != expectedParamCount) {
                    name.reportError(new InvalidParameterException(name, typeText));
                } else {
                    for (int i = 0; i < expectedParamCount; ++i) {
                        if (intParameters[i] == result.getIntParameter(i)) continue;
                        name.reportError(new InvalidParameterException(name, intParameters[i], typeText));
                    }
                }
            }
            boolean bl = isModule = result != null && result.isModule();
            if (isModule && (currentLanguage = name.getCurrentLanguage()) != null && currentLanguage.isOldTypePrecedenceEnabled()) {
                result = TypeSpec.findNoModule(typeText, catalog);
            }
        }
        catch (AmbiguousTypeNameException e) {
            result = TypeSpec.handleAmbiguousType(e, name);
        }
        catch (ComponentNotFoundException e) {
            throw (NoSuchComponentException)new NoSuchComponentException(name, typeText).initCause(e);
        }
        return result;
    }

    public static class Void
    extends TypeSpec {
        @Override
        public String getText() {
            return "void";
        }

        @Override
        public void generate(SourceGenerator cg) {
        }

        @Override
        Node checkType() throws TypeException {
            this.setTypeDescription(TypeFactory.getVoid());
            return this;
        }
    }

    public static class Time
    extends TypeSpec {
        public Time(Token token) {
            super(TypeFactory.getTime(), token);
        }
    }

    public static class Str
    extends TypeSpec {
        public Str(Token token) {
            super(TypeFactory.getString(), token);
        }
    }

    public static class Real64
    extends TypeSpec {
        public Real64(Token token) {
            super(TypeFactory.getPrimitiveReal(64), token);
        }
    }

    public static class Real32
    extends TypeSpec {
        public Real32(Token token) {
            super(TypeFactory.getPrimitiveReal(32), token);
        }
    }

    public static class Int8
    extends TypeSpec {
        public Int8(Token token) {
            super(TypeFactory.getPrimitiveInt(8), token);
        }
    }

    public static class Int64
    extends TypeSpec {
        public Int64(Token token) {
            super(TypeFactory.getPrimitiveInt(64), token);
        }
    }

    public static class Int32
    extends TypeSpec {
        public Int32(Token token) {
            super(TypeFactory.getPrimitiveInt(32), token);
        }
    }

    public static class Int16
    extends TypeSpec {
        public Int16(Token token) {
            super(TypeFactory.getPrimitiveInt(16), token);
        }
    }

    public static class Enum
    extends TypeSpec {
        public Enum(Token token) {
            super((TypeDescription)JavaEnumTypeDescription.create("", ""), token);
        }

        @Override
        public String getText() {
            return "enum(" + this.getTypeDescription().getName() + ')';
        }

        @Override
        Node checkType() throws TypeException {
            if (this.getTypeDescription().getName().length() > 0) {
                return this;
            }
            JavaEnumTypeDescription type = (JavaEnumTypeDescription)this.getTypeDescription();
            String name = this.getFirst().getText();
            type.setName(name);
            Node labels = this.getFirst().getNext();
            for (Node label = labels.getFirst(); label != null; label = label.getNext()) {
                type.addItem(label.getText());
            }
            this.setTypeDescription(type);
            return this;
        }
    }

    public static class Decimal
    extends TypeSpec {
        public Decimal(Token token) {
            super(TypeFactory.getDecimal(), token);
        }
    }

    public static class Char
    extends TypeSpec {
        public Char(Token token) {
            super(TypeFactory.getString(1), token);
        }
    }

    public static class CaseInsensitive
    extends TypeSpec {
        public CaseInsensitive(AST name) {
            super(name);
        }

        @Override
        boolean isCaseInsensitive() {
            return true;
        }
    }

    public static class Bool
    extends TypeSpec {
        public Bool(Token token) {
            super(TypeFactory.getPrimitiveBool(), token);
        }
    }

    public static class Any
    extends TypeSpec {
        public Any(Token token) {
            super(TypeFactory.getAny(), token);
        }
    }
}

