/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.DuplicatedTransformException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidTransformArgNameException;
import oracle.bpm.compiler.InvalidTransformArgumentException;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.MissingExpressionException;
import oracle.bpm.compiler.MissingSourcesException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotFunctionException;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFactory;

class Transform
extends Method {
    private static final long REQUIRED_MODS = 32832L;

    Transform(MethodTypeDescription transform, Node parent) {
        super(transform);
        this.setParent(parent);
        TransformTypeDescription transformType = (TransformTypeDescription)transform;
        int mappingCount = transformType.getFieldMappingCount();
        Block statements = Block.makeEmpty(this);
        SourceCode preCode = transformType.getBeginCode();
        if (preCode != null && !preCode.isEmpty()) {
            statements.addChild((AST)new PrePostCode(preCode, true));
        }
        for (int i = 0; i < mappingCount; ++i) {
            TransformTypeDescription.FieldMapping fieldMapping = transformType.getFieldMapping(i);
            SourceCode code = fieldMapping.getCode();
            if (code == null || code.isEmpty()) continue;
            statements.addChild((AST)new Mapping(fieldMapping, transformType));
        }
        SourceCode postCode = transformType.getEndCode();
        if (postCode != null && !postCode.isEmpty()) {
            statements.addChild((AST)new PrePostCode(postCode, false));
        }
        this.setBody(transform.getName(), statements);
    }

    static boolean isToString(TransformTypeDescription transform) {
        TypeDescription target = transform.getTarget();
        int srcc = transform.getSourceCount();
        return target.equals(TypeFactory.getString()) && srcc == 1 && transform.getSource(0).equals(transform.getParent());
    }

    @Override
    Node checkType() throws TypeException {
        int argc;
        TransformTypeDescription transform = (TransformTypeDescription)this.getMethodType();
        if ((transform.getModifiers() & 0x8040L) != 32832L) {
            this.reportError(new TypeException(this));
        }
        if ((argc = transform.getArgumentCount()) == 0) {
            this.reportError(new MissingSourcesException((Node)this, transform));
        }
        if (transform.getResultType().isVoid()) {
            this.reportError(new NotFunctionException((Node)this, this.getName()));
        }
        for (int i = 0; i < argc; ++i) {
            Argument arg = transform.getArgument(i);
            if (arg.isOut()) {
                this.reportError(new InvalidTransformArgumentException(this, arg, transform));
            }
            if (!arg.getName().equals(transform.getTargetName())) continue;
            this.reportError(new InvalidTransformArgNameException(this, arg, transform));
        }
        TypeDescription parent = transform.getParent();
        for (int i = 0; i < parent.getMemberCount(); ++i) {
            MethodTypeDescription member = parent.getMemberType(i);
            if (member == transform || !member.isTransformation() || !member.matchArguments(transform, false) || !transform.getTarget().equals(member.getResultType())) continue;
            this.reportError(new DuplicatedTransformException(this, transform, member));
        }
        return super.checkType();
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        TransformTypeDescription transf = (TransformTypeDescription)this.getMethodType();
        Block statements = this.getStatements();
        for (Node current = statements.getFirst(); current != null; current = current.getNext()) {
            current.parse(compiler);
        }
        Node result = new MemberReference("arg", transf.getResultArgument().getName());
        result = new Return(result, this.getResultType());
        statements.addChild((AST)result);
        this.addDeclarationsForVariables(transf);
        statements.setScope(this.getScope());
    }

    static class PrePostCode
    extends Node
    implements MessageListener {
        private final SourceCode code;
        private final boolean isPre;

        PrePostCode(SourceCode code, boolean isPre) {
            this.code = code;
            this.isPre = isPre;
        }

        @Override
        public void reportError(CilException e) {
            e.setSourceCode(this.code);
            e.setMemberPart(this.isPre ? 1 : 2);
            super.reportError(e);
        }

        @Override
        public void reportWarning(CilException e) {
            e.setSourceCode(this.code);
            super.reportWarning(e);
        }

        @Override
        Node checkType() throws TypeException {
            try {
                Block op1 = (Block)this.getOp1();
                op1 = (Block)op1.checkType(false);
                this.setFirst(op1);
            }
            catch (TypeException e) {
                this.reportError(e);
            }
            this.setTypeDescription(TypeFactory.getVoid());
            return this;
        }

        @Override
        void parse(FuegoCompiler compiler) throws CompilerException {
            SourceCode code = this.code;
            if (code != null && !code.isEmpty()) {
                try {
                    Node pre = compiler.parseMethod(code, false, this);
                    this.addOneChild(pre);
                }
                catch (CompilerParserException e) {
                    this.reportError(e);
                }
            }
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return this.getFirst().run(rm);
        }
    }

    static class Mapping
    extends Node
    implements MessageListener {
        private final TransformTypeDescription.FieldMapping mapping;
        private final TransformTypeDescription transform;

        public Mapping(TransformTypeDescription.FieldMapping mapping, TransformTypeDescription transform) {
            this.mapping = mapping;
            this.transform = transform;
        }

        @Override
        public void reportError(CilException e) {
            e.setSourceCode(this.mapping.getCode());
            e.setMember(this.transform);
            e.setMemberPart(3);
            e.setMemberPartName(this.mapping.getTargetField());
            super.reportError(e);
        }

        @Override
        public void reportWarning(CilException e) {
            e.setSourceCode(this.mapping.getCode());
            super.reportWarning(e);
        }

        TransformTypeDescription.FieldMapping getMapping() {
            return this.mapping;
        }

        TransformTypeDescription getTransform() {
            return this.transform;
        }

        @Override
        Node checkType() throws TypeException {
            Node mapping = this.getFirst();
            if (mapping != null) {
                try {
                    mapping = mapping.checkType();
                    this.setFirst(mapping);
                }
                catch (TypeException e) {
                    this.reportError(e);
                }
            }
            this.setTypeDescription(TypeFactory.getVoid());
            return this;
        }

        @Override
        void parse(FuegoCompiler compiler) throws CompilerException {
            SourceCode mappingCode = this.mapping.getCode();
            Node node = null;
            try {
                if (this.mapping.isExpression()) {
                    boolean isResultField;
                    node = compiler.parse(mappingCode, this);
                    if (node == null) {
                        throw new MissingExpressionException(this);
                    }
                    MemberReference target = new MemberReference("arg", this.transform.getTargetName());
                    TypeDescription targetType = this.transform.getTarget();
                    String targetField = this.mapping.getTargetField();
                    boolean bl = isResultField = targetType.isPredefined() && this.transform.getTargetName().equals(targetField);
                    if (!isResultField) {
                        Identifier member = new Identifier(targetField);
                        target = new MemberReference(target, member);
                    }
                    target.initialize(node);
                    node = new Assignment(target, node);
                } else {
                    node = compiler.parseMethod(mappingCode, false, this);
                }
            }
            catch (CompilerParserException e) {
                this.reportError(e);
            }
            this.setFirst(node);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return this.getFirst().run(rm);
        }
    }
}

