/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringCat;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.Time;
import oracle.bpm.type.TypeFactory;

public class Term
extends Diadic {
    boolean isSubstraction;
    private int operator;
    static final int TIME_SUB = 0;
    static final int INTERVAL_ADD = 1;
    static final int INTERVAL_SUB = 2;
    static final int TIME_INTERVAL_ADD = 3;
    static final int TIME_INTERVAL_SUB = 4;
    private static final String[] OPNAME = new String[]{":T-T:", ":I+I:", ":I-I:", ":T+I:", ":T-I:"};
    private static final String[] METHOD_NAME = new String[]{"Time.sub", "Interval.add", "Interval.sub", "Time.add", "Time.sub"};

    Term(Token t, boolean substraction) {
        super(t);
        this.isSubstraction = substraction;
        this.operator = -1;
    }

    public int getOperator() {
        if (this.operator < 0 || this.operator >= OPNAME.length) {
            throw new IllegalStateException("Invalid operator");
        }
        return this.operator;
    }

    @Override
    public String getText() {
        return this.operator != -1 ? OPNAME[this.operator] : (this.isSubstraction ? "-" : "+");
    }

    public boolean isSubstraction() {
        return this.isSubstraction;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    Node checkType() throws TypeException {
        Node result = null;
        if (this.getKind() != -1) {
            result = this;
        } else {
            super.checkType();
            Node op1 = this.getOp1();
            Node op2 = this.getOp2();
            int k1 = op1.getKind();
            int k2 = op2.getKind();
            if (Kind.isNumber(k1) && Kind.isNumber(k2)) {
                result = this.arithmetic(op1, op2);
            } else if (!(this.isSubstraction || k1 != 5 && k2 != 5)) {
                result = this.stringCat(op1, op2);
            } else if (k1 == 6 && k2 == 7 || !this.isSubstraction && k2 == 6 && k1 == 7) {
                result = this.timeInterval(op1, op2);
            } else if (k1 == 7 && k2 == k1) {
                result = this.interval(op1, op2);
            } else if (this.isSubstraction && k1 == 6 && k2 == k1) {
                result = this.time(op1, op2);
            }
            if (result == null) {
                throw new IncompatibleTypesException(this, op1, op2);
            }
        }
        return result;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    String getMethodName() {
        return METHOD_NAME[this.getOperator()];
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object op1 = this.getOp1().value(rm);
        Object op2 = this.getOp2().value(rm);
        Comparable<Interval> result = null;
        switch (this.getOperator()) {
            case 0: {
                result = Time.sub((Time)op1, (Time)op2);
                break;
            }
            case 1: {
                result = Interval.add((Interval)op1, (Interval)op2);
                break;
            }
            case 2: {
                result = Interval.sub((Interval)op1, (Interval)op2);
                break;
            }
            case 3: {
                result = Time.add((Time)op1, (Interval)op2);
                break;
            }
            case 4: {
                result = Time.sub((Time)op1, (Interval)op2);
            }
        }
        return result;
    }

    private Node arithmetic(Node op1, Node op2) throws TypeException {
        Arithmetic result = new Arithmetic(op1, this.isSubstraction ? 1 : 0, op2);
        result.initialize(this);
        result.copyParentFrom(this);
        result.setParenthesis(this.getParenthesis());
        return result.checkType();
    }

    private boolean evaluateConstant(Node op1, Node op2) {
        return !this.isGeneratingSource() && op1.isConstant() && op2.isConstant();
    }

    private Node interval(Node op1, Node op2) throws TypeException {
        Node result;
        int n = this.operator = this.isSubstraction ? 2 : 1;
        if (this.evaluateConstant(op1, op2)) {
            IntervalConst c1 = (IntervalConst)op1;
            result = c1.compute(this.operator, (IntervalConst)op2).dettach().checkType();
        } else {
            this.setTypeDescription(TypeFactory.getInterval());
            this.setOperands(op1, op2);
            result = this;
        }
        return result;
    }

    private Node stringCat(Node op1, Node op2) throws TypeException {
        return StringCat.make(Conversion.promote(op1, TypeFactory.getString()), Conversion.promote(op2, TypeFactory.getString()), this);
    }

    private Node time(Node op1, Node op2) throws TypeException {
        Node result;
        if (this.evaluateConstant(op1, op2)) {
            TimeConst c1 = (TimeConst)op1;
            result = c1.sub((TimeConst)op2).dettach().checkType();
        } else {
            this.operator = 0;
            this.setTypeDescription(TypeFactory.getInterval());
            this.setOperands(op1, op2);
            result = this;
        }
        return result;
    }

    private Node timeInterval(Node op1, Node op2) throws TypeException {
        Node result;
        if (op1.getTypeDescription().isInterval()) {
            Node tmp = op1;
            op1 = op2;
            op2 = tmp;
        }
        if (this.evaluateConstant(op1, op2)) {
            TimeConst c1 = (TimeConst)op1;
            IntervalConst c2 = (IntervalConst)op2;
            result = this.isSubstraction ? c1.sub(c2) : c1.add(c2);
            result = result.dettach().checkType();
        } else {
            this.operator = this.isSubstraction ? 4 : 3;
            this.setTypeDescription(TypeFactory.getTime());
            this.setOperands(op1, op2);
            result = this;
        }
        return result;
    }

    public static class Sub
    extends Term {
        public Sub(Token t) {
            super(t, true);
        }
    }

    public static class Add
    extends Term {
        public Add(Token t) {
            super(t, false);
        }
    }
}

