/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.compiler.MixedTablesException;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.NoSuchModuleException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotTableException;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TableNotFoundException;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.ColumnReference;
import oracle.bpm.type.TypeFactory;

public final class Tables
extends Node {
    private String abstractConfigName;
    private List<ObjectTypeDescription> tables;

    public Tables(Token t) {
        super(t);
    }

    Tables(Node table) {
        this.copyParentFrom(table);
        this.setFirst(table);
        table.setNext(null);
        this.initialize(table);
    }

    public static ColumnReference[] getColumnTypes(ObjectTypeDescription otd) {
        ArrayList<ColumnReference> members = new ArrayList<ColumnReference>();
        int length = otd.getMemberCount();
        for (int i = 0; i < length; ++i) {
            MethodTypeDescription member = otd.getMember(i);
            if (!member.isAttribute()) continue;
            int position = member.getPosition();
            assert (position >= 0) : "Invalid position: " + position + " for attribute " + member;
            int index = position - 1;
            while (index >= members.size()) {
                members.add(null);
            }
            members.set(index, new ColumnReference(otd, member, false));
        }
        return members.toArray(new ColumnReference[members.size()]);
    }

    public String getAbstractConfigName() {
        return this.abstractConfigName;
    }

    public TypeDescription getTable(int i) {
        return this.tables.get(i);
    }

    @Override
    public String getText() {
        return "tables";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    ColumnReference[] getColumnTypes() {
        return Tables.getColumnTypes(this.tables.get(0));
    }

    int getTablesCount() {
        if (this.tables != null) {
            return this.tables.size();
        }
        return 0;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        this.setTypeDescription(TypeFactory.getVoid());
        this.tables = new ArrayList<ObjectTypeDescription>(2);
        for (Node table = this.getFirst(); table != null; table = table.getNext()) {
            ObjectTypeDescription type;
            try {
                type = Tables.findTable(table);
            }
            catch (TableNotFoundException e) {
                type = Tables.findTable(table);
            }
            if (!ComponentType.SQL.getText().equals(type.getComponentType()) || type.getProperty("isSchema") != null) {
                throw new NotTableException(table);
            }
            if (this.abstractConfigName == null) {
                this.abstractConfigName = TypeSpec.getAbstractConfigName(type);
            } else if (!this.abstractConfigName.equals(TypeSpec.getAbstractConfigName(type))) {
                this.reportError(new MixedTablesException(table));
            }
            this.getSQLScope().addTable(type);
            this.tables.add(type);
            table.setTypeDescription(type);
        }
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        for (Node table = this.getFirst(); table != null; table = table.getNext()) {
            ObjectTypeDescription type = table.getObjectType();
            String name = type.getProperty("caseSensitiveName");
            boolean withoutSchema = Boolean.valueOf(type.getProperty("withoutSchemaName"));
            String schema = type.getProperty("schema");
            if (!withoutSchema && schema != null && !schema.isEmpty()) {
                name = "@SCHEMA@.@ESC@" + name + "@ESC@";
            }
            sql.append(name);
            if (table.getNext() == null) continue;
            sql.append(", ");
        }
    }

    private static ObjectTypeDescription findTable(Node table) throws TypeException {
        try {
            Node op1 = table.getOp1();
            if (op1 != null && op1.isCompletion()) {
                op1.complete(11, table);
            }
            table = table.checkType();
            return table.getObjectType();
        }
        catch (NoSuchModuleException exc) {
            throw new TableNotFoundException(table);
        }
        catch (NoSuchComponentException exc) {
            throw new TableNotFoundException(table);
        }
    }
}

