/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import oracle.bpm.lang.Str;

public class SourceWriter
extends PrintWriter {
    private boolean allowBreak;
    private String indentation = "";
    private String indentationElement = "    ";
    private int maxLength = 80;
    private int offset = 0;
    private String pending = null;
    private boolean printSeparator = false;
    private Stack<String> stack = new Stack();
    private static final String NL = "\n";

    public SourceWriter(PrintWriter writer) {
        super((Writer)writer, true);
    }

    public boolean isAllowBreak() {
        return this.allowBreak;
    }

    public int getEndOffset() {
        int result = this.offset;
        if (this.pending != null) {
            result += this.pending.length();
        }
        return result;
    }

    public int getOffset() {
        int result = this.offset;
        result = this.pending != null ? (result += this.pending.length()) : (result += this.indentation.length());
        return result;
    }

    public boolean allowBreak(boolean allow) {
        int length;
        if (allow && (length = this.length(this.pending)) > this.maxLength) {
            super.print(this.pending);
            this.offset += this.pending.length();
            super.print(NL);
            ++this.offset;
            this.pending = null;
        }
        boolean prev = this.allowBreak;
        this.allowBreak = allow;
        return prev;
    }

    @Override
    public void close() {
        if (this.pending != null) {
            super.print(this.pending);
            this.offset += this.pending.length();
        }
        super.flush();
        super.close();
    }

    public void dedent() {
        this.indentation = this.indentation.substring(this.indentationElement.length());
    }

    public void fixIndentation() {
        this.stack.push(this.indentation);
        this.indentation = Str.pad("", this.pending != null ? this.pending.length() : 0);
    }

    public void indent() {
        this.indentation = this.indentation + this.indentationElement;
    }

    @Override
    public void print(String text) {
        int index;
        if (this.printSeparator) {
            super.print(NL);
            ++this.offset;
            this.printSeparator = false;
        }
        if (this.pending == null) {
            this.pending = this.indentation;
        }
        if ((index = text.lastIndexOf(NL)) != -1) {
            if (index == text.length() - 1) {
                super.print(this.pending);
                this.offset += this.pending.length();
                super.print(text);
                this.offset += text.length();
                this.pending = null;
                return;
            }
            this.print(text.substring(0, index + 1));
            this.print(text.substring(index + 1));
        }
        int length = this.length(this.pending);
        if (this.allowBreak && length + text.length() > this.maxLength) {
            super.print(this.pending + NL);
            this.offset += this.pending.length() + 1;
            this.pending = this.indentation + text;
        } else {
            this.pending = this.pending + text;
        }
    }

    public void printQuoted(String text) {
        text = Str.replaceString(text, NL, "\\n");
        this.print("\"" + text + "\"");
    }

    public void printSeparator() {
        this.printSeparator = true;
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void println(String text) {
        this.print(text + NL);
    }

    public void unfixIndentation() {
        this.indentation = this.stack.pop();
    }

    private int length(String text) {
        return text != null ? text.length() : 0;
    }
}

