/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.compiler.Alias;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.DuplicatedColumnException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.InvalidColumnException;
import oracle.bpm.compiler.InvalidFunctionException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.TooFewColumnsException;
import oracle.bpm.compiler.TooManyColumnsException;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.ColumnReference;
import oracle.bpm.type.TypeFactory;

public class SelectColumns
extends Node {
    private boolean allColumns;
    private Set<ColumnReference> groupingcols;

    public SelectColumns(Token t) {
        super(t);
    }

    public SelectColumns(AST ast) {
        super(ast);
    }

    SelectColumns() {
    }

    @Override
    public String getText() {
        return "columns";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    boolean isAllColumns() {
        return this.allColumns || this.getFirst() == null;
    }

    void setGroupingColumns(ColumnReference[] cols) {
        if (cols == null) {
            return;
        }
        this.groupingcols = new HashSet<ColumnReference>(Arrays.asList(cols));
    }

    void addMembers(ObjectTypeDescription type) {
        int position = 1;
        NodeIterator columns = this.getChildren();
        HashMap<String, AttributeTypeDescription> duplicated = null;
        while (columns.hasNext()) {
            Node col = columns.next();
            ColumnReference ref = col.getColumnReference();
            if (ref == null) {
                assert (false) : "column '" + col + "' doesn't have a column ref";
                continue;
            }
            AttributeTypeDescription member = type.findAttribute(ref.getName().toLowerCase());
            if (member == null) {
                ref.addToObject(type);
            } else {
                if (duplicated == null) {
                    duplicated = new HashMap<String, AttributeTypeDescription>();
                }
                duplicated.put(ref.getName().toLowerCase(), member);
            }
            ref = ref.rename(String.valueOf(position));
            ref.addToObject(type);
            ++position;
        }
        if (duplicated != null) {
            for (MethodTypeDescription member : duplicated.values()) {
                MethodTypeDescription clone = member.clone();
                clone.setModifiers(member.getModifiers() | 0x100000L | 0x2000000L);
                clone.setProperty("deprecatedMessage", CompilerMsg.DUPLICATED_COLUMN(clone.getName()).getString());
                type.removeMember(member);
                type.addMember(clone);
            }
        }
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType((ColumnReference[])null);
    }

    Node checkType(ColumnReference[] reqTypes) throws TypeException {
        Map<String, Node> columnNames;
        if (this.getKind() != -1) {
            return this;
        }
        this.getScope().setOnlyLocal(true);
        if (this.getFirst() == null) {
            this.expandColumns();
            this.allColumns = true;
        }
        try {
            super.checkType();
        }
        catch (UndefinedVariableException e) {
            throw new InvalidColumnException(e.getNode());
        }
        this.setTypeDescription(TypeFactory.getVoid());
        int count = 0;
        NodeIterator columns = this.getChildren();
        Map<String, Node> map = columnNames = this.allColumns ? null : CollectionPool.getHashMap();
        while (columns.hasNext()) {
            String name;
            Node col = columns.next();
            TypeDescription colType = col.getTypeDescription();
            if (col instanceof Invoke) {
                throw new InvalidFunctionException(col, ((Invoke)col).getMethodName());
            }
            if (reqTypes != null) {
                if (count >= reqTypes.length) {
                    throw new TooManyColumnsException(this);
                }
                TypeDescription requiredType = reqTypes[count].getType();
                if (!requiredType.isAssignableFrom(colType)) {
                    throw new InvalidAssignmentException(col, colType, requiredType);
                }
            }
            ColumnReference ref = col.getColumnReference();
            if (this.groupingcols == null || ref == null || !this.groupingcols.contains(ref)) {
                // empty if block
            }
            if (ref == null) {
                name = "columnexpr" + count;
                Alias alias = new Alias(col, name);
                alias.setSynthetic(true);
                alias.setParent(this);
                columns.replace(alias.checkType());
            } else {
                name = ref.getName().toLowerCase();
                if (columnNames != null) {
                    Node prev = (Node)columnNames.get(name);
                    if (prev != null) {
                        if (!this.getCurrentLanguage().isLastVersion()) {
                            col.removeFromParent();
                        } else {
                            this.reportError(new DuplicatedColumnException(prev instanceof Alias ? prev.getOp2() : prev));
                            this.reportError(new DuplicatedColumnException(col instanceof Alias ? col.getOp2() : col));
                        }
                    }
                    columnNames.put(name, col);
                }
            }
            ++count;
        }
        CollectionPool.releaseHashMap(columnNames);
        if (reqTypes != null && count < reqTypes.length) {
            throw new TooFewColumnsException(this);
        }
        this.getSQLScope().setColumnCount(count);
        this.getScope().setOnlyLocal(false);
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        if (this.getFirst() == null) {
            query.append(" * ");
        } else {
            SelectColumns.generateCommaDelimitedSQL(this.getFirst(), query);
        }
    }

    private void expandColumns() {
        Node last = null;
        List<ObjectTypeDescription> types = this.getSQLScope().getTables();
        int length = types.size();
        for (int i = 0; i < length; ++i) {
            TypeDescription table = types.get(i);
            int count = table.getMemberCount();
            for (int j = 0; j < count; ++j) {
                MethodTypeDescription member = table.getMemberType(j);
                if (!member.isAttribute()) continue;
                String column = member.getName();
                StringBuilder idString = new StringBuilder(table.getName());
                for (TypeDescription parent = table.getParent(); parent != null; parent = parent.getParent()) {
                    idString.insert(0, parent.getName() + '.');
                }
                Identifier id = new Identifier(idString.toString(), this);
                id.setNext(new Identifier(column, this));
                QualifiedName qname = new QualifiedName((AST)id);
                SqlColumnReference current = new SqlColumnReference((AST)qname);
                current.setSynthetic(true);
                current.initialize(this);
                if (last != null) {
                    last.setNext(current);
                } else {
                    this.setFirst(current);
                }
                last = current;
            }
        }
    }
}

