/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeKit;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.Throw;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.Validation;

class RequireMethod
extends Method {
    private final MethodTypeDescription checkedMember;
    private final Validation[] requireCode;

    RequireMethod(ObjectClass current, MethodTypeDescription member) {
        super(member);
        MethodTypeDescription method = new MethodTypeDescription(member.getName() + "_require");
        method.addModifiers(16384L);
        method.addModifiers(0x100000000L);
        if (member.isStatic()) {
            method.addModifiers(64L);
        }
        method.setParent(current.getTypeDescription());
        if (member.isAttribute()) {
            method.addArgument(new Argument(member.getName(), member.getResultType(), 1L));
        } else {
            int argc = member.getArgumentCount();
            for (int i = 0; i < argc; ++i) {
                Argument arg = member.getArgument(i);
                if (!arg.isIn()) continue;
                method.addArgument(arg.copy());
            }
        }
        this.setMethodType(method);
        this.requireCode = member.getRequireCode();
        this.checkedMember = member;
    }

    static boolean needsNotNullCheck(AttributeTypeDescription attr) {
        return attr.isRequired() && !attr.getType().isPrimitive();
    }

    @Override
    Node checkType() throws TypeException {
        Node require = this.getFirst();
        MethodTypeDescription checkedMember = this.checkedMember;
        MethodTypeDescription member = this.getMethodType();
        Block body = new Block();
        this.setBody(member.getName(), body);
        if (checkedMember.isAttribute()) {
            AttributeTypeDescription attr = checkedMember.asAttribute();
            Node var = this.createArgumentRef(attr.getName());
            if (RequireMethod.needsNotNullCheck(attr)) {
                Throw throwException = CodeKit.createThrowException(null, checkedMember.getName());
                If notNullCheck = If.condition(Is.nullValue(var), throwException);
                body.addChild((AST)notNullCheck);
            } else {
                Block block = new Block();
                If nullCheck = If.condition(Is.notNull(var), block);
                body.addChild((AST)nullCheck);
                body = block;
            }
        }
        int count = 0;
        while (require != null) {
            Node next = require.getNext();
            String message = this.requireCode[count++].getMessage();
            Throw throwException = CodeKit.createThrowException(message, checkedMember.getName());
            If requireCheck = If.condition(Not.not(require), throwException);
            body.addChild((AST)requireCheck);
            require = next;
        }
        Scope scope = this.getScope();
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.setScope(scope);
        }
        return super.checkType();
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        for (Validation validation : this.requireCode) {
            try {
                if (validation.getText() == null) {
                    validation.setText(new char[0]);
                }
                Node expr = compiler.parse(validation, this);
                this.addChild((AST)expr);
            }
            catch (CompilerParserException e) {
                e.printStackTrace();
                e.setMember(this.getMethodType());
                this.reportError(e);
                this.addChild((AST)new BoolConst(true));
            }
        }
        for (Node node = this.getFirst(); node != null; node = node.getNext()) {
            node.setScope(this.getScope());
        }
    }
}

