/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.InvalidRegExpException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.Str;
import oracle.bpm.type.TypeFactory;

public final class RegExpConst
extends Const {
    RegExp regexp;
    String value;

    public RegExpConst(Token t) {
        this(t, t.getText());
    }

    private RegExpConst(Token t, String txt) {
        super(t, TypeFactory.wellKnown("RegExp"));
        this.value = txt;
        try {
            this.regexp = new RegExp(txt);
        }
        catch (RegExp.FormatException e) {
            this.exception = new InvalidRegExpException((Node)this, txt);
        }
    }

    @Override
    public String getText() {
        return this.value;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return super.toString() + this.value;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static RegExpConst append(RegExpConst a, RegExpConst b) {
        a.value = a.value + b.value;
        return a;
    }

    boolean equals(Node b) {
        return b instanceof RegExpConst && this.value.equals(((RegExpConst)b).value);
    }

    @Override
    int compare(Node b) {
        StringConst str = (StringConst)b;
        return this.value.compareTo(str.value);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        sql.append('\'').append(Str.escape(this.value)).append('\'');
    }

    @Override
    Object run(RunningMonitor rm) {
        return this.regexp;
    }
}

