/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Range
extends Diadic {
    public Range(Token t) {
        super(t);
    }

    Range() {
    }

    Range(Node from, Node to) {
        from.setNext(to);
        to.setNext(null);
        this.setFirst(from);
        this.initialize(from);
    }

    @Override
    public String getText() {
        return "range";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.getOp2());
    }

    @Override
    Node checkType() throws TypeException {
        super.checkType();
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        TypeDescription type1 = op1.getTypeDescription();
        TypeDescription type2 = op2.getTypeDescription();
        TypeDescription promotedType = type1.promote(type2);
        if (promotedType.isInt()) {
            op1 = Conversion.promote(op1, TypeFactory.getPrimitiveInt(32));
            op2 = Conversion.promote(op2, TypeFactory.getPrimitiveInt(32));
            this.setTypeDescription(TypeFactory.getPrimitiveInt(32));
        } else if (promotedType.isEnum()) {
            op1 = Conversion.promote(op1, promotedType);
            op2 = Conversion.promote(op2, promotedType);
            this.setTypeDescription(promotedType);
        } else {
            throw new IncompatibleTypesException(this, op1, op2);
        }
        this.setOperands(op1, op2);
        return this;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        this.getOp1().generateSQLCode(sql);
        sql.append(" AND ");
        this.getOp2().generateSQLCode(sql);
    }

    void promote(TypeDescription td) throws TypeException {
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        op1 = Conversion.promote(op1, td);
        op2 = Conversion.promote(op2, td);
        this.setTypeDescription(td);
        this.setOperands(op1, op2);
    }
}

