/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.NList;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;

public class QualifiedName
extends NList {
    String qName;

    public QualifiedName(AST ast) {
        super(ast);
    }

    public String getName() {
        if (this.qName == null) {
            StringBuilder result = new StringBuilder();
            for (Node n = this.getFirst(); n != null; n = n.getNext()) {
                if (n instanceof Completion) continue;
                if (result.length() != 0) {
                    result.append('.');
                }
                result.append(n.getText());
            }
            this.qName = result.toString();
        }
        return this.qName;
    }

    @Override
    public String getText() {
        return this.qName == null ? "qname" : this.qName;
    }

    @Override
    public String getTypeText() {
        return this.getName();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    Node checkType() throws TypeException {
        Identifier id = new Identifier(this.getName());
        id.setParent(this);
        id.initialize(this);
        return id.checkType();
    }
}

