/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.CompletionException;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.Template;
import oracle.bpm.compiler.TemplateParameter;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UnboundedParameterException;

public class Parameter
extends Node
implements TemplateParameter {
    private Completion completion;
    private Object mark;
    private boolean mustComplete;
    private String name;
    private int pasteLength;
    private int pasteOffset;
    private Node replacement;

    public Parameter(Token t) {
        super(t);
        this.name = t != null ? t.getText() : null;
        this.name = this.name == null ? "" : this.name;
    }

    Parameter(Node op) {
        this.setFirst(op);
    }

    Parameter(String name) {
        this.name = name;
    }

    Parameter(Node op, Completion completion) {
        assert (!(op instanceof Parameter)) : "Operand can not be a parameter";
        this.setFirst(op);
        this.completion = completion;
    }

    @Override
    public void setMark(Object mark) {
        this.mark = mark;
    }

    @Override
    public Object getMark() {
        return this.mark;
    }

    public void setMustComplete(boolean mustComplete) {
        this.mustComplete = mustComplete;
    }

    public boolean isMustComplete() {
        return this.mustComplete;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPasteLength() {
        return this.pasteLength;
    }

    @Override
    public void setPasteOffset(int offset) {
        this.pasteOffset = offset;
    }

    @Override
    public int getPasteOffset() {
        return this.pasteOffset;
    }

    @Override
    public String getText() {
        return this.name;
    }

    @Override
    public CompletionResult complete() {
        CompletionResult result = null;
        if (this.completion != null) {
            try {
                this.completion.complete(this);
            }
            catch (CompletionException e) {
                result = e.getResult();
            }
        }
        return result;
    }

    public boolean mustComplete() {
        return this.mustComplete;
    }

    @Override
    public String toString() {
        return "Parameter(" + this.name + ") \n" + this.dump();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    void setPasteLength(int pasteLength) {
        this.pasteLength = pasteLength;
    }

    @Override
    void bindParameters(Template refactor) {
        this.replacement = refactor.getParameter(this.name);
        this.replacement = Parameter.deepCopy(this.replacement);
    }

    @Override
    Node checkType() throws TypeException {
        if (this.replacement == null) {
            throw new UnboundedParameterException((Node)this, this.name);
        }
        return this.replacement;
    }

    static class FreeId
    extends Parameter {
        FreeId(String name) {
            super(name);
        }

        @Override
        Node checkType() throws TypeException {
            if (this.scope != null) {
                SymbolTable symbols = this.scope.getSymbolTable();
                String suffix = "";
                int count = 0;
                while (symbols.get(this.getName() + suffix) != null) {
                    suffix = String.valueOf(++count);
                }
            }
            return super.checkType();
        }
    }
}

