/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.DuplicatedDeclarationException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotThrowableException;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.CILUtils;

public class On
extends Ternary
implements Comparable<On> {
    private Symbol exception;
    private ClassConst exceptionClass;
    private Symbol legacyException;

    public On(Token t) {
        super(t);
    }

    public On(AST position, AST exception, AST id, AST block) {
        this.initialize(position);
        this.addChild(exception);
        this.addChild(id);
        this.addChild(block);
    }

    On() {
        this((Token)null);
    }

    On(String exception) {
        this((Token)null);
        this.setFirst(new Identifier(exception));
        this.getFirst().setNext(Block.makeEmpty(this));
    }

    public String getExceptionName() {
        return this.exception.getName();
    }

    public TypeDescription getExceptionType() {
        return this.getOp1().getTypeDescription();
    }

    @Override
    public String getText() {
        return "on" + (this.exception == null ? "" : '(' + this.exception.getName() + ')');
    }

    @Override
    public int compareTo(On that) {
        TypeDescription e2;
        if (that instanceof OnExit) {
            return -1;
        }
        TypeDescription e1 = this.getExceptionType();
        return e1.equals(e2 = that.getExceptionType()) ? 0 : (e2.isStrictSubtype(e1) ? 1 : -1);
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    Symbol getException() {
        return this.exception;
    }

    ClassConst getExceptionClass() {
        return this.exceptionClass;
    }

    String getExceptionComponentType() {
        return this.getExceptionType().asObject().getComponentType();
    }

    String getExceptionTypeSignature() {
        return this.getExceptionType().getSignature();
    }

    @Override
    void setScope(Scope scp) {
        if (this.getScope() != null) {
            return;
        }
        Block dad = (Block)this.getParent();
        DoBlock grampa = (DoBlock)dad.getParent();
        if (!grampa.isTopLevel()) {
            scp = grampa.getScope().getSuperScope().makeSubScope();
        }
        super.setScope(scp);
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node body = this.childCount() == 3 ? this.getOp3() : this.getOp2();
        body.checkFlow(context);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node name = this.getOp1();
        Node completion = name.getOp1();
        if (completion != null && completion.isCompletion()) {
            completion.complete(16, name);
        }
        Node id = this.getOp2();
        Node block = this.getOp3();
        name = name.checkType();
        TypeDescription exceptionType = name.getTypeDescription();
        boolean missingId = false;
        if (block == null) {
            block = id;
            id = new Identifier(this.findFreeId("e"), name);
            missingId = true;
        }
        String exceptionName = id.getText();
        if (exceptionType.getKind() != 10 && !Modifier.isException(exceptionType.getModifiers())) {
            throw new NotThrowableException(name, exceptionType);
        }
        if (Declaration.isDuplicated(id)) {
            this.reportWarning(new DuplicatedDeclarationException(id));
        }
        SymbolTable symbols = this.getSymbolTable();
        this.exception = new Symbol(exceptionName, exceptionType);
        this.exception.setSignature("on$exception" + this.getUniqueNumber());
        Symbol old = symbols.push(this.exception);
        Symbol old2 = null;
        if (missingId) {
            this.legacyException = new Symbol(exceptionType.getText(), exceptionType);
            this.legacyException.setSignature(this.exception.getSignature());
            this.legacyException.setReplacement(this.exception);
            old2 = symbols.push(this.legacyException);
        }
        block = block.checkType();
        symbols.pop(old);
        if (missingId) {
            symbols.pop(old2);
        }
        if (block instanceof NullStatement) {
            block = Block.makeEmpty(this);
        }
        this.exceptionClass = new ClassConst(exceptionType, (Node)this);
        this.setOperands(name, id, block);
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.exceptionClass != null) {
            this.exceptionClass.collectConstants(cp);
        }
    }

    Object run(RunningMonitor rm, Throwable throwable) throws ExecutionException {
        TypeDescription exceptionType = this.getExceptionType();
        boolean isinstanceof = CILUtils.isInstanceOf(throwable, exceptionType.asObject().getComponentType(), exceptionType.getSignature());
        Boolean caught = Boolean.FALSE;
        if (isinstanceof) {
            Symbol symbol = new Symbol(this.exception.getName(), exceptionType);
            Symbol legacy = this.legacyException != null ? new Symbol(this.legacyException.getName(), exceptionType) : null;
            Class exceptionClass = (Class)this.exceptionClass.run(rm, false);
            Object value = null;
            if (exceptionClass != null) {
                value = CILUtils.exception(throwable, exceptionClass);
            }
            symbol.setValue(value);
            SymbolTable symbols = this.getSymbolTable();
            Symbol old = symbols.push(symbol);
            Symbol old2 = null;
            if (legacy != null) {
                legacy.setReplacement(symbol);
                old2 = symbols.push(legacy);
            }
            this.getOp3().run(rm);
            symbols.pop(old);
            if (legacy != null) {
                symbols.pop(old2);
            }
            caught = Boolean.TRUE;
        }
        return caught;
    }
}

