/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.collections.sets.StringSet;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.Input;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.InputFields;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class ObjectInput
extends Diadic {
    private boolean replaceReference;
    private Node target;
    private static final String XO_INPUT_CLASS = "Fuego.Internal.XObjectInputImpl";
    private static final String XO_INPUT_METHOD = "input";
    private static final String XO_INPUT_OBJECT = "XObjectInputImpl";
    private static final String XO_INPUT_SELECTION_ATT = "selection";
    private static final String[] SYNTHETIC_ARGS = new String[]{"instance"};
    private static final String[] SYNTHETIC_OUT_ARGS = new String[]{"return"};

    public ObjectInput(Token t) {
        super(t);
    }

    ObjectInput() {
    }

    @Override
    public String getText() {
        return "object-input";
    }

    @Override
    public void generate(SourceGenerator cg) {
        Node instance;
        Args outargs;
        Args inargs;
        Node init = this.getOp1();
        Node invoke = this.getOp2();
        if (!(init instanceof If)) {
            invoke = init;
        }
        if (this.getKind() != -1) {
            Invoke invokeNode = (Invoke)invoke;
            inargs = invokeNode.getInputArgs();
            outargs = invokeNode.getOutputArgs();
            Arg arg = inargs.getArgByName("instance");
            instance = arg.getValue();
        } else {
            instance = this.getOp1();
            inargs = (Args)this.getOp2();
            outargs = inargs != null ? (Args)inargs.getNext() : null;
        }
        cg.generate(this, instance, inargs, outargs);
    }

    @Override
    protected String getStatementSeparator() {
        return null;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node init = this.getOp1();
        Node invoke = this.getOp2();
        if (!(init instanceof If)) {
            invoke = init;
        }
        super.checkFlow(context);
        Invoke invokeNode = (Invoke)invoke;
        context.breaksFlow(invokeNode.hasRelay());
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        this.setTypeDescription(TypeFactory.getVoid());
        Node op1 = this.getOp1();
        Args args = (Args)this.getOp2();
        Node xobject = op1.checkType();
        if (xobject == null) {
            TypeDescription typeSpec = TypeSpec.findType(op1);
            xobject = this.isGeneratingSource() ? new TypeSpec(typeSpec, op1) : MemberAccess.defaultInstanceFor(typeSpec, op1);
        } else if (xobject instanceof TypeSpec && !this.isGeneratingSource()) {
            xobject.setParent(this);
            xobject = LocalVar.create("xinstance", xobject.getTypeDescription(), xobject);
        }
        if (xobject instanceof LocalVar) {
            xobject = new Deref(xobject).checkType();
        }
        TypeDescription xobjType = xobject.getTypeDescription();
        TypeDescription presentable = this.loadPresentableType();
        if (!presentable.isAssignableFrom(xobjType)) {
            StringConst name = new StringConst(xobject.getText(), -1, this);
            InputField field = new InputField(name, xobject);
            InputFields fields = new InputFields();
            fields.setFirst(field);
            Input input = new Input();
            input.initialize(this);
            boolean isDeref = xobject instanceof Deref;
            input.addField(isDeref ? xobject.getOp1().getText() : xobject.getText(), this.getOp1());
            input.setArgs(args);
            input.setParent(this.getParent());
            return input.checkType();
        }
        Symbol sym = xobject.getSymbol();
        boolean xobjIsThis = sym != null && "this".equals(sym.getSignature());
        args = Args.ensureNotNullArgs(null, args, this.getScope());
        args.addInArgument("instance", xobject);
        args.setSyntheticArgs(SYNTHETIC_ARGS);
        Identifier id = new Identifier(XO_INPUT_OBJECT, this);
        id.getAutoDeclared(this.findType(XO_INPUT_CLASS), true);
        Node invoke = new Invoke(XO_INPUT_METHOD, XO_INPUT_OBJECT, args);
        invoke.initialize(this);
        invoke.setParent(this);
        Args outArgs = (Args)args.getNext();
        outArgs.setSyntheticArgs(SYNTHETIC_OUT_ARGS);
        this.target = Node.deepCopy(xobject);
        this.replaceReference = !outArgs.isRelay();
        Node init = null;
        if (!xobjIsThis) {
            Is isNull = Is.create(ObjectInput.deepCopy(this.target), new NullConst(this));
            init = new Assignment(ObjectInput.deepCopy(this.target), new DefaultConst(this, xobjType));
            init = If.condition(isNull, init);
            init.initialize(this);
        }
        if (outArgs.isRelay()) {
            String targetCil = outArgs.getFirst().getText();
            args = new Args(1L);
            args.setWasRelay(true);
            args.addInArgument(xobject);
            MemberReference selection = new MemberReference(id, new Identifier(XO_INPUT_SELECTION_ATT));
            selection.initialize(this);
            args.addInArgument(selection);
            Invoke targetInvoke = new Invoke(new Identifier(targetCil), new LocalVar(this.getThis(), this), args);
            targetInvoke.initialize(outArgs);
            targetInvoke.setParent(this);
            targetInvoke.checkType();
            MethodTypeDescription mtd = targetInvoke.getMemberType();
            assert (mtd.getArgumentCount() >= 2) : "The target CIL of an XO relay has less than two arguments. This condition should have been checked by now.";
            String instanceArg = mtd.getArgument(0).getName();
            String selectionArg = mtd.getArgument(1).getName();
            selection.initialize(this);
            NamedNode instance = new NamedNode(instanceArg, new Identifier("return"));
            instance.setNameType(mtd.getArgument(0).getType());
            outArgs.addInArgument(instance);
            NamedNode selectedButton = new NamedNode(selectionArg, new Identifier(XO_INPUT_SELECTION_ATT));
            outArgs.addInArgument(selectedButton);
        }
        Node resultRef = null;
        if (!outArgs.isRelay()) {
            LocalVar inputResult = LocalVar.create("inputResult", TypeFactory.getAny(), this);
            outArgs.addOutArgument(inputResult, "return");
            invoke = invoke.checkType();
            TypeDescription targetType = this.target.getTypeDescription();
            resultRef = new Conversion(new Deref(new LocalVar(inputResult.getSymbol(), this)), targetType);
            resultRef.setScope(this.getScope());
            resultRef.setParent(this);
            resultRef = ((Node)resultRef).checkType();
        } else {
            invoke = invoke.checkType();
        }
        if (init != null) {
            init.setParent(this);
            init = init.checkType();
            if (init == NullStatement.NODE) {
                this.setOperand(invoke);
            } else {
                this.setOperands(init, invoke, resultRef);
            }
        } else {
            this.setOperands(invoke, resultRef);
        }
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Node init = this.getOp1();
        Node input = this.getOp2();
        Node resultRef = this.getOp3();
        if (!(init instanceof If)) {
            resultRef = input;
            input = init;
            init = null;
        }
        if (init != null) {
            init.run(rm);
        }
        input.run(rm);
        if (this.replaceReference) {
            Invokeable resultInvokeable = (Invokeable)resultRef.value(rm);
            Invokeable targetInvokeable = (Invokeable)this.target.value(rm);
            StringSet allowedClasses = StringSet.create();
            allowedClasses.add(FuegoInvokeable.class.getName());
            JavaClass.replaceReference(resultInvokeable, targetInvokeable, allowedClasses);
        }
        return null;
    }

    private TypeDescription loadPresentableType() throws TypeException {
        TypeDescription type = this.findType("Fuego.Lang.Presentable");
        return type.get();
    }
}

