/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.List;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Node;

class NodeIterator {
    private List<Node> childrenList;
    private boolean copyLinks;
    private Node current;
    private Node father;
    private int index;
    private Node next;
    private Node previous;
    private boolean removed;

    NodeIterator(Node first, boolean copyLinks) {
        this(null, first, copyLinks);
    }

    NodeIterator(Node father, Node first, boolean copyLinks) {
        this.father = father;
        this.copyLinks = copyLinks;
        if (!copyLinks) {
            this.previous = null;
            this.current = null;
            this.next = first;
            return;
        }
        this.childrenList = CollectionPool.getArrayList();
        for (Node current = first; current != null; current = current.getNext()) {
            this.childrenList.add(current);
        }
        this.index = 0;
    }

    boolean hasNext() {
        boolean hasNext;
        if (!this.copyLinks) {
            return this.next != null;
        }
        boolean bl = hasNext = this.childrenList != null && this.index < this.childrenList.size();
        if (!hasNext) {
            CollectionPool.releaseArrayList(this.childrenList);
            this.childrenList = null;
        }
        return hasNext;
    }

    Node next() {
        if (!this.copyLinks) {
            this.removed = false;
            this.previous = this.current;
            this.current = this.next;
            this.next = this.next.getNext();
            return this.current;
        }
        return this.childrenList.get(this.index++);
    }

    void remove() {
        if (this.copyLinks) {
            throw new UnsupportedOperationException("remove() only works with copyLinks in false");
        }
        if (this.current == null) assert (false) : "You must execute next() before any remove()";
        if (this.removed) assert (false) : "Node already removed";
        this.removed = true;
        if (this.previous != null) {
            this.previous.setNext(this.next);
        } else if (this.father != null) {
            this.father.setFirst(this.next);
        }
        this.current.dettach();
        this.current = this.previous;
        this.previous = null;
    }

    Node replace(Node newnode) {
        if (this.copyLinks) {
            throw new UnsupportedOperationException("replace() only works with copyLinks in false");
        }
        if (this.current == null) assert (false) : "You must execute next() before any replace()";
        this.current = newnode;
        this.current.setNext(this.next);
        if (this.previous != null) {
            this.previous.setNext(this.current);
        } else if (this.father != null) {
            this.father.setFirst(this.current);
        }
        return newnode;
    }
}

