/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.ArrayReferenceException;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.ConstantAssignmentException;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.InvalidExpr;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.MemberArray;

public class MappedArrayReference
extends Diadic {
    private ClassConst elementClass;
    private String getter;
    private String setter;

    public MappedArrayReference(Token t) {
        super(t);
    }

    MappedArrayReference() {
    }

    MappedArrayReference(Node array, Node index) {
        this.copyParentFrom(array);
        this.setOperands(array, index);
        this.initialize(array);
    }

    MappedArrayReference(AST array, AST index) {
        this((Node)array, (Node)index);
    }

    public ClassConst getElementClass() {
        return this.elementClass;
    }

    public String getGetter() {
        return this.getter;
    }

    public String getSetter() {
        return this.setter;
    }

    @Override
    public String getText() {
        return "[]";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    Node checkType() throws TypeException {
        TypeDescription elementType;
        MethodTypeDescription memberType;
        Node array = this.getOp1();
        Node member = this.getOp2();
        Node op3 = this.getOp3();
        if (op3 != null) {
            if (op3 instanceof InvalidExpr && !member.isCompletion()) {
                op3.checkType();
            }
            this.reportError(new ConstantAssignmentException(member));
        }
        if ((array = array.checkType()) == null) {
            throw new UndefinedVariableException(this.getOp1());
        }
        TypeDescription arrayType = (array = array.externalNode()).getTypeDescription();
        if (!arrayType.isArray()) {
            throw new ArrayReferenceException(array, arrayType);
        }
        this.setOperands(array, member);
        if (member.isCompletion()) {
            member.complete(15, this);
        }
        if ((memberType = this.findMember(elementType = arrayType.getElementType(), member.getText(), 18, member)) == null) {
            throw MemberReferenceException.illegallMemberSearchClosest(elementType, member);
        }
        if (memberType.getArgumentCount() != 0) {
            throw new TypeException(this);
        }
        this.getter = MemberAccess.getSignature(elementType, memberType);
        if (memberType.isAttribute()) {
            this.setter = MemberAccess.getWriteSignature(elementType, memberType);
        }
        if (!memberType.isInvokeable()) {
            this.elementClass = new ClassConst(elementType.getJavaType(), (Node)this);
        }
        this.setTypeDescription(TypeFactory.getArray(memberType.getResultType()));
        return this;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.elementClass != null) {
            this.elementClass.collectConstants(cp);
        }
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(" ? ");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        List target = (List)this.getOp1().value(rm);
        Class cl = null;
        if (this.elementClass != null) {
            cl = (Class)this.elementClass.run(rm, false);
        }
        return MemberArray.create(target, this.getter, this.setter, cl);
    }
}

