/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidOperandException;
import oracle.bpm.compiler.InvalidParameterException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Log
extends Diadic {
    private static final String LOGGGER_COMPONENT = "Fuego.Internal.Logger";
    private static final String LOGGER_NAME = "$cilLogger";
    private static final String[] SYNTHETIC_ARGS = new String[]{"message"};

    public Log(Token t) {
        super(t);
    }

    Log() {
    }

    @Override
    public String getText() {
        return "log";
    }

    @Override
    public void generate(SourceGenerator cg) {
        Node message;
        Args inargs;
        if (this.getKind() != -1) {
            Invoke invoke = (Invoke)this.getOp1();
            inargs = invoke.getInputArgs();
            Arg msgArg = inargs.getArgByName("message");
            message = msgArg.getValue();
        } else {
            message = this.getOp1();
            inargs = (Args)this.getOp2();
        }
        cg.generate(this, message, inargs);
    }

    @Override
    Node checkType() throws TypeException {
        this.setTypeDescription(TypeFactory.getVoid());
        Node message = this.getOp1();
        Node op2 = this.getOp2();
        if (op2 != null && !(op2 instanceof Args)) {
            throw new InvalidParameterException((Node)this, this.getStatementName());
        }
        Args args = (Args)op2;
        if ((message = message.checkType()).getKind() != 5) {
            throw new InvalidOperandException((Node)this, message.getKind());
        }
        if (args == null || args.isOut()) {
            Args inArgs = new Args(1L);
            inArgs.setNext(args);
            args = inArgs;
        }
        Node first = args.getFirst();
        NamedNode namedNode = new NamedNode("message", message);
        args.setFirst(namedNode);
        namedNode.setNext(first);
        namedNode.initialize(args);
        args.setSyntheticArgs(SYNTHETIC_ARGS);
        TypeDescription type = this.findType(LOGGGER_COMPONENT);
        if (type == null) {
            Identifier component = new Identifier(LOGGGER_COMPONENT);
            component.initialize(this);
            throw new NoSuchComponentException(component);
        }
        Identifier.autodeclare(LOGGER_NAME, type.get(), this, true);
        Invoke result = new Invoke("log", LOGGER_NAME, args);
        result.initialize(this);
        result.setParent(this);
        this.setFirst(((Node)result).checkType());
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        this.getFirst().gen(cg);
    }

    private String getStatementName() {
        return this.getCurrentLanguage().getTokenNames().logSymbol;
    }
}

