/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.bcgen.MDKit;
import oracle.bpm.bcgen.Mod;
import oracle.bpm.bcgen.ModSet;
import oracle.bpm.bcgen.TDKit;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.BaseCodeGenerator;
import oracle.bpm.compiler.BitwiseNot;
import oracle.bpm.compiler.BitwiseOp;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeKit;
import oracle.bpm.compiler.Comp;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.Dup;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.ExprIf;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.In;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.JavaConstGenerator;
import oracle.bpm.compiler.JavaConversionGenerator;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.JavaPrintWriter;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.MappedArrayReference;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.ObjectConstructor;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.Pop;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.SQLStatement;
import oracle.bpm.compiler.Select;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.StringCat;
import oracle.bpm.compiler.Switch;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Term;
import oracle.bpm.compiler.Throw;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnaryArithmetic;
import oracle.bpm.compiler.While;
import oracle.bpm.io.ReferenceManager;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArgumentMapUtil;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.IterablesByFilterRegistry;
import oracle.bpm.util.DebugValue;
import oracle.bpm.util.PrimitiveTypeUtils;
import oracle.bpm.util.langsupport.LocalStack;

public class JavaGenerator
extends BaseCodeGenerator {
    final JavaPrintWriter pw;
    private String currentDelimiter;

    public JavaGenerator(JavaPrintWriter javaPrintWriter, boolean testMode) {
        super(testMode);
        this.pw = javaPrintWriter;
        this.constGenerator = new JavaConstGenerator(this);
        this.conversionGenerator = new JavaConversionGenerator(this);
        this.currentDelimiter = ";";
    }

    public JavaPrintWriter getPrintWriter() {
        return this.pw;
    }

    @Override
    public void emitLineNumber(int line) {
    }

    public void generateArrayMetadata(TypeDescription type, String name, ModSet modifiers, String defaultValue, JavaPrintWriter pw) {
        if (!type.isPrimitive() && !modifiers.has(Mod.STATIC)) {
            TypeDescription elementType;
            if (type.getKind() == 13) {
                pw.print("private static final ");
                pw.printJavaType(type.getIndexType());
                pw.print(' ');
                pw.print(name);
                pw.print("_INDEX_ = ");
                if (type.isPrimitive()) {
                    pw.print(type.getInitialization().javaInitString(type));
                } else {
                    pw.print("null");
                }
                pw.println(";");
            }
            if ((elementType = type.getElementType()) != null) {
                pw.print("private static final ");
                pw.printJavaType(elementType);
                pw.print(' ');
                pw.print(name);
                pw.print("_ELEMENT_ = ");
                if (defaultValue == null) {
                    if ((elementType.isNumber() || elementType.isEnum()) && elementType.isPrimitive()) {
                        pw.print("0");
                    } else if (elementType.isBool() && elementType.isPrimitive()) {
                        pw.print("false");
                    } else {
                        pw.print("null");
                    }
                } else {
                    Const c = Const.valueOf(defaultValue, elementType, null);
                    c.gen(this);
                }
                pw.println(";");
            }
        }
    }

    @Override
    public void generate(Return returnNode) {
        assert (returnNode.hasType());
        this.pw.print("return");
        Node expr = returnNode.getFirst();
        if (expr != null) {
            this.pw.print(' ');
            expr.gen(this);
        }
    }

    @Override
    public void generate(Method method) {
        assert (method.compiled) : "method is not compiled";
        MethodTypeDescription member = method.getMethodType();
        boolean isServer = member.hasModifiers(65536L);
        JavaGenerator.generateAccessModifiers(method, this.pw);
        JavaGenerator.generateMethodSignature(method, this.pw);
        this.generateMethodImpl(method, isServer, member);
        this.pw.println();
        if (Modifier.isVirtual(member.getModifiers())) {
            this.generateArrayMetadata(member.getResultType(), member.getName(), method.getAccessModifiers(), null, this.pw);
        }
        if (method.isGenerateAdaptor()) {
            this.generateDynamicAdaptor(method);
        }
    }

    @Override
    public void generate(Node node) {
        this.generate(node, "");
    }

    @Override
    public void generate(Arithmetic arithmetic) {
        Node op1 = arithmetic.getOp1();
        Node op2 = arithmetic.getOp2();
        if (arithmetic.isDecimal()) {
            this.pw.printFunctionCall("Decimal." + arithmetic.getOpMethod(), op1, op2, this);
        } else {
            this.pw.print("( ");
            this.pw.printBinaryOp(op1, arithmetic.getText(), op2, this);
            this.pw.print(") ");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(ObjectClass objectClass) {
        void var10_18;
        boolean hasEmptyConstructor;
        boolean genBitSets;
        boolean topLevel = objectClass.isTopLevel();
        ObjectTypeDescription objType = objectClass.getObjectType();
        JavaPrintWriter pw = this.pw;
        if (topLevel) {
            pw.setIndentationString("    ");
            String pkg = objType.getJavaPackage();
            if (pkg != null) {
                pw.println("package " + pkg + ';');
                pw.println();
            }
            pw.printImports();
        }
        pw.println();
        pw.print("public ");
        if (!topLevel) {
            pw.print("static ");
        }
        pw.print("class ");
        pw.println(objType.getName());
        int javaIfacesCount = 0;
        for (SuperType superType : objType.getSuperTypes()) {
            if (!superType.getType().isInterface()) continue;
            ++javaIfacesCount;
        }
        TypeDescription javaBaseType = ObjectClass.findJavaBaseType(objType);
        if (javaBaseType != null) {
            pw.indent();
            pw.print("extends ");
            pw.printJavaType(javaBaseType);
            pw.println();
            pw.dedent();
        }
        int n = javaIfacesCount = (genBitSets = objectClass.isGenerateBitSets()) ? javaIfacesCount + 1 : javaIfacesCount;
        if (javaIfacesCount > 0) {
            pw.indent();
            pw.print("implements ");
            int generatedIfaces = 0;
            for (SuperType superType : objType.getSuperTypes()) {
                if (generatedIfaces >= javaIfacesCount || !superType.getType().isInterface()) continue;
                if (generatedIfaces > 0) {
                    pw.print(", ");
                }
                ++generatedIfaces;
                pw.printJavaType(superType.getType());
            }
            if (genBitSets) {
                if (generatedIfaces > 0) {
                    pw.print(", ");
                }
                pw.printJavaType(TDKit.MODIFIABLE_INTERFACE);
                ++generatedIfaces;
            }
            if (objectClass.isReplaceable()) {
                if (generatedIfaces > 0) {
                    pw.print(", ");
                }
                pw.printJavaType(TDKit.REPLACEABLE_INTERFACE);
                ++generatedIfaces;
            }
            if (Modifier.isComparable(objType.getModifiers())) {
                if (generatedIfaces > 0) {
                    pw.print(", ");
                }
                pw.printJavaType(Comparable.class.getName());
            }
            pw.println();
            pw.dedent();
        }
        pw.println("{");
        pw.println();
        pw.indent();
        String customizeReadObject = objType.getProperty("customizeReadObject");
        if ((customizeReadObject == null || !Boolean.valueOf(customizeReadObject).booleanValue()) && ReferenceManager.isDebugEnabled()) {
            pw.println("public transient String creationStack = oracle.bpm.util.StackTrace.getStackTrace();");
            pw.println("private void readObject(java.io.ObjectInputStream in)");
            pw.indent();
            pw.println("throws java.io.IOException, java.lang.ClassNotFoundException");
            pw.dedent();
            pw.println("{");
            pw.indent();
            pw.println("in.defaultReadObject();");
            pw.println("this.creationStack = oracle.bpm.util.StackTrace.getStackTrace();");
            pw.dedent();
            pw.println("}");
        }
        if (objectClass.hasMappings()) {
            pw.println("private static final Map _MAPPINGS = ArrayUtils.asMap(new Object[] {");
            pw.indent();
            for (Map.Entry entry : objectClass.getMappings().entrySet()) {
                pw.printQuoted((String)entry.getKey());
                pw.print(", ");
                pw.printQuoted((String)entry.getValue());
                pw.println(",");
            }
            pw.dedent();
            pw.println("});");
        }
        if (!(hasEmptyConstructor = objectClass.hasEmptyConstructor())) {
            pw.print("private ");
            pw.print(objType.getName());
            pw.println("() {}");
            pw.println();
        }
        Node node = objectClass.getFirst();
        while (var10_18 != null) {
            try {
                objectClass.generatingMessage((Node)var10_18);
                var10_18.gen(this);
            }
            catch (Throwable e) {
                objectClass.reportError(new InternalException((Node)var10_18, e));
            }
            Node node2 = var10_18.getNext();
        }
        pw.dedent();
        pw.println();
        pw.println("}");
    }

    @Override
    public void generate(DoBlock doBlock) {
        Block declarations = doBlock.getDeclarations();
        Block statements = doBlock.getStatements();
        Block exceptions = doBlock.getExceptions();
        OnExit onExit = doBlock.getOnExit();
        this.pw.println("{");
        this.pw.indent();
        if (doBlock instanceof Method) {
            this.generateBlockHeader((Method)doBlock);
        }
        if (doBlock.wrapTypedExceptions()) {
            this.pw.println("try {");
            this.pw.indent();
        }
        if (declarations.hasChildren()) {
            this.pw.println();
            this.pw.println("// declarations");
            declarations.gen(this);
            this.pw.println();
        }
        if (statements.hasChildren()) {
            this.pw.printLabel(doBlock.name);
        }
        if (exceptions != null && exceptions.hasChildren() || onExit != null) {
            this.pw.print("try ");
        }
        this.generateStatements(statements);
        if (exceptions != null && exceptions.hasChildren()) {
            String exceptionName = "e$throwable" + doBlock.getUniqueNumber();
            this.pw.println("catch (Throwable " + exceptionName + ')');
            this.pw.println("{");
            this.pw.indent();
            boolean first = true;
            for (Node n = exceptions.getFirst(); n != null; n = n.getNext()) {
                On current = (On)n;
                this.generateCatchClause(current, exceptionName, first);
                first = false;
            }
            this.pw.println(first ? "{" : "else {");
            this.pw.indent();
            this.pw.print("throw ");
            this.pw.print(exceptionName);
            this.pw.println(";");
            this.pw.dedent();
            this.pw.println("}");
            this.pw.dedent();
            this.pw.println("}");
        }
        if (onExit != null) {
            this.pw.println("finally {");
            this.pw.indent();
            onExit.getFirst().gen(this);
            this.pw.dedent();
            this.pw.println("}");
        }
        if (doBlock.wrapTypedExceptions()) {
            this.pw.dedent();
            this.pw.println("} catch (Throwable __e) {");
            this.pw.indent();
            this.pw.print("throw new java.lang.RuntimeException(");
            this.pw.print("__e");
            this.pw.println(");");
            this.pw.dedent();
            this.pw.println("}");
        }
        this.pw.dedent();
        if (doBlock instanceof Method) {
            this.generateBlockFooter((Method)doBlock);
        }
        this.pw.println("}");
    }

    @Override
    public void generate(Declaration declaration) {
        FlowContext.Variable var = declaration.getVariable();
        if (var == null || var.needsCode()) {
            Symbol symbol = declaration.getSymbol();
            if (symbol.isExternalArgument()) {
                if (var != null && var.needsInitialization()) {
                    declaration.getInit().gen(this);
                }
            } else if (symbol.isHolder()) {
                String holderJavaType = symbol.getArgument().getHolderJavaType();
                this.pw.printJavaType(holderJavaType);
                this.pw.print(' ' + symbol.getSignature());
                this.pw.print(" = ");
                this.pw.print("new ");
                this.pw.printJavaType(holderJavaType);
                this.pw.print("(");
                if (var != null && var.needsInitialization()) {
                    declaration.getInit().gen(this);
                }
                this.pw.print(")");
            } else {
                this.pw.printJavaType(declaration.getTypeDescription());
                this.pw.print(' ' + symbol.getSignature());
                if (var != null && var.needsInitialization()) {
                    this.pw.print(" = ");
                    declaration.getInit().gen(this);
                }
            }
        }
    }

    @Override
    public void generate(Identifier identifier) {
        this.pw.print(identifier.getText());
    }

    @Override
    public void generate(Deref deref) {
        Node op1 = deref.getOp1();
        TypeDescription type = op1.getTypeDescription();
        Symbol symbol = op1.getSymbol();
        if (symbol != null && symbol.isHolder()) {
            boolean needsConversion;
            this.pw.print('(');
            boolean bl = needsConversion = !type.isPrimitive() && (type.isInt() || type.isReal());
            if (needsConversion) {
                JavaConversionGenerator.printConversionCall(type, this.pw);
                this.pw.print("(");
            } else {
                this.pw.printJavaCast(type);
            }
            op1.gen(this);
            if (symbol.isLazyHolder()) {
                this.pw.print(".get()");
            } else {
                this.pw.print(".value");
            }
            if (needsConversion) {
                this.pw.print(")");
            }
            this.pw.print(')');
        } else {
            op1.gen(this);
        }
    }

    @Override
    public void generate(LocalVar localVar) {
        this.pw.print(localVar.getTarget().getSignature());
    }

    @Override
    public void generate(Invoke.ConstructorCall constructorCall) {
        Invoke invoke = constructorCall.getInvoke();
        TypeDescription objType = invoke.getObjType();
        if (invoke.hasInstanceCreator()) {
            Node op = invoke.getCreatorOperator();
            this.pw.printJavaCast(op.getTypeDescription().getElementType());
            op.gen(this);
            this.pw.print(".createNewElement()");
        } else if (invoke.isDynamic()) {
            String[] parameters;
            this.pw.printJavaType("oracle.bpm.component.Component");
            this.pw.print(".");
            if (invoke.isRemote()) {
                this.pw.print("instantiateRemoteDynamic(");
            } else {
                this.pw.print("instantiateDynamic(");
            }
            for (String parameter : parameters = constructorCall.dynamicConstructorParameters()) {
                this.pw.printQuoted(Str.escape(parameter));
                this.pw.print(", ");
            }
            if (!invoke.hasInputArgs()) {
                this.pw.print("null");
            } else {
                this.pw.println();
                this.pw.println("new Object[] { ");
                this.pw.indent();
                this.generateInputArgsCode(invoke);
                this.pw.dedent();
                this.pw.println("}");
            }
            this.pw.print(")");
        } else {
            this.pw.print("new ");
            this.pw.printJavaType(objType);
            this.pw.print('(');
            if (objType.isInnerType()) {
                this.pw.print("this");
                if (invoke.hasInputArgs()) {
                    this.pw.print(", ");
                }
            }
            this.generateInputArgsCode(invoke);
            this.pw.print(')');
        }
    }

    @Override
    public void generate(Invoke.MethodCall methodCall) {
        Invoke invoke = methodCall.getInvoke();
        Node objectNode = invoke.getObject();
        MethodTypeDescription memberType = invoke.getMemberType();
        if (invoke.isDynamic()) {
            boolean relayTo = invoke.hasRelay();
            if (relayTo) {
                this.pw.println("throw new " + MDKit.RELAY_TO_THROWABLE.getName() + '(');
                this.pw.indent();
                if (!methodCall.getCurrentMember().isStatic()) {
                    this.pw.println("this,");
                }
                this.generateObjectReference(invoke);
                this.pw.println(",");
            } else {
                TypeDescription result;
                if (!(invoke.isStatement() || (result = methodCall.getTypeDescription()).isVoid() || result.isObject())) {
                    this.pw.printJavaCast(result);
                }
                this.generateObjectReference(invoke);
                this.pw.println(".invoke(");
                this.pw.indent();
            }
            this.pw.printQuoted(Str.escape(MemberAccess.getSignature(invoke.objType, memberType)));
            this.pw.print(", ");
            if (!relayTo) {
                this.pw.println(methodCall.getSynchronous() + ", ");
                this.pw.indent();
            }
            if (!invoke.hasInputArgs()) {
                this.pw.print("null");
            } else {
                this.pw.println();
                this.pw.printNewArray("java.lang.Object");
                this.pw.println(" { ");
                this.pw.indent();
                this.generateInputArgsCode(invoke);
                this.pw.dedent();
                this.pw.print("}");
            }
            if (!relayTo) {
                this.pw.println(",");
                this.pw.println(invoke.returnArray == null ? "null" : invoke.returnArray.getSignature());
            } else {
                this.pw.println(",");
                this.pw.printQuoted(invoke.getTargetCIL().getText());
                this.pw.println(",");
                Invoke targetInvoke = invoke.getTargetInvoke();
                if (!targetInvoke.hasInputArgs()) {
                    this.pw.println("null");
                } else {
                    this.pw.printNewArray("java.lang.Object");
                    this.pw.print(" {");
                    this.pw.indent();
                    Args inputArgs = targetInvoke.getInputArgs();
                    String[] argSignatures = inputArgs.getBindings();
                    int i = 0;
                    for (Arg arg = (Arg)inputArgs.getFirst(); arg != null; arg = (Arg)arg.getNext()) {
                        Argument sourceArg = arg.getSourceArgument();
                        if (sourceArg == null) {
                            this.pw.print("new Any.Holder(");
                            arg.getValue().gen(this);
                            this.pw.print(")");
                        } else {
                            this.pw.printQuoted(argSignatures[i++]);
                        }
                        this.pw.print(", ");
                        this.pw.printQuoted(argSignatures[i++]);
                        if (i < argSignatures.length) {
                            this.pw.print(", ");
                        }
                        this.pw.println();
                    }
                    this.pw.dedent();
                    this.pw.println("}");
                }
            }
            this.pw.dedent();
            this.pw.print(")");
            if (!relayTo) {
                this.pw.dedent();
            }
        } else {
            this.generateObjectReference(invoke);
            this.pw.print(".");
            this.pw.print(invoke.getMethodSignature() + '(');
            if (invoke.isDelegated()) {
                objectNode.gen(this);
                if (invoke.hasInputArgs()) {
                    this.pw.print(", ");
                }
            }
            this.generateInputArgsCode(invoke);
            this.pw.print(")");
        }
    }

    @Override
    public void generate(StringCat stringCat) {
        this.pw.printFunctionCall("Str.concat", stringCat.getOp1(), stringCat.getOp2(), this);
    }

    @Override
    public void generate(CodeKit.CloneCall cloneCall) {
        this.pw.print("Any.deepCopy(");
        cloneCall.getOp1().gen(this);
        this.pw.print(")");
    }

    @Override
    public void generate(FieldDeclaration fieldDeclaration) {
        ModSet modifiers = fieldDeclaration.getFieldModifiers();
        this.pw.print(modifiers.toString().toLowerCase());
        this.pw.print(" ");
        TypeDescription type = fieldDeclaration.getTypeDescription();
        this.pw.printJavaType(type);
        String name = fieldDeclaration.getName();
        this.pw.print(' ' + name);
        Node initialValue = fieldDeclaration.getInitialValue();
        if (initialValue != null) {
            this.pw.print(" = ");
            if (initialValue instanceof Const) {
                ((Const)initialValue).generate(this.constGenerator);
            } else {
                initialValue.gen(this);
            }
        }
        this.pw.println(";");
        String defaultValue = null;
        if (fieldDeclaration.getAttribute() != null) {
            defaultValue = fieldDeclaration.getDefaultValue();
        }
        this.generateArrayMetadata(type, name, modifiers, defaultValue, this.pw);
    }

    @Override
    public void generate(Logic node) {
        this.pw.print("( ");
        node.getOp1().gen(this);
        this.pw.print(' ' + node.getOperatorSymbol() + ' ');
        node.getOp2().gen(this);
        this.pw.print(" )");
    }

    @Override
    public void generate(Not not) {
        this.pw.print("( ! ");
        not.getFirst().gen(this);
        this.pw.print(" )");
    }

    @Override
    public void generate(If node) {
        this.pw.print("if (");
        node.getOp1().gen(this);
        this.pw.println(")");
        this.pw.printBlock(node.getOp2(), this);
        Node elseBlock = node.getOp3();
        if (elseBlock != NullStatement.NODE) {
            this.pw.println("else");
            this.pw.printBlock(node.getOp3(), this);
        }
    }

    @Override
    public void generate(Throw node) {
        if (node.isUserDefined()) {
            this.pw.print("throw new oracle.bpm.lang.RuntimeCILExecutionException(");
            node.getFirst().gen(this);
            this.pw.println(")");
        } else {
            this.pw.print("throw ");
            node.getFirst().gen(this);
        }
    }

    @Override
    public void generate(Comp node) {
        Node op1 = node.getOp1();
        Node op2 = node.getOp2();
        String operator = node.getOperator().getSymbol();
        this.pw.print("(");
        if (op1.getTypeDescription().isPrimitive()) {
            this.pw.printBinaryOp(op1, operator, op2, this);
        } else if (node.isLike()) {
            if (node.isNotLike()) {
                this.pw.print("!");
            }
            this.pw.printFunctionCall("CILUtils.like", op1, op2, this);
        } else {
            this.pw.printFunctionCall("Any.compare", op1, op2, this);
            this.pw.print(operator);
            this.pw.print("0");
        }
        this.pw.print(" )");
    }

    @Override
    public void generate(Equality node) {
        Node o1 = node.getOp1();
        Node o2 = node.getOp2();
        TypeDescription ot = o1.getTypeDescription();
        if (ot.isPrimitive() && !ot.isString()) {
            this.pw.print("( ");
            String operator = node.isEquals() ? "==" : "!=";
            this.pw.printBinaryOp(o1, operator, o2, this);
            this.pw.print(" )");
        } else {
            if (!node.isEquals()) {
                this.pw.print("! ");
            }
            this.pw.printFunctionCall("Any.equals", o1, o2, this);
        }
    }

    @Override
    public void generate(Is node) {
        TypeDescription targetType = node.getTargetType();
        if (targetType == TypeFactory.getNull()) {
            this.pw.print("( ");
            node.getOp1().gen(this);
            this.pw.print(' ' + (node.isNegative() ? "!=" : "==") + " null");
        } else {
            if (node.isNegative()) {
                this.pw.print('!');
            }
            if (targetType.isInvokeable()) {
                this.pw.print("Invokeable.isInstanceOf(");
                node.getOp1().gen(this);
                this.pw.print(", ");
                this.pw.printQuoted(targetType.asObject().getComponentType());
                this.pw.print(", ");
                this.pw.printQuoted(targetType.getSignature());
            } else {
                this.pw.print("( (Object) (");
                node.getOp1().gen(this);
                this.pw.print(") instanceof ");
                this.pw.printJavaType(targetType.primitiveEquivalent(false));
            }
        }
        this.pw.print(" )");
    }

    @Override
    public void generate(In node) {
        if (node.isRange()) {
            Range range = (Range)node.getOp2();
            this.pw.printFunctionCall("CILUtils.between", node.getOp1(), range.getOp1(), range.getOp2(), this);
        } else if (node.getOp2().getKind() == 5) {
            this.pw.print("(");
            this.pw.printFunctionCall("Str.indexOf", node.getOp2(), node.getOp1(), this);
            this.pw.print(" != -1)");
        } else {
            this.pw.printFunctionCall("ArrayUtils.contains", node.getOp2(), node.getOp1(), this);
        }
    }

    @Override
    public void generate(ArrayReference node) {
        Node array = node.getOp1();
        Node index = node.getOp2();
        TypeDescription arrayType = array.getTypeDescription();
        TypeDescription elementType = arrayType.getElementType();
        elementType = elementType.primitiveEquivalent(false);
        if (node.isAutoInit()) {
            this.pw.print("(");
            if (array.isExternal()) {
                String etype = TDKit.getElementType((String)array.getJavaType());
                this.pw.print(Conversion.cast(elementType, etype));
            } else {
                this.pw.printJavaCast(elementType);
            }
            this.pw.print(" ArrayUtils.reference(");
            node.getObject().gen(this);
            this.pw.print(", ");
            this.pw.printQuoted(JavaClass.getFieldNameFromSignature(node.getMember()));
            this.pw.print(", ");
            index.gen(this);
            this.pw.print("))");
            return;
        }
        TypeDescription itd = index.getTypeDescription();
        int kind = arrayType.getKind();
        if (arrayType.getKind() == 15) {
            array.gen(this);
            if (index.getKind() == 2) {
                this.pw.print(".getElementAt(");
            } else {
                this.pw.print(".getElement(");
            }
            index.gen(this);
            this.pw.print(")");
        } else if (!arrayType.isPrimitive() || kind == 13) {
            this.pw.print("( ");
            this.pw.printJavaCast(elementType);
            if (node.isLeftValue()) {
                this.pw.print("ArrayUtils.reference(");
                array.gen(this);
                this.pw.print(", ");
                node.getElementType().gen(this);
                this.pw.print(", ");
            } else {
                array.gen(this);
                this.pw.print(".get(");
                if (itd.equals(TypeFactory.getPrimitiveInt(32)) || itd.isEnum() && itd.isPrimitive()) {
                    this.pw.print("(int)");
                }
            }
            index.gen(this);
            this.pw.print(") )");
        } else {
            array.gen(this);
            this.pw.print("[");
            if (itd.equals(TypeFactory.getPrimitiveInt(32)) || itd.isEnum()) {
                this.pw.print("(int)");
            }
            index.gen(this);
            this.pw.print("]");
        }
    }

    @Override
    public void generate(CodeKit.BitSetReference node) {
        this.pw.print(node.getFieldName());
    }

    @Override
    public void generate(BitwiseNot node) {
        this.pw.print("( ~ ");
        node.getFirst().gen(this);
        this.pw.print(" )");
    }

    @Override
    public void generate(BitwiseOp node) {
        this.pw.print("( ");
        node.getOp1().gen(this);
        this.pw.print(' ' + node.getOperatorName() + ' ');
        node.getOp2().gen(this);
        this.pw.print(" )");
    }

    @Override
    public void generate(CodeKit.ClearBitSet node) {
        this.pw.print("this." + node.getFieldName() + " = 0");
    }

    @Override
    public void generate(Exit node) {
        Node label;
        Node pred = node.getFirst();
        if (pred != null) {
            this.pw.print("if (");
            pred.gen(this);
            this.pw.println(")");
            this.pw.indent();
        }
        if ((label = node.getLabel()) == null && !node.isInLoop()) {
            this.pw.print("return");
        } else {
            this.pw.print("break");
            if (label != null) {
                this.pw.print(" ");
                this.pw.printLabelName(label.getText());
            }
        }
        if (pred != null) {
            this.pw.dedent();
        }
    }

    @Override
    public void generate(ExprIf node) {
        this.pw.print("( ");
        node.getPredicate().gen(this);
        this.pw.print(" ? ");
        node.getTrueExpr().gen(this);
        this.pw.print(" : ");
        node.getFalseExpr().gen(this);
        this.pw.print(" )");
    }

    @Override
    public void generate(For node) {
        Node range = node.getArray();
        TypeDescription rangeType = range.getTypeDescription();
        this.pw.println();
        this.pw.printLabel(node.getName());
        Node fromRange = node.getFromRange();
        Symbol id = node.getIdentifier();
        if (fromRange != null || rangeType.getKind() == 12) {
            String length = id.getName() + "$length" + node.getUniqueNumber();
            this.pw.print("for (");
            if (rangeType.isNativeEnum()) {
                this.pw.printJavaType(rangeType);
            } else if (rangeType.isEnum()) {
                this.pw.print("long");
            } else {
                this.pw.print("int");
            }
            this.pw.print(' ' + id.getSignature() + " = ");
            if (fromRange != null) {
                fromRange.gen(this);
                Node toRange = node.getToRange();
                if (toRange instanceof Const) {
                    length = toRange.getText();
                } else {
                    this.pw.print(", " + length + " = ");
                    toRange.gen(this);
                }
                this.pw.println("; ");
            } else {
                range.setMustClone(false);
                this.pw.print("0, " + length + " = ");
                this.pw.printFunctionCall("ArrayUtils.length", range, this);
                this.pw.println("; ");
            }
            this.pw.indent();
            this.pw.print(id.getSignature());
            if (fromRange == null) {
                this.pw.print(" < " + length);
            } else if (rangeType.isNativeEnum()) {
                this.pw.print(".compareTo(" + length + ") <= 0");
            } else {
                this.pw.print(" <= " + length);
            }
            this.pw.println(";");
            if (rangeType.isNativeEnum()) {
                this.pw.print(id.getSignature() + " = (");
                this.pw.printJavaType(rangeType);
                this.pw.print(") CILUtils.increment(" + id.getSignature() + ", 1)");
            } else {
                this.pw.print("++" + id.getSignature());
            }
            if (this.testMode) {
                this.pw.print(',');
                this.pw.printJavaType(DebugValue.class);
                this.pw.print(".debug(");
                this.pw.print(id.getSignature());
                this.pw.print(",");
                this.pw.print(node.getLine());
                this.pw.print(",");
                this.pw.printQuoted(id.getName());
                this.pw.print(")");
            }
            this.pw.println(')');
            this.pw.dedent();
            this.pw.printBlock(node.getBody(), this);
        } else {
            Node array = node.getArray();
            TypeDescription arrayType = array.getTypeDescription();
            TypeDescription indexType = arrayType.getIndexType();
            if (indexType == null) {
                indexType = TypeFactory.getInt();
            }
            String iterator = id.getUniqueName("iterator");
            this.pw.print("for (Iterator " + iterator);
            this.pw.print(" = ");
            this.pw.printFunctionCall("ArrayUtils.indexIterator", array, this);
            this.pw.print("; ");
            this.pw.print(iterator + ".hasNext();)");
            this.pw.println("{");
            this.pw.indent();
            this.pw.printJavaType(indexType);
            this.pw.print(' ' + id.getSignature() + " = ");
            this.pw.printJavaCast(indexType);
            this.pw.println(iterator + ".next();");
            node.getBody().gen(this);
            this.pw.dedent();
            this.pw.println("}");
        }
    }

    @Override
    public void generate(ForEach node) {
        this.pw.printLabel(node.getName());
        Symbol id = node.getIdentifier();
        Select select = node.getSelectStatement();
        if (select == null) {
            boolean mustGenerateWhere;
            String iterVar;
            Node array = node.getArray();
            Node block = node.getBody();
            array.setMustClone(false);
            TypeDescription arrayType = array.getTypeDescription();
            TypeDescription setType = node.getSetType();
            if (arrayType.isPrimitive()) {
                ArrayConst literal;
                if (array.isComplexExpression()) {
                    String arrayVar = id.getUniqueName("array");
                    this.pw.printJavaType(arrayType);
                    this.pw.print(' ' + arrayVar + " = ");
                    array.gen(this);
                    this.pw.println(";");
                    array = new Identifier(arrayVar);
                }
                iterVar = id.getUniqueName("index");
                String length = id.getUniqueName("length");
                this.pw.print("for (int " + iterVar + " = 0");
                ArrayConst arrayConst = literal = array instanceof ArrayConst ? (ArrayConst)array : null;
                if (literal != null) {
                    this.pw.print("; ");
                    length = String.valueOf(literal.length());
                } else {
                    this.pw.print(", " + length + " = ");
                    this.pw.printFunctionCall("ArrayUtils.length", array, this);
                    this.pw.print("; ");
                }
                this.pw.print(iterVar + " < " + length + "; ");
                this.pw.println("++" + iterVar + ')');
            } else {
                Symbol it = id.getTarget();
                iterVar = it.getSignature();
                this.pw.print("for (Iterator " + iterVar + " = (Iterator)");
                if (!IterablesByFilterRegistry.contains(setType)) {
                    this.pw.printFunctionCall("ArrayUtils.elementIterator", array, this);
                    this.pw.print("; ");
                } else {
                    array.gen(this);
                    this.pw.print(".invoke(");
                    this.pw.printQuoted("Miterator(Ljava.lang.String;[Ljava.lang.Object;)Ljava.util.Iterator;");
                    this.pw.print(", new Object[] {");
                    this.pw.printQuoted(node.getFilter());
                    this.pw.print(", ");
                    List parameters = node.getParameters();
                    if (parameters != null && !parameters.isEmpty()) {
                        this.pw.print("new Object[] {");
                        int length = parameters.size();
                        for (int i = 0; i < length; ++i) {
                            Node current = (Node)parameters.get(i);
                            current.gen(this);
                            if (i + 1 >= length) continue;
                            this.pw.print(", ");
                        }
                        this.pw.print("}");
                    } else {
                        this.pw.print("null");
                    }
                    this.pw.print("}); ");
                }
                this.pw.println(iterVar + ".hasNext();)");
            }
            this.pw.println("{");
            this.pw.indent();
            TypeDescription elementType = node.getElementType();
            this.pw.printJavaType(elementType);
            this.pw.print(' ' + id.getSignature() + " = ");
            if (arrayType.isPrimitive()) {
                array.gen(this);
                this.pw.println('[' + iterVar + "];");
            } else {
                this.pw.printJavaCast(elementType);
                this.pw.println(iterVar + ".next();");
            }
            Node where = node.getWhere();
            boolean bl = mustGenerateWhere = where != null && !IterablesByFilterRegistry.contains(setType);
            if (mustGenerateWhere) {
                this.pw.print("if (");
                where.gen(this);
                this.pw.println(") {");
                this.pw.indent();
            }
            block.gen(this);
            if (mustGenerateWhere) {
                this.pw.dedent();
                this.pw.println("}");
            }
            this.pw.dedent();
            this.pw.println("}");
        } else {
            Node block = node.getBody();
            if (node.getName().isEmpty()) {
                this.pw.print("sqlquery" + node.getUniqueNumber() + ": ");
            }
            this.pw.println("{");
            this.pw.indent();
            this.pw.print("oracle.bpm.sql.QueryObject " + id.getSignature() + " = ");
            select.gen(this);
            this.pw.println(";");
            this.pw.println("try {");
            this.pw.indent();
            this.pw.println("while (" + id.getSignature() + ".hasNext())");
            this.pw.println("{");
            this.pw.indent();
            block.gen(this);
            this.pw.dedent();
            this.pw.println("}");
            this.pw.dedent();
            this.pw.println("} ");
            this.pw.println("finally { if (" + id.getSignature() + " != null) { " + id.getSignature() + ".close(); } }");
            this.pw.dedent();
            this.pw.println("}");
        }
    }

    @Override
    public void generate(Function node) {
        Node arg = node.getFirst();
        if (node.isExpression()) {
            this.pw.printJavaCast(arg.getTypeDescription());
        }
        arg.setMustClone(false);
        this.pw.printFunctionCall("Any.clone", arg, this);
    }

    @Override
    public void generate(JavaFor node) {
        Node init = node.getFirst();
        Node cond = init.getNext();
        Node reinit = cond.getNext();
        Node body = reinit.getNext();
        this.pw.println("{");
        this.pw.indent();
        this.generate(init, ";\n");
        this.pw.println(";\n");
        this.pw.print("for (;");
        cond.gen(this);
        this.pw.print(";");
        this.generate(reinit, ", ");
        this.pw.println(") {");
        this.pw.indent();
        body.gen(this);
        this.pw.dedent();
        this.pw.println("}");
        this.pw.dedent();
        this.pw.println("}");
    }

    @Override
    public void generate(LabeledStatement node) {
        Node statement = node.getStatement();
        this.pw.printLabel(node.getText());
        this.pw.println(" {");
        this.pw.indent();
        statement.gen(this);
        this.pw.dedent();
        this.pw.println("}");
    }

    @Override
    public void generate(MappedArrayReference node) {
        this.pw.print("MemberArray.create(");
        node.getOp1().gen(this);
        this.pw.print(", ");
        this.pw.printQuoted(node.getGetter());
        this.pw.print(", ");
        this.pw.printQuoted(node.getSetter());
        this.pw.print(", ");
        node.getElementClass().gen(this);
        this.pw.print(")");
    }

    @Override
    public void generate(SQLStatement node) {
        if (node.isUpdate()) {
            this.pw.print("oracle.bpm.sql.SQLObject.executeUpdate(");
        } else {
            this.pw.print("oracle.bpm.sql.SQLObject.executeQuery(");
        }
        this.pw.printQuoted(node.getRealConfigName());
        this.pw.print(", ");
        String schema = node.getSchema();
        if (schema != null) {
            this.pw.printQuoted(schema);
        } else {
            this.pw.print("null");
        }
        this.pw.print(", ");
        this.pw.printQuoted(node.getCode());
        this.pw.print(", ");
        ArrayList<Node> parameters = node.getParameters();
        if (!parameters.isEmpty()) {
            this.pw.print("new Object[] {");
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                Node param = (Node)it.next();
                param.gen(this);
                if (!it.hasNext()) continue;
                this.pw.print(", ");
            }
            this.pw.print("}");
        } else {
            this.pw.print("null");
        }
        this.pw.print(", ");
        ArrayConst types = node.getTypes();
        if (types != null) {
            types.gen(this);
        } else {
            this.pw.print("null");
        }
        this.pw.println(");");
    }

    @Override
    public void generate(CodeKit.SetBitSet node) {
        this.pw.print("this." + node.getFieldName());
        this.pw.print(" |= " + node.getBitIndex());
    }

    @Override
    public void generate(SetElement node) {
        Node array = node.getOp1();
        Node index = node.getOp2();
        Node value = node.getOp3();
        if (value == null) {
            value = index;
            index = null;
        }
        assert (array != null) : "Array shouldn't be null";
        assert (value != null) : "Value shouldn't be null";
        if (array.getTypeDescription().isMap()) {
            assert (index != null) : "Index must not be null in a Map";
            array.gen(this);
            this.pw.print(".put(");
            index.gen(this);
            this.pw.print(", ");
            value.gen(this);
            this.pw.print(")");
        } else {
            boolean extendArray = node.isExtendArray();
            if (!array.getTypeDescription().isPrimitive()) {
                if (extendArray) {
                    array.gen(this);
                    this.pw.print(".add(");
                    value.gen(this);
                    this.pw.print(")");
                } else {
                    this.pw.printFunctionCall("ArrayUtils.setElement", array, index, value, this);
                }
            } else {
                if (node.isExpression()) {
                    this.pw.printJavaCast(node.getArrayClass().getTypeToCast());
                }
                if (extendArray) {
                    this.pw.print("ArrayUtils.addElement(");
                } else {
                    this.pw.print("ArrayUtils.setElement(");
                }
                node.getElementClass().gen(this);
                this.pw.print(", ");
                array.gen(this);
                if (!extendArray) {
                    assert (index != null) : "Index must not be null when not extending an array";
                    this.pw.print(", (int)");
                    index.gen(this);
                }
                this.pw.print(", ");
                value.gen(this);
                if (!node.isExpression()) {
                    this.pw.print(", false");
                }
                this.pw.print(")");
            }
        }
    }

    @Override
    public void generate(Term node) {
        Node op1 = node.getOp1();
        Node op2 = node.getOp2();
        switch (op1.getKind()) {
            case 6: 
            case 7: {
                String function = node.getMethodName();
                this.pw.printFunctionCall(function, op1, op2, this);
                break;
            }
            default: {
                assert (false) : "invalid type : " + op1.getTypeDescription().getText();
                break;
            }
        }
    }

    @Override
    public void generate(TypeSpec node) {
        this.pw.printJavaType(node.getTypeDescription());
    }

    @Override
    public void generate(UnaryArithmetic node) {
        Node op = node.getFirst();
        if (!node.isMinus()) {
            op.gen(this);
        } else {
            if (op.getTypeDescription().isPrimitive()) {
                this.pw.print("( - ");
            } else {
                switch (op.getKind()) {
                    case 2: {
                        this.pw.print("Int");
                        break;
                    }
                    case 3: {
                        this.pw.print("Decimal");
                        break;
                    }
                    case 4: {
                        this.pw.print("Real");
                        break;
                    }
                    case 7: {
                        this.pw.print("Interval");
                        break;
                    }
                    default: {
                        assert (false) : "Invalid type " + op.getTypeDescription();
                        break;
                    }
                }
                this.pw.print(".negate(");
            }
            op.gen(this);
            this.pw.print(" )");
        }
    }

    @Override
    public void generate(CodeKit.ValueOfCall node) {
        TypeDescription resultType = node.getResultType();
        this.pw.printJavaCast(resultType);
        this.pw.printJavaType("oracle.bpm.xobject.runtime.components.FODelegate");
        this.pw.print(".valueOf(");
        node.getOp1().gen(this);
        this.pw.print(", ");
        this.pw.printJavaType(resultType);
        this.pw.print(".class)");
    }

    @Override
    public void generate(While node) {
        this.pw.printLabel(node.getName());
        this.pw.print("while (");
        node.getOp1().gen(this);
        this.pw.print(") ");
        this.pw.printBlock(node.getOp2(), this);
    }

    @Override
    public void generate(MemberReference node) {
        assert (node.getKind() != -1) : "This node was not compiled: " + node;
        MethodTypeDescription member = node.getMemberType();
        String getter = MemberAccess.getSignature(node.objType, member);
        assert (getter != null) : "Missing signature for member '" + member.getText() + "' from type '" + member.getParent() + '\'';
        TypeDescription objType = node.getObjType();
        if (node.isLeftValue() && member.isAttribute() && !objType.isInvokeable() && !member.isSynthesized()) {
            this.pw.print("(");
            this.pw.printJavaType(Conversion.cast(node.getTypeDescription(), member.getResultArgument().getJavaType()));
            this.pw.print("MemberUtils.getAttribute(");
            if (member.isStatic()) {
                this.pw.printJavaType(objType);
                this.pw.print(".class");
            } else {
                this.generateObjectReference(node);
            }
            this.pw.print(", ");
            this.pw.printQuoted(Str.escape(getter));
            String setter = MemberAccess.getWriteSignature(objType, member);
            if (setter != null) {
                this.pw.print(", ");
                this.pw.printQuoted(Str.escape(setter));
            }
            this.pw.print("))");
            return;
        }
        getter = MemberAccess.getSignature(objType, member);
        boolean closeParenthesis = false;
        if (objType.getKind() == 15) {
            this.generateObjectReference(node);
            this.pw.print(".");
            this.pw.print("getField(");
            this.pw.printQuoted(node.getOp2().getText());
            this.pw.print(")");
        } else if (objType.isInvokeable()) {
            if (!node.isSqlComponent()) {
                closeParenthesis = true;
                this.pw.print("(");
                Argument resultArgument = member.getResultArgument();
                this.pw.print(Conversion.cast(node.getTypeDescription(), resultArgument.isExternal() ? resultArgument.getJavaType() : null));
            }
            this.generateObjectReference(node);
            this.pw.print(".");
            if (member.isAttribute()) {
                this.pw.print("getAttributeValue(");
            } else {
                this.pw.print("invoke(");
            }
            this.pw.printQuoted(Str.escape(getter));
            String setter = MemberAccess.getWriteSignature(objType, member);
            if (node.isLeftValue() && setter != null) {
                this.pw.print(", ");
                this.pw.printQuoted(Str.escape(setter));
            }
            if (!member.isAttribute()) {
                this.pw.print(", true, null, null");
            }
            this.pw.print(")");
        } else if (getter.charAt(0) == 'A') {
            this.generateObjectReference(node);
            this.pw.print(".");
            this.pw.print(JavaClass.getFieldNameFromSignature(getter));
        } else if (getter.charAt(0) == 'M') {
            this.generateObjectReference(node);
            this.pw.print(".");
            if (node.isPrimitiveAccess()) {
                this.pw.print(FieldDeclaration.name(node.getMemberName()));
            } else {
                this.pw.print(JavaClass.getMethodNameFromSignature(getter) + "()");
            }
        } else if (MemberAccess.isDelegatedBySignature(getter, objType)) {
            getter = MemberAccess.getDelegatedMember(getter);
            Class<?> ret = PrimitiveTypeUtils.classFromSignature(JavaClass.getResultTypeFromSignature(getter));
            TypeDescription resultType = node.getTypeDescription();
            if (!ret.getName().equals(resultType.getJavaType())) {
                closeParenthesis = true;
                this.pw.print("((");
                this.pw.printJavaType(resultType);
                this.pw.print(')');
            }
            this.generateObjectReference(node);
            this.pw.print(".");
            String method = JavaClass.getMethodNameFromSignature(getter);
            this.pw.print(method);
            this.pw.print('(');
            if (node.delegationInClient && !node.memberType.isStatic()) {
                node.getOp1().gen(this);
            }
            this.pw.print(')');
        } else assert (false) : '[' + getter + "], Type: " + objType.getText() + ", Member: " + node.getMemberName();
        if (closeParenthesis) {
            this.pw.print(')');
        }
    }

    @Override
    public void generate(Switch node) {
        Node assign = node.getOp1();
        assign.gen(this);
        this.generateStatementSeparator(assign);
        for (Node current = node.getOp2(); current != null; current = current.getNext()) {
            this.generateCase(current);
            if (current.getNext() == null) continue;
            this.pw.print("else ");
        }
    }

    @Override
    public void generate(Dup node) {
        TypeDescription td = node.getTypeDescription();
        if (!td.isPrimitive()) {
            this.pw.printJavaCast(td);
        }
        this.pw.printJavaType(LocalStack.class);
        this.pw.print(".push(");
        node.getFirst().gen(this);
        this.pw.print(")");
    }

    @Override
    public void generate(Pop node) {
        TypeDescription td = node.getTypeDescription();
        if (!td.isPrimitive()) {
            this.pw.printJavaCast(td);
        }
        this.pw.printJavaType(LocalStack.class);
        this.pw.print(".pop(");
        node.getFirst().gen(this);
        this.pw.print(")");
    }

    public void generateInputArgsCode(Invoke invoke) {
        Args args = invoke.getInputArgs();
        if (args != null) {
            for (Node n = args.getFirst(); n != null; n = n.getNext()) {
                Arg arg = (Arg)n;
                if (invoke.isDynamic()) {
                    this.pw.printQuoted(arg.getWriteSignature(invoke.getObjType()));
                    this.pw.print(", ");
                    arg.gen(this);
                    if (arg.hasNext()) {
                        this.pw.print(",");
                    }
                    this.pw.println();
                    continue;
                }
                if (!arg.isArgument()) continue;
                arg.gen(this);
                if (!arg.hasNext()) continue;
                this.pw.print(", ");
            }
        }
    }

    public void generateObjectReference(MemberAccess memberAccess) {
        Node object = memberAccess.getObject();
        TypeDescription objType = memberAccess.getObjType();
        MethodTypeDescription member = memberAccess.getMemberType();
        boolean delegationInClient = memberAccess.isDelegationInClient();
        this.generateObjectReference(object, objType, member, delegationInClient);
    }

    @Override
    public void generateStatementSeparator(Node node) {
        this.generateStatementSeparator(node, false);
    }

    @Override
    public void generateStatementSeparator(Node node, boolean force) {
        String separator;
        String string = separator = force ? ";" : node.getStatementSeparator();
        if (separator != null) {
            if (separator.endsWith("\n")) {
                this.pw.println(separator.substring(0, separator.length() - 1));
            } else {
                this.pw.print(separator);
            }
        }
    }

    @Override
    public void generate(Assignment assignment) {
        LocalVar lv = assignment.getLocalVar();
        Node value = assignment.getOp2();
        Symbol symbol = lv.getSymbol();
        if (symbol == null) {
            throw new NullPointerException("Symbol null in node(" + lv.getClassName() + ')');
        }
        if (assignment.isExpression()) {
            this.pw.print("(");
        }
        this.pw.print(symbol.getSignature());
        if (symbol.isHolder()) {
            boolean lazyHolder = symbol.isLazyHolder();
            if (lazyHolder) {
                this.pw.print(".set(");
            } else {
                this.pw.print(".value");
                this.pw.print(" = ");
            }
            this.debugAssignment(lv, value);
            if (lazyHolder) {
                this.pw.print(")");
            }
        } else {
            this.pw.print(" = ");
            this.debugAssignment(lv, value);
        }
        if (assignment.isExpression()) {
            this.pw.print(")");
        }
    }

    public void generateCommaDelimitedCode(Node first, JavaPrintWriter pw) {
        while (first != null) {
            first.gen(this);
            Node next = first.getNext();
            if (next != null) {
                pw.print(", ");
            }
            first = next;
        }
    }

    @Override
    protected void generateDynamicReturnArray(LocalVar returnArray, Args outputArgs, Invoke invoke) {
        this.pw.print(returnArray.getSignature());
        this.pw.println(" = new Object[] { ");
        this.pw.indent();
        if (outputArgs != null && invoke.isDynamic()) {
            Arg argNode = (Arg)outputArgs.getFirst();
            while (argNode != null) {
                Arg next = (Arg)argNode.getNext();
                this.generateOutputArgCode(argNode, next == null);
                argNode = next;
            }
        }
        this.pw.dedent();
        this.pw.println("};");
    }

    @Override
    protected void generateSetter(Node object, TypeDescription type, MethodTypeDescription member, Node value, String field, boolean isPrimitiveAccess, boolean expression) {
        if (expression) {
            this.pw.openParen();
        }
        if (type.getKind() == 15) {
            this.generateObjectReference(object, type, member, false);
            this.pw.print(".");
            this.pw.print("setField");
            this.pw.openParen();
            this.pw.printQuoted(field);
            this.pw.print(", ");
        } else if (type.isInvokeable()) {
            this.generateObjectReference(object, type, member, false);
            this.pw.print(".");
            this.pw.print("setAttributeValue");
            this.pw.openParen();
            this.pw.printQuoted(Str.escape(MemberAccess.getWriteSignature(type, member)));
            this.pw.print(", ");
        } else if (isPrimitiveAccess) {
            this.generateObjectReference(object, type, member, false);
            this.pw.print(".");
            this.pw.print(FieldDeclaration.name(member.getName()));
            this.pw.print(" = ");
        } else {
            String memberSignature = MemberAccess.getWriteSignature(type, member);
            int mType = memberSignature != null ? (int)memberSignature.charAt(0) : -1;
            switch (mType) {
                case 65: {
                    this.generateObjectReference(object, type, member, false);
                    this.pw.print(".");
                    this.pw.print(JavaClass.getFieldNameFromSignature(memberSignature) + " = ");
                    break;
                }
                case 77: {
                    if (expression) {
                        TypeDescription td = value.getTypeDescription();
                        if (!td.isPrimitive()) {
                            this.pw.printJavaCast(td);
                        }
                        this.pw.printJavaType(JavaObject.class);
                        this.pw.print(".createJavaObject(");
                        this.generateObjectReference(object, type, member, false);
                        this.pw.print(").setAttributeValue");
                        this.pw.openParen();
                        this.pw.printQuoted(Str.escape(memberSignature));
                        this.pw.print(", ");
                        break;
                    }
                    this.generateObjectReference(object, type, member, false);
                    this.pw.print(".");
                    this.pw.print(JavaClass.getMethodNameFromSignature(memberSignature));
                    this.pw.openParen();
                    break;
                }
                default: {
                    assert (false) : '[' + memberSignature + "], Type: " + type.getText() + ", Member: " + member.getName();
                    break;
                }
            }
        }
        value.gen(this);
        this.pw.closeParen();
    }

    protected void generateStatements(Block statements) {
        this.pw.println("{");
        if (statements.hasChildren()) {
            this.pw.indent();
            this.pw.println("// statements");
            statements.gen(this);
            this.pw.dedent();
        }
        this.pw.println("}");
    }

    void generate(Node node, String delimiter) {
        String prev = this.currentDelimiter;
        this.currentDelimiter = delimiter;
        for (Node current = node.getFirst(); current != null; current = current.getNext()) {
            try {
                current.gen(this);
                if (delimiter == null || current.getNext() == null) continue;
                this.pw.print(this.currentDelimiter);
                continue;
            }
            catch (Exception unexpected) {
                node.reportError(new InternalException(current, (Throwable)unexpected));
            }
        }
        this.currentDelimiter = prev;
    }

    private static void generateAccessModifiers(Method method, JavaPrintWriter pw) {
        pw.print(method.getAccessModifiers().toString().toLowerCase());
        pw.print(" ");
        if (!method.isConstructor()) {
            TypeDescription type = method.getMethodType().getResultType();
            pw.printJavaType(type.isInvokeable() ? Invokeable.class.getName() : method.getMethodType().getResultArgument().getJavaType());
            pw.print(' ');
        }
    }

    private static void generateArgumentExtraction(TypeDescription argType, JavaPrintWriter pw, String arrayName, int argn) {
        JavaConversionGenerator.generateCast(arrayName + '[' + argn + ']', TypeFactory.getAny(), argType, pw);
        pw.println(";");
    }

    private static void generateArgumentReference(Argument arg, JavaPrintWriter pw) {
        TypeDescription argType = arg.getType();
        boolean isPrimitive = argType.isPrimitive();
        if (isPrimitive) {
            argType = argType.primitiveEquivalent(false);
            pw.print("Conversion." + MDKit.conversionMethod((TypeDescription)argType) + "(");
        }
        pw.print("arg$" + arg.getName());
        if (arg.isOut()) {
            pw.print(".value");
        }
        if (isPrimitive) {
            pw.print(")");
        }
    }

    private static void generateClientStub(Method method, JavaPrintWriter pw) {
        int argc = method.getMethodType().getArgumentCount();
        pw.print("if (oracle.bpm.component.Component.isNotRunningOnServer()) {");
        pw.indent();
        pw.print("Object[] result = xoInvoke(");
        pw.printQuoted(method.getJavaSignature());
        pw.print(", " + method.isStatic() + ", ");
        if (argc == 0) {
            pw.print("null");
        } else {
            JavaGenerator.generateInputArgsAsArray(method, pw, true);
        }
        String[] outputArguments = method.outputArgumentsRequest();
        if (outputArguments != null) {
            pw.println(", ");
            pw.println("new Object[] {");
            for (int i = 0; i < outputArguments.length; ++i) {
                String outputArgument = outputArguments[i];
                if (i > 0) {
                    pw.println(", ");
                }
                pw.printQuoted(outputArgument);
                pw.println();
            }
            pw.print("}");
        }
        pw.println(");");
        JavaGenerator.generateOutArgsExtractionFromArray(method, pw, "result");
        pw.dedent();
        pw.println("}");
    }

    private static void generateInputArgsAsArray(Method method, JavaPrintWriter pw, boolean addSignatures) {
        int argc = method.getMethodType().getArgumentCount();
        pw.println("new Object[] {");
        pw.indent();
        for (int i = 0; i < argc; ++i) {
            Argument arg = method.getMethodType().getArgument(i);
            if (addSignatures) {
                pw.printQuoted("#" + i);
                pw.print(", ");
            }
            JavaGenerator.generateArgumentReference(arg, pw);
            if (i + 1 < argc) {
                pw.print(",");
            }
            pw.println();
        }
        pw.dedent();
        pw.print("}");
    }

    private static void generateMethodSignature(Method method, JavaPrintWriter pw) {
        JavaGenerator.generateMethodSignature(method, pw, "");
    }

    private static void generateMethodSignature(Method method, JavaPrintWriter pw, String suffix) {
        MethodTypeDescription m = method.getMethodType();
        pw.print(method.getFullName() + suffix);
        pw.print('(');
        int argc = m.getArgumentCount();
        if (method.isConstructor()) {
            TypeDescription type = m.getParent();
            if (method.isConstructor() && type.isInnerType()) {
                pw.printJavaType(type.getParent());
                pw.print(" parent");
                if (argc > 0) {
                    pw.print(", ");
                }
            }
        }
        for (int i = 0; i < argc; ++i) {
            Argument arg = m.getArgument(i);
            pw.printJavaType(Method.argumentType(arg));
            pw.print(" ");
            pw.print("arg$" + arg.getName());
            if (i + 1 >= argc) continue;
            pw.print(", ");
        }
        pw.println(")");
        pw.indent();
        if (!method.isOverride() || m.getParent().isInvokeable()) {
            pw.print("throws ");
            pw.printJavaType("java.lang.Throwable");
        } else {
            int count = m.getExceptionCount();
            if (count > 0) {
                pw.print("throws ");
                for (int i = 0; i < count; ++i) {
                    pw.printJavaType(m.getException(i));
                    if (i + 1 >= count) continue;
                    pw.print(", ");
                }
            } else if (method.isOverride() && method.overridedMember != null && method.overridedMember.belongsToFuegoObject()) {
                pw.print("throws ");
                pw.printJavaType("java.lang.Throwable");
            }
        }
        pw.println();
        pw.dedent();
    }

    private static void generateOutArgsExtractionFromArray(Method method, JavaPrintWriter pw, String arrayName) {
        MethodTypeDescription member = method.getMethodType();
        int argc = member.getArgumentCount();
        int argn = 0;
        for (int i = 0; i < argc; ++i) {
            Argument arg = member.getArgument(i);
            if (!arg.isOut()) continue;
            pw.print("arg$" + arg.getName() + ".value");
            pw.print(" = ");
            JavaGenerator.generateArgumentExtraction(arg.getType(), pw, arrayName, ++argn);
        }
        TypeDescription resultType = method.getResultType();
        if (!resultType.isVoid()) {
            pw.print("return ");
            JavaGenerator.generateArgumentExtraction(resultType, pw, arrayName, 0);
        }
    }

    private void debugAssignment(LocalVar var, Node value) {
        if (this.testMode) {
            if (!value.getTypeDescription().isPrimitive()) {
                this.pw.printJavaCast(value.getTypeDescription());
            }
            this.pw.printJavaType(DebugValue.class);
            this.pw.print(".debug(");
            value.gen(this);
            this.pw.print(",");
            this.pw.print(var.getLine());
            this.pw.print(",");
            this.pw.printQuoted(var.toString());
            this.pw.print(")");
        } else {
            value.gen(this);
        }
    }

    private void generateBlockFooter(Method node) {
        long modifiers = node.getModifiers();
        if (Modifier.isClientAvailable(modifiers) || Modifier.isDisableClient(modifiers)) {
            this.pw.println("}");
            this.pw.println("finally {");
            this.pw.indent();
            this.pw.printJavaType("oracle.bpm.component.Component");
            this.pw.println(".enableClient($_clientAvailable);");
            this.pw.dedent();
            this.pw.println("}");
            this.pw.dedent();
        }
    }

    private void generateBlockHeader(Method method) {
        long modifiers;
        if (method instanceof ObjectConstructor && method.getMethodType().getParent().isInnerType()) {
            this.pw.println("this_0 = parent;");
        }
        if (Modifier.isClientAvailable(modifiers = method.getModifiers()) || Modifier.isDisableClient(modifiers)) {
            JavaPrintWriter pw1 = this.pw;
            assert (!Modifier.isClientAvailable(modifiers) || !Modifier.isDisableClient(modifiers)) : "Inconsistent modifiers for client availability";
            if (Modifier.isClientAvailable(modifiers)) {
                pw1.print("boolean $_clientAvailable = ");
                pw1.printJavaType("oracle.bpm.component.Component");
                pw1.println(".enableClient(true);");
                pw1.println("try {");
                pw1.indent();
            } else {
                pw1.print("boolean $_clientAvailable = ");
                pw1.printJavaType("oracle.bpm.component.Component");
                pw1.println(".enableClient(false);");
                pw1.println("try {");
                pw1.indent();
            }
        }
    }

    private void generateCase(Node node) {
        Node block;
        if (node instanceof Switch.Default) {
            block = node.getOp1();
        } else {
            this.pw.print("if (");
            for (Node current = node.getOp1().getFirst(); current != null; current = current.getNext()) {
                current.gen(this);
                if (current.getNext() == null) continue;
                this.pw.print(" || ");
            }
            this.pw.print(") ");
            block = node.getOp2();
        }
        this.pw.printBlock(block, this);
    }

    private void generateDynamicAdaptor(Method method) {
        Argument arg;
        int i;
        int argc = method.getMethodType().getArgumentCount();
        this.pw.println();
        if (method.isStatic()) {
            this.pw.print("static ");
        }
        this.pw.print("public ");
        this.pw.printJavaType(method.getResultType());
        this.pw.println(' ' + method.getFullName() + "(ArgumentMap arg)");
        this.pw.indent();
        this.pw.print("throws ");
        this.pw.printJavaType("java.lang.Throwable");
        this.pw.println();
        this.pw.dedent();
        this.pw.println("{");
        this.pw.indent();
        this.pw.println();
        this.pw.println("// create holders");
        for (i = 0; i < argc; ++i) {
            boolean needsConversion;
            arg = method.getMethodType().getArgument(i);
            if (!arg.isOut()) continue;
            String javaType = arg.getHolderJavaType();
            this.pw.printJavaType(javaType);
            this.pw.print(' ' + arg.getName() + "$holder = ");
            this.pw.print("new ");
            this.pw.printJavaType(javaType);
            this.pw.println("();");
            TypeDescription type = arg.getType();
            boolean bl = needsConversion = !type.isPrimitive() && (type.isInt() || type.isReal());
            if (Any.isLazyHolder(javaType)) {
                this.pw.print(arg.getName() + "$holder.put(");
                if (needsConversion) {
                    JavaConversionGenerator.printConversionCall(type.getHolderType(), this.pw);
                    this.pw.print("(");
                }
                this.generateDynamicArgReference(method, arg, i);
                if (needsConversion) {
                    this.pw.print(")");
                }
                this.pw.print(")");
            } else {
                this.pw.print(arg.getName() + "$holder.value = ");
                if (needsConversion) {
                    JavaConversionGenerator.printConversionCall(type.getHolderType(), this.pw);
                    this.pw.print("(");
                }
                this.generateDynamicArgReference(method, arg, i);
                if (needsConversion) {
                    this.pw.print(")");
                }
            }
            this.pw.println(";");
            this.pw.println();
        }
        this.pw.println();
        this.pw.println("// method call");
        if (!method.getResultType().equals(TypeFactory.getVoid())) {
            this.pw.printJavaType(method.getResultType());
            this.pw.print(" result = ");
        }
        this.pw.print(method.getFullName() + '(');
        if (argc > 0) {
            this.pw.println();
            this.pw.indent();
            for (i = 0; i < argc; ++i) {
                arg = method.getMethodType().getArgument(i);
                if (arg.isOut()) {
                    this.pw.print(arg.getName() + "$holder");
                } else {
                    this.generateDynamicArgReference(method, arg, i);
                }
                if (i + 1 < argc) {
                    this.pw.print(",");
                }
                this.pw.println();
            }
            this.pw.dedent();
        }
        this.pw.println(");");
        this.pw.println();
        this.pw.println("// retrieve holder values");
        for (i = 0; i < argc; ++i) {
            arg = method.getMethodType().getArgument(i);
            if (!arg.isOut()) continue;
            this.pw.print("arg.setArgument(");
            this.pw.printQuoted(arg.getName());
            this.pw.print(", ");
            if (Any.isLazyHolder(arg.getHolderJavaType())) {
                this.pw.print(arg.getName() + "$holder.get()");
            } else {
                boolean needsConversion;
                TypeDescription type = arg.getType();
                boolean bl = needsConversion = !type.isPrimitive() && (type.isInt() || type.isReal());
                if (needsConversion) {
                    JavaConversionGenerator.printConversionCall(type, this.pw);
                    this.pw.print("(");
                } else {
                    this.pw.print("(");
                    this.pw.printJavaType(arg.getType());
                    this.pw.print(")");
                }
                this.pw.print(arg.getName() + "$holder.value");
                if (needsConversion) {
                    this.pw.print(")");
                }
            }
            this.pw.println(");");
        }
        if (!method.getResultType().equals(TypeFactory.getVoid())) {
            this.pw.println("return result;");
        }
        this.pw.dedent();
        this.pw.println("}");
    }

    private void generateDynamicArgReference(Method mth, Argument arg, int argPosition) {
        TypeDescription argType = arg.getType();
        String deflt = arg.getDefaultValue();
        if ((argType.isPredefined() || argType.isEnum()) && argType.isPrimitive()) {
            this.pw.printJavaType(ArgumentMapUtil.class);
            this.pw.print(".");
            this.pw.print(argType.getJavaType());
            this.pw.print("Value(arg, ");
            this.pw.printQuoted(arg.getName());
            this.pw.print(", ");
            Const cons = deflt == null ? Const.defaultValue(argType, null) : Const.valueOf(deflt, argType, null);
            cons.gen(this);
            this.pw.print(")");
        } else {
            ClassConst classConst = mth.getArgClasses()[argPosition];
            this.pw.printJavaCast(classConst.getTypeToCast());
            this.pw.printJavaType(ArgumentMapUtil.class);
            this.pw.print(".value(arg, ");
            this.pw.printQuoted(arg.getName());
            this.pw.print(", ");
            classConst.gen(this);
            this.pw.print(", ");
            if (deflt == null) {
                this.pw.print(" null");
            } else {
                Const.valueOf(deflt, argType, null).gen(this);
            }
            this.pw.print(")");
        }
    }

    private void generateCatchClause(On on, String exception, boolean first) {
        if (!first) {
            this.pw.print("else ");
        }
        TypeDescription exceptionType = on.getExceptionType();
        this.pw.print("if (CILUtils.instanceOf(" + exception + ", ");
        this.pw.printQuoted(exceptionType.asObject().getComponentType());
        this.pw.print(", ");
        this.pw.printQuoted(exceptionType.getSignature());
        this.pw.println(")) {");
        this.pw.indent();
        this.pw.printJavaType(exceptionType);
        this.pw.print(' ' + on.getException().getSignature() + " = ");
        this.pw.printJavaCast(on.getExceptionClass().getTypeToCast());
        this.pw.print("CILUtils.exception(" + exception + ", ");
        on.getExceptionClass().gen(this);
        this.pw.println(");");
        on.getOp3().gen(this);
        this.pw.dedent();
        this.pw.println("}");
    }

    private void generateMethodImpl(Method method, boolean server, MethodTypeDescription member) {
        if (!server || !method.getCurrentClass().mustGenerateStubs() || member.isConstructor()) {
            this.generate((DoBlock)method);
        } else {
            this.pw.println("{");
            this.pw.indent();
            JavaGenerator.generateClientStub(method, this.pw);
            this.pw.print("else ");
            this.generate((DoBlock)method);
            this.pw.dedent();
            this.pw.println("}");
        }
    }

    private void generateObjectReference(Node object, TypeDescription objType, MethodTypeDescription member, boolean delegationInClient) {
        if (MemberAccess.isCallToParent(objType, member, object)) {
            this.pw.print("this_0");
        } else if (delegationInClient) {
            String signature = member.getSignature();
            boolean delegateBySignature = MemberAccess.isDelegatedBySignature(signature, objType);
            if (delegateBySignature) {
                this.pw.printJavaType(MemberAccess.getDelegateClass(signature));
            } else if (member.isStatic()) {
                this.pw.printJavaType(member.getParent());
            } else {
                this.pw.print("(new ");
                this.pw.printJavaType(member.getParent());
                this.pw.print("(");
                object.gen(this);
                this.pw.print("))");
            }
        } else if (member.isStatic() && !objType.isInvokeable() && !member.isConstructor()) {
            this.pw.printJavaType(member.getParent());
        } else {
            object.gen(this);
        }
    }

    private void generateOutputArgCode(Arg arg, boolean last) {
        String signature = arg.getSignature();
        if (signature != null) {
            this.pw.printQuoted(signature);
            if (!last) {
                this.pw.print(",");
            }
        }
        this.pw.println();
    }
}

