/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.bcgen.FieldD;
import oracle.bpm.bcgen.JVMCodeBuilder;
import oracle.bpm.bcgen.MDKit;
import oracle.bpm.bcgen.MethodD;
import oracle.bpm.bcgen.TD;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ConversionGenerator;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.Node;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class JVMConversionGenerator
implements ConversionGenerator {
    private JVMByteCodeGenerator cg;

    public JVMConversionGenerator(JVMByteCodeGenerator codeGenerator) {
        this.cg = codeGenerator;
    }

    @Override
    public void generate(Conversion.IntReal node) {
        this.operandGenerate(node);
        this.invoke(MDKit.objectTo((String)node.newType.getJavaType()));
    }

    @Override
    public void generate(Conversion.TimeInterval node) {
        ObjectType newType;
        ObjectType oldType;
        this.operandGenerate(node);
        TypeDescription oldTD = node.oldType;
        if (!oldTD.isPrimitive()) {
            oldType = TD.getObjectType((String)node.getSourceJavaType());
        } else {
            BasicType primitiveType;
            int oldKind = oldTD.getKind();
            if (oldKind == 2) {
                primitiveType = Type.LONG;
            } else if (oldKind == 4) {
                primitiveType = Type.DOUBLE;
            } else {
                throw new IllegalStateException("Invalid TimeInterval conversion type: " + oldTD);
            }
            this.convert((Type)primitiveType);
            oldType = primitiveType;
        }
        TypeDescription newTD = node.newType;
        Object mthd = newTD.isTime() ? MDKit.toTime((String)oldType.toString()) : ((newType = TD.getObjectType((TypeDescription)newTD)).equals((Object)oldType) ? null : MethodD.createStatic((Type)newType, (ObjectType)newType, (String)"valueOf", (Type[])new Type[]{oldType}));
        if (mthd != null) {
            this.invoke((MethodD)mthd);
        }
    }

    @Override
    public void generate(Conversion.Bool node) {
        this.operandGenerate(node);
        this.invoke(MDKit.toBoolean((boolean)node.newType.isPrimitive()));
    }

    @Override
    public void generate(Conversion.Binary node) {
        this.operandGenerate(node);
        this.invoke(MDKit.SERIALIZE);
    }

    @Override
    public void generate(Conversion.Wide node) {
        Node operand = node.getOp1();
        TypeDescription newType = node.getTypeDescription();
        TypeDescription oldType = operand.getTypeDescription();
        if (newType.isPrimitive() && oldType.isPrimitive()) {
            operand.gen(this.cg);
            this.convert(TD.valueOf((TypeDescription)newType));
        } else if (newType.isAny() || !newType.isInt() && !newType.isReal()) {
            operand.gen(this.cg);
        } else {
            throw new IllegalStateException("Wide: " + oldType + " -> " + newType);
        }
    }

    @Override
    public void generate(Conversion.UnBox node) {
        TypeDescription newType = node.getTypeDescription();
        this.operandGenerate(node);
        if (newType.isInt() || newType.isEnum()) {
            this.invoke(MDKit.OBJ_TO_LONG);
            this.convert(TD.valueOf((TypeDescription)newType));
        } else if (newType.isReal()) {
            this.invoke(MDKit.OBJ_TO_DOUBLE);
            this.convert(TD.valueOf((TypeDescription)newType));
        } else if (newType.isBool()) {
            this.invoke(MDKit.OBJ_TO_BOOLEAN);
        } else if (newType.isString() && newType.isPrimitive() && newType.getLength() == 1 && node.getOperandType().isString()) {
            this.loadZero(TD.INT);
            this.invoke(MDKit.CHAR_AT);
        } else {
            throw new IllegalStateException("Invalid type: " + newType);
        }
    }

    @Override
    public void generate(Conversion.ToGMT node) {
        this.operandGenerate(node);
        this.invoke(MDKit.TO_GMT);
    }

    @Override
    public void generate(Conversion.Null node) {
        TypeDescription newType = node.getTypeDescription();
        if (!newType.isPrimitive() || newType.isArray()) {
            this.loadNull();
        } else if (newType.isNumber()) {
            this.loadZero(node.getTD());
        } else if (newType.isBool()) {
            this.loadConstant(false);
        } else if (newType.isString()) {
            this.loadZero(TD.CHAR);
        } else if (newType.isEnum()) {
            if (newType.isNativeEnum()) {
                this.loadNull();
            } else {
                this.loadConstant(node.findInvalidValue((JavaEnumTypeDescription)newType));
            }
        } else assert (false) : "Unexpected Null conversion : " + newType;
    }

    @Override
    public void generate(Conversion.Narrow node) {
        Node operand = node.getOp1();
        TypeDescription newType = node.getTypeDescription();
        TypeDescription oldType = operand.getTypeDescription();
        if (newType.isPrimitive() && oldType.isPrimitive() || (oldType.isAny() || oldType.isObject() || newType.isStrictSubtype(oldType)) && newType.isObject()) {
            operand.gen(this.cg);
            this.convert(TD.valueOf((TypeDescription)newType));
        } else {
            this.generate((Conversion)node);
        }
    }

    @Override
    public void generate(Conversion.Import node) {
        if (node.newType.isTime()) {
            this.operandGenerate(node);
            this.invoke(MDKit.toTime((String)node.getJavaType()));
        } else {
            this.generate((Conversion)node);
        }
    }

    @Override
    public void generate(Conversion.FromGMT node) {
        this.operandGenerate(node);
        this.invoke(MDKit.FROM_GMT);
    }

    @Override
    public void generate(Conversion.Export node) {
        String targetJavaType = node.getTargetJavaType();
        Node operand = node.getFirst();
        operand.gen(this.cg);
        if (node.isArray()) {
            node.getTargetElementClass().gen(this.cg);
            this.invoke(MDKit.ARRAYP_CONVELEMENTS);
            this.convert(TD.valueOf((String)targetJavaType));
        } else if (operand.getTypeDescription().isMap()) {
            MethodD md = MDKit.fromMap((String)targetJavaType);
            if (md == null) {
                throw new IllegalStateException("Illegal Conversion ? Map  to " + targetJavaType);
            }
            this.invoke(md);
        } else if (operand.getTypeDescription().isArray()) {
            MethodD md = MDKit.fromList((String)targetJavaType);
            if (md == null) {
                throw new IllegalStateException("Illegal Conversion ? List  to " + targetJavaType);
            }
            this.invoke(md);
        } else if (operand.getTypeDescription().isTime()) {
            if (!(operand instanceof Conversion.Null)) {
                JVMCodeBuilder builder = this.cg.getCodeBuilder();
                builder.beginIf();
                builder.dup();
                builder.compareNull(true);
                builder.addThen();
                MethodD md = MDKit.fromTime((String)targetJavaType);
                if (md == null) {
                    throw new IllegalStateException("Illegal Conversion ? Time  to " + targetJavaType);
                }
                this.invoke(md);
                builder.addElse();
                builder.pop();
                builder.loadNull();
                builder.endExprIf();
            }
        } else {
            this.convert((Type)TD.getObjectType((String)targetJavaType));
        }
    }

    @Override
    public void generate(Conversion.DynamicView node) {
        this.operandGenerate(node);
        this.invoke(MDKit.MD_GET_CONTENT_TO_SHOW);
    }

    @Override
    public void generate(Conversion.Dynamic node) {
        this.operandGenerate(node);
        if (node.toDynamic()) {
            this.invoke(MDKit.toDynamic((String)node.oldType.getJavaType()));
        } else {
            ClassConst targetClass = node.getTargetClass();
            if (targetClass != null) {
                targetClass.generate(this.cg);
            }
            this.invoke(MDKit.fromDynamic((String)node.getTypeDescription().getJavaType()));
        }
    }

    @Override
    public void generate(Conversion.Box node) {
        Node operand = node.getOp1();
        TypeDescription newType = node.getTypeDescription();
        TypeDescription oldType = operand.getTypeDescription();
        this.operandGenerate(node);
        this.generateBox(oldType, newType);
    }

    @Override
    public void generate(Conversion.Stringify node) {
        int length = node.newType.getLength();
        this.operandGenerate(node);
        String javaType = node.getJavaType();
        MethodD md = MDKit.primitiveToString((String)javaType);
        if (md == null && length <= 0) {
            this.invoke(MDKit.OBJ_TO_STRING);
        } else if (md != null) {
            this.convert(md.getArgType(0));
            this.invoke(md);
        }
        if (length > 0) {
            this.loadConstant(length);
            this.invoke(MDKit.OBJ_TO_STRINGL);
        }
    }

    @Override
    public void generate(Conversion node) {
        throw new IllegalStateException("Conversion from: " + node.oldType + " to " + node.newType + " not defined.");
    }

    @Override
    public void generate(Conversion.Cast node) {
        Type to;
        this.operandGenerate(node);
        ObjectType from = TD.getObjectType((TypeDescription)node.getTypeDescription());
        if (node.newType.isBinary()) {
            to = TD.valueOf((TypeDescription)node.newType);
        } else {
            ObjectType toObj = TD.getObjectType((TypeDescription)node.newType);
            if (from.isCastableTo((Type)toObj)) {
                System.out.println("Using Conversion: " + from + " --> " + toObj);
                this.getCodeBuilder().loadClassConstant(toObj.getClassName());
                this.invoke(MDKit.CONVERSION_CAST);
            }
            to = toObj;
        }
        this.convert(to);
    }

    @Override
    public void generate(Conversion.Char node) {
        this.operandGenerate(node);
        this.invoke(MDKit.toChar((String)node.getOp1().getTypeDescription().getJavaType(), (boolean)node.newType.isPrimitive()));
    }

    @Override
    public void generate(Conversion.Deserialize node) {
        TypeDescription nt = node.newType;
        if (nt.getKind() != 11) {
            throw new IllegalStateException("Conversion from Binary to: " + nt);
        }
        this.operandGenerate(node);
        this.invoke(MDKit.DESERIALIZE);
        this.convert(TD.valueOf((TypeDescription)nt));
    }

    @Override
    public void generate(Conversion.Blob node) {
        node.getFirst().gen(this.cg);
        this.invoke(MDKit.BINARY_TO_BLOB);
    }

    @Override
    public void generate(Conversion.ToArray node) {
        TypeDescription ot = node.oldType;
        TypeDescription nt = node.newType;
        Node operand = node.getFirst();
        if (nt.isMap()) {
            operand.gen(this.cg);
            this.invoke(nt.isOrdered() ? MDKit.TO_TREEMAP : MDKit.TO_LINKEDHASHMAP);
        } else if (nt.isIterator()) {
            operand.gen(this.cg);
            this.invoke(MDKit.TO_ITERATOR);
        } else {
            operand.setMustClone(false);
            operand.gen(this.cg);
            if (nt.isPrimitive()) {
                node.getTargetElementClass().gen(this.cg);
                this.invoke(MDKit.TO_ARRAY);
                this.convert(TD.valueOf((TypeDescription)nt));
            } else {
                TypeDescription net;
                MethodD method = MDKit.TO_LISTWET;
                node.getTargetClass().gen(this.cg);
                ClassConst targetElement = node.getTargetElementClass();
                if (targetElement != null) {
                    method = MDKit.TO_LIST;
                    targetElement.gen(this.cg);
                }
                if ((net = nt.getElementType()) != null) {
                    TypeDescription oet = ot.getElementType();
                    int ol = oet == null ? -1 : oet.getLength();
                    int os = oet == null ? -1 : oet.getScale();
                    int nl = net.getLength();
                    int ns = net.getScale();
                    if (net.isDecimal() && ns != -1 && ns != os || net.isString() && nl != -1 && nl != ol) {
                        this.loadConstant(ns);
                        this.loadConstant(nl);
                        method = MDKit.TO_LISTSL;
                    }
                }
                this.invoke(method);
                this.convert(TD.valueOf((TypeDescription)node.newType));
            }
        }
    }

    @Override
    public void generate(Conversion.Decimal node) {
        int scale;
        int length;
        TypeDescription nt = node.newType;
        TypeDescription ot = node.oldType;
        this.operandGenerate(node);
        if (ot.isDecimal()) {
            length = ot.getLength();
            scale = ot.getScale();
        } else {
            this.invoke(MDKit.toDecimal((String)ot.getJavaType()));
            length = -1;
            scale = -1;
        }
        int newScale = nt.getScale();
        int newLength = nt.getLength();
        if (newScale >= 0 && newScale != scale) {
            this.loadConstant(newScale);
            this.invoke(MDKit.MD_SCALE);
        }
        int digits = JVMConversionGenerator.getDecimalDigits(length, scale);
        int newDigits = JVMConversionGenerator.getDecimalDigits(newLength, newScale);
        if (newDigits < digits) {
            this.loadConstant(nt.getLength());
            this.invoke(MDKit.MD_DECIMAL_CHECKLENGTH);
        }
    }

    @Override
    public void generate(Conversion.ToEnum conversion) {
        Node operand = conversion.getFirst();
        TypeDescription ot = conversion.oldType;
        TypeDescription nt = conversion.newType;
        if (nt.isNativeEnum()) {
            ObjectType enumType = TD.getObjectType((String)nt.getJavaType());
            if (ot.isString()) {
                operand.gen(this.cg);
                this.invoke(MDKit.enumValueOf((ObjectType)enumType));
            } else {
                this.invoke(MDKit.enumValues((ObjectType)enumType));
                operand.gen(this.cg);
                this.invoke(MDKit.OBJ_TO_INT);
                this.getCodeBuilder().arrayLoad();
            }
        } else {
            EnumTypeDescription enumType = (EnumTypeDescription)nt;
            if (ot.isString()) {
                conversion.getEnumArray().gen(this.cg);
                operand.gen(this.cg);
                this.invoke(MDKit.MAP_GET);
                if (enumType.isPrimitive()) {
                    this.invoke(MDKit.OBJ_TO_INT);
                }
            } else if (ot.isAny() || ot.isObject()) {
                operand.gen(this.cg);
                this.invoke(MDKit.objectTo((String)nt.getJavaType()));
            } else {
                operand.gen(this.cg);
                if (!enumType.isPrimitive()) {
                    this.invoke(MDKit.boxInt());
                }
            }
        }
    }

    void generateBox(TypeDescription oldType, TypeDescription newType) {
        Type oldTd = TD.valueOf((TypeDescription)oldType);
        if (newType.isString()) {
            this.generateToString(oldType);
        } else if (newType.isBool() && oldTd == TD.BOOLEAN) {
            this.invoke(MDKit.BOX_BOOLEAN);
        } else {
            assert (!newType.isPrimitive()) : "newType cannot be primitive: " + newType;
            ObjectType type = TD.getObjectType((TypeDescription)newType);
            MethodD md = MDKit.getBoxMethod((String)type.getClassName());
            this.convert(md.getArgType(0));
            this.invoke(md);
        }
    }

    private static int getDecimalDigits(int length, int scale) {
        return length < 0 ? Integer.MAX_VALUE : (scale < 0 ? length : length - scale);
    }

    private JVMCodeBuilder getCodeBuilder() {
        return this.cg.getCodeBuilder();
    }

    private void convert(Type to) {
        this.getCodeBuilder().convert(to);
    }

    private void generateToString(TypeDescription type) {
        this.invoke(MDKit.toString((String)type.getJavaType()));
    }

    private void invoke(MethodD md) {
        this.getCodeBuilder().invoke(md);
    }

    private void loadConstant(boolean value) {
        this.getCodeBuilder().loadConstant(value);
    }

    private void loadConstant(int scale) {
        this.getCodeBuilder().loadConstant(scale);
    }

    private void loadField(FieldD field) {
        this.getCodeBuilder().loadField(field);
    }

    private void loadNull() {
        this.getCodeBuilder().loadNull();
    }

    private void loadZero(Type td) {
        this.getCodeBuilder().loadZero(td);
    }

    private void operandGenerate(Conversion n) {
        n.getFirst().gen(this.cg);
    }
}

