/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.BreakPointException;
import oracle.bpm.compiler.BreakPointExecutionException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Node;

public class InvokeMethodBreakPoint
extends BreakPoint {
    private String componentName;
    private String methodName;

    public InvokeMethodBreakPoint(String componentName, String methodName) {
        this.componentName = componentName;
        this.methodName = methodName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InvokeMethodBreakPoint) {
            InvokeMethodBreakPoint bp = (InvokeMethodBreakPoint)obj;
            return this.componentName.equals(bp.componentName) && this.methodName.equals(bp.methodName);
        }
        return false;
    }

    public int hashCode() {
        String fullName = this.componentName + this.methodName;
        return fullName.hashCode();
    }

    @Override
    void evaluate(Node step) throws BreakPointException, BreakPointExecutionException {
        Invoke methodCall = (Invoke)step;
        if (methodCall.getComponentName().equals(this.componentName) && methodCall.getMethodName().equals(this.methodName)) {
            throw new BreakPointException(step, this);
        }
    }
}

