/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.bpm.compiler.ArrayReferenceException;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CannotOptimizeException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DuplicatedDeclarationException;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullStatement;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.Select;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.components.SQLException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.sql.QueryObject;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.FilterNotSupportedException;
import oracle.bpm.type.filter.IterablesByFilterRegistry;
import oracle.bpm.type.filter.Operation;
import oracle.bpm.util.ArrayUtils;

public class ForEach
extends LoopStatement {
    private TypeDescription elementType;
    private String filter;
    private boolean filteredIterable;
    private Symbol id = null;
    private List parameters = null;
    private Select select;
    private TypeDescription setType;
    static final String FILTERED_IT_FACTORY = "Miterator(Ljava.lang.String;[Ljava.lang.Object;)Ljava.util.Iterator;";

    public ForEach(Token t) {
        super(t);
    }

    ForEach() {
    }

    @Override
    public Node getArray() {
        return this.getOp2();
    }

    public TypeDescription getElementType() {
        return this.elementType;
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public Symbol getIdentifier() {
        return this.id;
    }

    @Override
    public boolean isIteratorUsed() {
        return this.getIdentifier().isTargetUsed();
    }

    @Override
    public List getParameters() {
        return this.parameters;
    }

    public Select getSelectStatement() {
        return this.select;
    }

    public TypeDescription getSetType() {
        return this.setType;
    }

    @Override
    public String getText() {
        return this.getName() + ":for-each" + "(" + this.getIndex().getText() + ")";
    }

    @Override
    public Node getWhere() {
        Node where = this.getOp3();
        return where != null && where.getNext() != null ? where : null;
    }

    @Override
    public boolean hasFilteredIterable() {
        return this.filteredIterable;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getIndex(), this.getArray(), this.getWhere(), this.getBody());
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    @Override
    Node getBody() {
        Node op3 = this.getOp3();
        return op3 != null && op3.getNext() != null ? op3.getNext() : op3;
    }

    Node getIndex() {
        return this.getOp1();
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        this.getArray().checkFlow(context);
        FlowContext split = context.split();
        Set<String> exit = split.backupExit();
        if (this.getWhere() != null) {
            this.getWhere().checkFlow(split);
        }
        this.getBody().checkFlow(split);
        split.catchExit(this.getName());
        split.restoreExit(exit);
        context.join(split);
        context.breaksFlow(false);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.id != null) {
            return this;
        }
        Node index = this.getIndex();
        Node set = this.getArray();
        Node where = this.getWhere();
        Node body = this.getBody();
        if (body instanceof Block) {
            Block block = (Block)body;
            this.setName(block.getName());
        }
        set = this.checkSet(set);
        SymbolTable symbols = this.getSymbolTable();
        if (this.isSQL(set.getTypeDescription())) {
            this.select = set instanceof Select ? (Select)set : new Select(new Tables(set), where);
            this.select.setParent(this);
            this.select.setNext(body);
            this.select.setScope(this.getScope());
            this.select.checkType();
            Tables tables = (Tables)this.select.getTables();
            TypeDescription queryType = tables.getTablesCount() == 1 && this.select.isAllColumns() ? tables.getTable(0) : this.select.getSQLType();
            where = null;
            set = this.select;
            if (symbols.get(index.getText()) != null) {
                this.reportWarning(new DuplicatedDeclarationException(index));
            }
            this.id = new Symbol(index.getText(), queryType);
            this.id.setUniqueSignature("elem");
            symbols.push(this.id);
            body = body.checkType();
        } else if (set.getTypeDescription().isIterable()) {
            this.setType = set.getTypeDescription();
            this.elementType = this.setType.getElementType();
            if (this.elementType == null) {
                this.elementType = this.setType;
            }
            if (!this.setType.isPrimitive()) {
                this.elementType = this.elementType.setReferenceType(true);
            }
            Symbol actualId = null;
            if (index instanceof Declaration) {
                Declaration decl = (Declaration)index;
                index = decl.getOp1();
                TypeDescription declType = decl.getDeclType().checkType().getTypeDescription();
                if (declType.equals(this.elementType)) {
                    this.id = decl.checkType().getSymbol();
                } else {
                    String tempName = decl.getName() + "$elem";
                    this.id = new Symbol(tempName, this.elementType);
                    symbols.push(this.id);
                    Deref initExpr = new Deref(new Identifier(tempName));
                    initExpr.initialize(decl);
                    decl.addChild((AST)initExpr);
                    decl.checkType();
                    actualId = decl.getSymbol();
                    Node auxDecl = Node.deepCopy(decl);
                    auxDecl.setSynthetic(true);
                    auxDecl.setNext(body.getFirst());
                    body.setFirst(auxDecl);
                }
            } else {
                String indexName = index.getText();
                this.id = new Symbol(indexName, this.elementType);
                this.id.setUniqueSignature("elem");
                if (symbols.get(indexName) != null) {
                    if (!this.getCurrentLanguage().isLastVersion()) {
                        if (this.isGeneratingSource()) {
                            indexName = this.findFreeId(indexName);
                            Identifier newIndex = new Identifier(indexName);
                            newIndex.initialize(index);
                            index = newIndex;
                        }
                    } else {
                        this.reportWarning(new DuplicatedDeclarationException(index));
                    }
                }
            }
            if (!this.setType.isPrimitive()) {
                Symbol it = new Symbol(index.getText(), TypeFactory.getIterator(TypeFactory.getAny()));
                it.setUniqueSignature("iterator");
                it.setFilteredIterable(IterablesByFilterRegistry.contains(this.setType));
                this.id.setTarget(it);
                if (actualId != null) {
                    actualId.setTarget(it);
                }
            }
            if (set instanceof TypeSpec) {
                set = new DefaultConst(this.getFirst(), this.setType).checkType();
            }
            symbols.push(this.id);
            if (where != null) {
                Scope subscope = this.getScope().makeSubScope();
                SymbolTable table = subscope.getSymbolTable();
                int length = this.elementType.getMemberCount();
                for (int i = 0; i < length; ++i) {
                    MethodTypeDescription memberType = this.elementType.getMemberType(i);
                    if (!memberType.isAttribute()) continue;
                    String name = memberType.getName();
                    Symbol attr = new Symbol(name, this.elementType);
                    attr.setMember(memberType);
                    attr.setTarget(this.id);
                    table.push(attr);
                }
                where.setScope(subscope);
                where = where.checkType();
                if (IterablesByFilterRegistry.contains(this.setType)) {
                    String filter;
                    List<Node> parameters = where.collectParameters(CollectionPool.<Node>getArrayList());
                    try {
                        Operation tree = where.getOperationTree();
                        filter = this.setType.getIteratorFilter(tree);
                    }
                    catch (FilterNotSupportedException e) {
                        this.reportWarning(new CannotOptimizeException(where));
                        filter = null;
                    }
                    if (filter != null) {
                        this.parameters = parameters;
                        this.filter = filter;
                        this.filteredIterable = true;
                    }
                }
            }
            body = body.checkType();
        } else {
            throw new ArrayReferenceException(this.getArray(), set.getTypeDescription());
        }
        if (body == NullStatement.NODE) {
            return NullStatement.NODE;
        }
        if (where != null) {
            this.setOperands(index, set, where);
            where.setNext(body);
        } else {
            this.setOperands(index, set, body);
        }
        this.setTypeDescription(TypeFactory.getVoid());
        return this.processBody(body);
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    Node refactor(CodeStyle ss) {
        super.refactor(ss);
        if (this.select == null) {
            If ifnode;
            boolean replaceWhere;
            Node index = this.getIndex();
            Node set = this.getArray();
            Node where = this.getWhere();
            Node body = this.getBody();
            int childrenCount = body.childCount();
            Node first = body.getFirst();
            boolean bl = replaceWhere = ss.getReplaceIfWithWhere() == 1;
            if (replaceWhere && childrenCount == 1 && first instanceof If && !(ifnode = (If)first).hasElse()) {
                Node pred = ifnode.getPredicate();
                body = ifnode.getThen();
                where = where != null ? Logic.and(where, pred) : pred;
                pred.setNext(null);
                this.setOperands(index, set, where);
                where.setNext(body);
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Node body = this.getBody();
        if (this.select == null) {
            Node arrayNode = this.getArray();
            Object array = arrayNode.value(rm);
            Symbol idSymbol = this.id;
            Symbol it = idSymbol.getTarget();
            try {
                Iterator iterator;
                if (array == null) {
                    return null;
                }
                if (array.getClass().isArray()) {
                    int length = Array.getLength(array);
                    for (int i = 0; i < length; ++i) {
                        idSymbol.setValue(Array.get(array, i));
                        body.run(rm);
                    }
                    return null;
                }
                if (!IterablesByFilterRegistry.contains(this.setType)) {
                    iterator = ArrayUtils.elementIterator(array);
                } else {
                    Invokeable object = (Invokeable)array;
                    Object[] params = null;
                    if (this.parameters != null && this.parameters.size() != 0) {
                        params = this.parameters.toArray();
                        for (int i = 0; i < params.length; ++i) {
                            Node node = (Node)params[i];
                            params[i] = node.value(rm);
                        }
                    }
                    Object[] args = new Object[]{this.filter, params};
                    iterator = (Iterator)object.invoke(FILTERED_IT_FACTORY, args);
                }
                it.setValue(iterator);
                Node where = this.getWhere();
                if (where == null) {
                    while (iterator.hasNext()) {
                        idSymbol.setValue(iterator.next());
                        body.run(rm);
                    }
                    return null;
                }
                while (iterator.hasNext()) {
                    idSymbol.setValue(iterator.next());
                    Boolean cond = (Boolean)where.value(rm);
                    if (!Any.equals(Boolean.TRUE, cond)) continue;
                    body.run(rm);
                }
                return null;
            }
            catch (ExitException exit) {
                if (exit.getLabel() == null || exit.getLabel().equals(this.getName())) return null;
                throw exit;
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        }
        QueryObject obj = null;
        try {
            obj = (QueryObject)this.select.run(rm);
            Symbol idSymbol = this.getSymbolTable().get(this.id.getName());
            while (obj.hasNext()) {
                idSymbol.setValue(obj);
                body.run(rm);
            }
            return null;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (SQLException e) {
            CompilerExceptionShell exception = new CompilerExceptionShell((Node)this, (Throwable)e);
            rm.exceptionEvent(exception);
            throw exception;
        }
        finally {
            try {
                if (obj != null) {
                    obj.close();
                }
            }
            catch (SQLException e) {
                CompilerExceptionShell exception = new CompilerExceptionShell((Node)this, (Throwable)e);
                rm.exceptionEvent(exception);
                throw exception;
            }
        }
    }

    private boolean isSQL(TypeDescription type) {
        return "sql".equals(type.asObject().getComponentType());
    }

    private Node checkSet(Node set) throws TypeException {
        Node result;
        block11: {
            try {
                result = set.checkType();
                TypeDescription type = result.getTypeDescription();
                if (type.isEnum()) {
                    EnumTypeDescription enumType = (EnumTypeDescription)type;
                    result = EnumConst.makeArray(enumType, result);
                }
            }
            catch (TypeException e) {
                String typeText;
                TypeDescription type;
                if (!(e instanceof UndefinedVariableException) && !(e instanceof MemberReferenceException)) {
                    throw e;
                }
                result = EnumConst.checkEnum(set);
                if (result != null) break block11;
                try {
                    type = TypeSpec.findType(set);
                }
                catch (NoSuchComponentException ne) {
                    type = null;
                }
                if (type == null && this.getCurrentLanguage().isOldTypePrecedenceEnabled() && (typeText = set.getTypeText()) != null) {
                    typeText = typeText.toUpperCase();
                    try {
                        type = this.findType(typeText, false);
                        if (type != null && !type.isSql()) {
                            type = null;
                        }
                    }
                    catch (TypeException e1) {
                        // empty catch block
                    }
                }
                if (type == null) {
                    throw e;
                }
                result = new TypeSpec(type, set);
            }
        }
        return result;
    }
}

