/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonBooleanException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;

public class ExprIf
extends Ternary {
    public ExprIf(Token t) {
        super(t);
    }

    ExprIf(Node cond, Node ifTrue, Node ifFalse) {
        this.setOperands(cond, ifTrue, ifFalse);
    }

    @Override
    public String getText() {
        return "?";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getPredicate(), this.getTrueExpr(), this.getFalseExpr());
    }

    Node getFalseExpr() {
        return this.getOp3();
    }

    Node getPredicate() {
        return this.getOp1();
    }

    Node getTrueExpr() {
        return this.getOp2();
    }

    @Override
    Node checkType() throws TypeException {
        TypeDescription t2;
        super.checkType();
        Node predicate = this.getPredicate();
        Node o1 = this.getTrueExpr();
        Node o2 = this.getFalseExpr();
        if (predicate.getKind() != 1) {
            throw new NonBooleanException(predicate);
        }
        TypeDescription t1 = o1.getTypeDescription();
        if (!t1.isAssignableFrom(t2 = o2.getTypeDescription()) && !t2.isAssignableFrom(t1)) {
            throw new IncompatibleTypesException(this, o1, o2);
        }
        if (!this.isGeneratingSource() && predicate.isConstant()) {
            BoolConst bool = (BoolConst)predicate;
            return bool.booleanValue() ? o1 : o2;
        }
        predicate = Conversion.UnBox.create(predicate).checkType();
        TypeDescription promotion = t1.promote(t2);
        o1 = Conversion.promote(o1, promotion);
        o2 = Conversion.promote(o2, promotion);
        this.setTypeDescription(promotion);
        this.setOperands(predicate, o1, o2);
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        boolean predicate = (Boolean)this.getOp1().value(rm);
        Node expr = predicate ? this.getTrueExpr() : this.getFalseExpr();
        return expr.run(rm);
    }
}

