/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

class ErrorMapping
extends Node {
    private int memberPart;
    private MethodTypeDescription replacement;

    ErrorMapping(Node node, MethodTypeDescription replacement) {
        this(node, replacement, 0);
    }

    ErrorMapping(Node node, MethodTypeDescription replacement, int memberPart) {
        super((AST)node);
        this.replacement = replacement;
        this.memberPart = memberPart;
    }

    @Override
    public void reportError(CilException error) {
        this.remap(error);
        super.reportError(error);
    }

    @Override
    public void reportWarning(CilException warning) {
        this.remap(warning);
        super.reportWarning(warning);
    }

    @Override
    public void generate(SourceGenerator cg) {
        this.getOp1().generate(cg);
    }

    @Override
    Node checkType() throws TypeException {
        Node result = super.checkType();
        this.setTypeDescription(TypeFactory.getVoid());
        return result;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.getOp1().run(rm);
    }

    private void remap(CilException error) {
        boolean isSynthetic;
        TypeDescription member = error.getMember();
        boolean bl = isSynthetic = member == null || member.isSynthesized();
        if (isSynthetic || member == this.getCurrentMember().getMethodType()) {
            error.setMember(this.replacement);
            if (this.memberPart != 0) {
                error.setMemberPart(this.memberPart);
            }
        }
    }
}

