/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.debug.components.ActivityDebug;
import oracle.bpm.compiler.debug.components.ParticipantDebug;
import oracle.bpm.component.Component;
import oracle.bpm.component.ContextEvent;
import oracle.bpm.component.ContextListener;
import oracle.bpm.component.ExecutionThreadContext;
import oracle.bpm.component.Principal;
import oracle.bpm.components.ActivityInterface;
import oracle.bpm.components.ParticipantInterface;
import oracle.bpm.components.ProcessBeanDebug;
import oracle.bpm.components.ProcessInstance;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.log.Log;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.FuegoClass;
import oracle.bpm.util.ExecutionContextAccessor;

public class DebuggerContext
extends ExecutionThreadContext
implements ContextListener {
    private boolean commit;

    public DebuggerContext(Principal parent, boolean commit) {
        this(parent, commit, null);
    }

    public DebuggerContext(Principal parent, boolean commit, ComponentCatalog catalog) {
        super(parent, true);
        this.commit = commit;
        ExecutionContextAccessor.getContext().enableClient(true);
        Component.setRunningOnDebugger();
        ProcessInstance instance = new ProcessInstance();
        ProcessBeanDebug bean = new ProcessBeanDebug(DefaultEnvironment.create("debug"));
        ParticipantDebug participant = new ParticipantDebug();
        bean.setParticipantInterface((ParticipantInterface)participant);
        instance.setContext(bean, (ActivityInterface)new ActivityDebug());
        ExecutionContextAccessor.getContext().putProperty("oracle.bpm.components.ProcessInstance.currentInstance", instance);
        ExecutionContextAccessor.getContext().putProperty("oracle.bpm.components.ProcessInstance.currentProcessBean", bean);
        if (ConnectorTransaction.hasConnectorService()) {
            ConnectorTransaction.start();
        }
        FuegoClass.setProjectCatalog(catalog);
        this.addListener(this);
    }

    @Override
    public void processEvent(ExecutionThreadContext source, ContextEvent event) {
        if (event == ContextEvent.DISPOSE) {
            FuegoClass.setProjectCatalog(null);
            try {
                if (ConnectorTransaction.hasConnectorService()) {
                    ConnectorTransaction connectorTransaction = ConnectorTransaction.current();
                    if (this.commit) {
                        connectorTransaction.commit();
                    } else {
                        connectorTransaction.rollback();
                    }
                }
            }
            catch (Exception e) {
                Log.logWarning(e);
            }
        }
    }

    public void setCatalog(ComponentCatalog catalog) {
    }

    public boolean shouldCommit() {
        return this.commit;
    }

    public int compareTo(Object o) {
        return -1;
    }
}

