/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CodeDebugger;

public class DebuggerActionManager
implements CodeDebugger.StatusListener {
    private DebuggerAction backAction;
    private DebuggerAction exitAction;
    private DebuggerAction forwardAction;
    private DebuggerAction ignoreAction;
    private DebuggerAction runAction = DO_NOTHING_ACTION;
    private DebuggerAction stepOverAction = DO_NOTHING_ACTION;
    private DebuggerAction stopAction = DO_NOTHING_ACTION;
    private DebuggerAction suspendAction;
    public static final DoNothingAction DO_NOTHING_ACTION = new DoNothingAction();

    protected DebuggerActionManager() {
        this.ignoreAction = DO_NOTHING_ACTION;
        this.backAction = DO_NOTHING_ACTION;
        this.forwardAction = DO_NOTHING_ACTION;
        this.exitAction = DO_NOTHING_ACTION;
        this.suspendAction = DO_NOTHING_ACTION;
    }

    public void setBackAction(DebuggerAction backAction) {
        this.backAction = this.notNull(backAction);
    }

    public DebuggerAction getBackAction() {
        return this.backAction;
    }

    public void setExitAction(DebuggerAction exitAction) {
        this.exitAction = this.notNull(exitAction);
    }

    public DebuggerAction getExitAction() {
        return this.exitAction;
    }

    public void setForwardAction(DebuggerAction forwardAction) {
        this.forwardAction = this.notNull(forwardAction);
    }

    public DebuggerAction getForwardAction() {
        return this.forwardAction;
    }

    public void setIgnoreAction(DebuggerAction ignoreAction) {
        this.ignoreAction = this.notNull(ignoreAction);
    }

    public DebuggerAction getIgnoreAction() {
        return this.ignoreAction;
    }

    public void setRunAction(DebuggerAction runAction) {
        this.runAction = this.notNull(runAction);
    }

    public DebuggerAction getRunAction() {
        return this.runAction;
    }

    public void setStepOverAction(DebuggerAction stepOverAction) {
        this.stepOverAction = this.notNull(stepOverAction);
    }

    public DebuggerAction getStepOverAction() {
        return this.stepOverAction;
    }

    public void setStopAction(DebuggerAction stopAction) {
        this.stopAction = this.notNull(stopAction);
    }

    public DebuggerAction getStopAction() {
        return this.stopAction;
    }

    public void setSuspendAction(DebuggerAction suspendAction) {
        this.suspendAction = this.notNull(suspendAction);
    }

    public DebuggerAction getSuspendAction() {
        return this.suspendAction;
    }

    public void init() {
        this.stopped();
    }

    @Override
    public void running() {
        this.getRunAction().setEnabled(false);
        this.getStopAction().setEnabled(true);
        this.getStepOverAction().setEnabled(false);
        this.getIgnoreAction().setEnabled(false);
        this.getBackAction().setEnabled(false);
        this.getForwardAction().setEnabled(false);
        this.getExitAction().setEnabled(true);
        this.getSuspendAction().setEnabled(true);
    }

    @Override
    public void stepping() {
        this.getRunAction().setEnabled(true);
        this.getStopAction().setEnabled(true);
        this.getStepOverAction().setEnabled(true);
        this.getIgnoreAction().setEnabled(true);
        this.getBackAction().setEnabled(true);
        this.getForwardAction().setEnabled(false);
        this.getExitAction().setEnabled(true);
        this.getSuspendAction().setEnabled(false);
    }

    @Override
    public void stopped() {
        this.getRunAction().setEnabled(true);
        this.getStepOverAction().setEnabled(true);
        this.getStopAction().setEnabled(false);
        this.getIgnoreAction().setEnabled(false);
        this.getBackAction().setEnabled(false);
        this.getForwardAction().setEnabled(false);
        this.getSuspendAction().setEnabled(false);
    }

    private DebuggerAction notNull(DebuggerAction action) {
        if (action == null) {
            return DO_NOTHING_ACTION;
        }
        return action;
    }

    private static class DoNothingAction
    implements DebuggerAction {
        private DoNothingAction() {
        }

        @Override
        public void setEnabled(boolean enabled) {
        }
    }

    public static interface DebuggerAction {
        public void setEnabled(boolean var1);
    }
}

