/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import oracle.bpm.bcgen.TDKit;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.ConversionException;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.DynamicTypeDescription;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.runtime.Display;
import oracle.bpm.sql.BlobImpl;
import oracle.bpm.sql.ColumnReference;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeMappings;
import oracle.bpm.type.filter.Operation;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.DefaultValue;
import org.jetbrains.annotations.NonNls;

public class Conversion
extends Node {
    protected TypeDescription newType;
    protected TypeDescription oldType;
    private Node enumArray;
    private boolean syntheticCast = true;
    private ClassConst targetElementClass;
    @NonNls
    private static final String JAVA_LANG_OBJECT = "Java.Lang.Object";

    Conversion() {
    }

    Conversion(Token t) {
        super(t);
    }

    Conversion(Node operand, TypeDescription newType) {
        assert (newType != null);
        this.copyParentFrom(operand);
        this.initialize(operand);
        this.newType = newType;
        this.setOperand(operand);
    }

    Conversion(Node operand, String javaType, TypeDescription toType) {
        this.copyParentFrom(operand);
        if (javaType == null) assert (false) : "Java type is null, operand: " + operand + ", toType: " + toType;
        this.newType = toType;
        this.setOperand(operand);
        this.initialize(operand);
    }

    public Node getEnumArray() {
        return this.enumArray;
    }

    @Override
    public String getText() {
        String old = this.oldType == null ? "" : this.oldType.getText();
        return old + "=>" + this.newType.getText();
    }

    public boolean isSyntheticCast() {
        return this.syntheticCast;
    }

    public void setSyntheticCast(boolean syntheticCast) {
        this.syntheticCast = syntheticCast;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getFirst());
    }

    @Override
    public boolean getParenthesis() {
        return super.getParenthesis();
    }

    @Override
    public boolean isSynthetic() {
        return this.getOperand().isSynthetic();
    }

    public Node getOperand() {
        Node op = this.getFirst();
        if (op instanceof Conversion) {
            return ((Conversion)op).getOperand();
        }
        return op;
    }

    protected Node basicCheck() throws TypeException {
        Node operand = null;
        if (this.getKind() == -1) {
            super.checkType();
            operand = this.getFirst();
            this.oldType = operand.getTypeDescription();
            if (!Conversion.isConvertible(this.oldType, this.newType)) {
                throw new ConversionException((Node)this, this.oldType, this.newType);
            }
            this.setTypeDescription(this.newType);
        }
        return operand;
    }

    protected Object checkResult(Object result) {
        if (result == null && this.newType.isPrimitive() && this.newType.getKind() != 12) {
            result = DefaultValue.forClass(this.newType.getJavaClass());
        }
        return result;
    }

    protected Node enumToString(Node operand) throws TypeException {
        Node result = this;
        EnumTypeDescription enumType = (EnumTypeDescription)this.oldType;
        if (!enumType.isNativeEnum()) {
            ArrayConst arrayConst = EnumConst.makeLabelArray((EnumTypeDescription)this.oldType, this);
            Node index = Conversion.promote(operand, TypeFactory.getPrimitiveInt(32));
            result = new ArrayReference(arrayConst, index);
            result = result.checkType();
        }
        result.initialize(operand);
        return result;
    }

    protected boolean isCast() {
        return false;
    }

    protected void toEnum() throws TypeException {
        EnumTypeDescription enumType = this.newType.asEnum();
        if (!enumType.isNativeEnum()) {
            this.enumArray = this.oldType.isString() ? EnumConst.makeEnumArray(enumType, this) : EnumConst.makeLabelArray(enumType, this, true);
            assert (this.enumArray != null);
        }
    }

    static boolean isConvertible(TypeDescription source, TypeDescription target) {
        assert (!source.isMember()) : "Source can not be a MethodTypeDescription";
        if (target.isAssignableFrom(source) || source.isAssignableFrom(target)) {
            return true;
        }
        if (Conversion.isJavaLangObject(source) || Conversion.isJavaLangObject(target)) {
            return true;
        }
        if (target.isPredefined() && source.isString()) {
            return true;
        }
        if (target.isString()) {
            return true;
        }
        if (source.getKind() == 9) {
            return true;
        }
        if (source.getKind() == 8 || target.getKind() == 8) {
            return true;
        }
        if (source.getKind() == 11) {
            target = target.asObject();
        }
        switch (target.getKind()) {
            case 5: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: {
                if (!source.isNumber()) break;
                return true;
            }
            case 1: {
                if (source.getKind() != 1) break;
                return true;
            }
            case 6: {
                if (!source.isNumber()) break;
                return true;
            }
            case 7: {
                if (!source.isNumber()) break;
                return true;
            }
            case 8: {
                return true;
            }
            case 11: {
                source = source.asObject();
                if (target.isAssignableFrom(source) || source.isAssignableFrom(target)) {
                    return true;
                }
                if (!target.isInterface() && !source.isInterface()) break;
                return true;
            }
            case 12: {
                TypeDescription elemType = target.getElementType();
                int kind = elemType.getKind();
                if (source.isString() && kind == 5) {
                    return true;
                }
                return true;
            }
            case 17: {
                return true;
            }
        }
        return false;
    }

    static String cast(TypeDescription type, String externalType) {
        return "(" + TDKit.getJavaType((TypeDescription)type, (String)externalType) + ")";
    }

    static boolean isAssignable(TypeDescription type1, String type2, boolean from) {
        boolean assignable;
        boolean bl = type2.equals("java.lang.Object") || type2.equals(type1.isString() ? String.class.getName() : type1.getJavaType()) ? true : (assignable = false);
        if (!assignable) {
            try {
                Class<?> c1 = Class.forName(type2);
                Class<?> c2 = type1.getJavaClass();
                assignable = from ? c2.isAssignableFrom(c1) : c1.isAssignableFrom(c2);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return assignable;
    }

    static Node promote(Node operand, ColumnReference ref) throws TypeException {
        Node promoted = Conversion.promote(operand, ref.getType());
        if (Modifier.isExternal(ref.getModifiers())) {
            TypeDescription targetType = ref.getType();
            promoted = Export.create(promoted, ref.getJavaType(), targetType).checkType(targetType);
        }
        return promoted;
    }

    static Node promote(Node operand, TypeDescription targetType) throws TypeException {
        return Conversion.promote(operand, targetType, true);
    }

    static Node promote(Node operand, TypeDescription targetType, boolean syntethicCast) throws TypeException {
        Node result;
        TypeDescription opType = operand.getTypeDescription();
        if (Conversion.isJavaLangObject(targetType)) {
            targetType = TypeFactory.getAny();
        }
        if (opType.equals(targetType)) {
            result = operand;
        } else {
            result = Conversion.isIdentityConversion(opType, targetType) ? new Identity(operand, targetType).checkType() : (opType == TypeFactory.getNull() ? new Null(operand, targetType).checkType(targetType) : (targetType.isArray() || targetType.isIterator() ? ToArray.create(operand, targetType).checkType(targetType) : (opType.primitiveEquivalent(true).equals(targetType) && opType.isPredefined() ? UnBox.create(operand, targetType).checkType(targetType) : (targetType.primitiveEquivalent(true).equals(opType) && opType.isPredefined() || opType.isPrimitive() && targetType.isObject() ? Box.create(operand).checkType(targetType) : (targetType.isPredefined() ? Conversion.convertToPredefined(operand, targetType, opType).checkType(targetType) : (targetType.isObject() && opType.isTime() ? Export.create(operand, targetType.getJavaType(), targetType).checkType() : (opType.isStrictSubtype(targetType) ? new Wide(operand, targetType).checkType(targetType) : (targetType.isStrictSubtype(opType) && !targetType.isEnum() ? Narrow.create(operand, targetType).checkType(targetType) : (opType == DynamicTypeDescription.INSTANCE || targetType == DynamicTypeDescription.INSTANCE ? new Dynamic(operand, targetType).checkType(targetType) : (targetType.isEnum() ? ToEnum.create(operand, targetType).checkType(targetType) : (opType.isBinary() ? new Deserialize(operand, targetType).checkType(targetType) : (opType.isInvokeable() && targetType.isInvokeable() ? operand : (opType.isObject() && targetType.isInterface() ? Cast.create(operand, targetType).checkType(targetType) : new Type(operand, targetType).checkType(targetType))))))))))))));
            if (result != operand && result.isConversion()) {
                ((Conversion)result).setSyntheticCast(syntethicCast);
            }
        }
        return result;
    }

    static Node promoteFrom45(Node operand, TypeDescription targetType) throws TypeException {
        Node parent = operand.getParent();
        Node cast = Cast.create(operand, targetType);
        cast.initialize(operand);
        cast.setParent(parent);
        return cast.checkType();
    }

    static Node promoteParameter(Node node) throws TypeException {
        node = Conversion.promote(Conversion.copyWithLinks(node), node.getTypeDescription().primitiveEquivalent(false));
        switch (node.getKind()) {
            case 6: {
                node = Export.create(node, "java.sql.Timestamp", TypeFactory.getTime()).checkType(TypeFactory.getTime());
            }
        }
        return node;
    }

    TypeDescription getOperandType() {
        return this.getOperand().getTypeDescription();
    }

    @Override
    Node checkType() throws TypeException {
        Node operand = this.basicCheck();
        if (operand == null) {
            return this;
        }
        Node result = this;
        int nk = this.newType.getKind();
        if ((this.oldType.isPredefined() || this.oldType.isEnum()) && this.oldType.isPrimitive() && (nk == 11 || nk == 10 || nk == 8)) {
            operand = operand.getTypeDescription().isPrimitive() ? Box.create(operand).checkType() : operand;
            this.setOperand(operand);
            this.oldType = this.oldType.primitiveEquivalent(false);
        } else if (operand.isConstant() && !this.isGeneratingSource() && this.newType.getKind() != 15 && operand instanceof Const) {
            Const constant = (Const)operand;
            Const c = constant.convertTo(this.newType);
            if (c != null) {
                return c;
            }
        } else if (this.oldType.isEnum() && this.newType.isString() && !this.isGeneratingSource()) {
            result = this.enumToString(operand);
        }
        if (this.newType.isEnum()) {
            this.toEnum();
        }
        if (this.newType.getKind() == 12 || this.newType.getKind() == 13) {
            this.targetElementClass = new ClassConst(this.newType.getElementType(), (Node)this);
        }
        return result;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.enumArray != null) {
            this.enumArray.collectConstants(cp);
        }
        if (this.targetElementClass != null) {
            this.targetElementClass.collectConstants(cp);
        }
    }

    boolean existsConversionTo(String targetJavaType) {
        for (Method method : oracle.bpm.util.Conversion.class.getMethods()) {
            if (!method.getName().equals("to" + targetJavaType.replace('.', '_'))) continue;
            return true;
        }
        return false;
    }

    @Override
    Node externalNode() {
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.getConversionGenerator().generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        this.getFirst().generateSQLCode(sql);
    }

    ClassConst getTargetElementClass() {
        return this.targetElementClass;
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    @Override
    boolean isConversion() {
        return true;
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        return this.getFirst().collectParameters(params);
    }

    @Override
    boolean isParameter() {
        return this.getFirst().isParameter();
    }

    @Override
    boolean isParametric() {
        return this.getFirst().isParametric();
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.run(rm, this.newType.getJavaType());
    }

    Object run(RunningMonitor rm, String javaType) throws ExecutionException {
        try {
            Node operand = this.getFirst();
            Object result = operand.value(rm);
            if (result == null) {
                return this.checkResult(result);
            }
            switch (this.newType.getKind()) {
                case 13: {
                    result = this.newType.isOrdered() ? ArrayUtils.toTreeMap(result) : ArrayUtils.toLinkedHashMap(result);
                    return result;
                }
                case 12: {
                    if (this.oldType.isArray()) {
                        if (this.newType.isPrimitive()) {
                            if (result.getClass().isArray()) {
                                return result;
                            }
                            Class c = (Class)oracle.bpm.lang.Cast.force(this.targetElementClass.value(rm));
                            return ArrayUtils.toArray(result, c);
                        }
                        if (this.targetElementClass != null) {
                            TypeDescription newElemType = this.newType.getElementType();
                            TypeDescription oldElemType = this.oldType.getElementType();
                            result = oldElemType != null && (newElemType.getScale() != oldElemType.getScale() || oldElemType.getLength() != newElemType.getLength()) ? oracle.bpm.util.Conversion.toList(result, this.newType.getJavaClass(), (Class)this.targetElementClass.value(rm), newElemType.getScale(), newElemType.getLength()) : oracle.bpm.util.Conversion.toList(result, this.newType.getJavaClass(), (Class)this.targetElementClass.value(rm));
                        } else {
                            result = oracle.bpm.util.Conversion.toList(result, this.newType.getJavaClass());
                        }
                        return result;
                    }
                    if (this.targetElementClass == null) break;
                    oracle.bpm.util.Conversion.checkElementType(result, (Class)this.targetElementClass.value(rm));
                    break;
                }
                case 3: {
                    result = oracle.bpm.util.Conversion.tojava_math_BigDecimal(result, this.newType.getScale(), this.newType.getLength());
                    return result;
                }
                case 5: {
                    return Str.valueOf(result, this.newType.getLength());
                }
                case 17: {
                    JavaEnumTypeDescription enumType = (JavaEnumTypeDescription)this.newType;
                    if (enumType.isNativeEnum()) {
                        if (this.oldType.isEnum()) {
                            return enumType.newInstance(oracle.bpm.util.Conversion.tojava_lang_Integer(result).intValue());
                        }
                        if (this.oldType.isString()) {
                            return enumType.newInstance((String)result);
                        }
                        if (this.oldType.isInt()) {
                            return enumType.newInstance(((Number)result).intValue());
                        }
                    } else {
                        int e;
                        if (this.oldType.isEnum()) {
                            return oracle.bpm.util.Conversion.tojava_lang_Integer(result);
                        }
                        if (this.oldType.isString()) {
                            String str = (String)result;
                            e = oracle.bpm.util.Conversion.toenum(str, (Map)this.enumArray.value(rm));
                        } else if (enumType.isSequential() && this.oldType.isInt()) {
                            int max = enumType.getMemberCount() - 1;
                            int intvalue = ((Number)result).intValue();
                            e = oracle.bpm.util.Conversion.toenum(intvalue, this.newType.getName(), max);
                        } else {
                            Map map = (Map)this.enumArray.value(rm);
                            e = oracle.bpm.util.Conversion.toenum(result, this.newType.getName(), map);
                        }
                        return e;
                    }
                    throw new IllegalStateException("Unreacheable");
                }
                case 8: {
                    return oracle.bpm.util.Conversion.toBinary(result);
                }
            }
            Method conversor = oracle.bpm.util.Conversion.getMethod(result.getClass(), javaType);
            if (conversor != null) {
                result = conversor.invoke(null, result);
            }
            return this.checkResult(result);
        }
        catch (IllegalAccessException noway) {
            this.reportError(new InternalException((Node)this, (Throwable)noway));
            throw new RuntimeExceptionShell(noway);
        }
        catch (IllegalArgumentException noway) {
            this.reportError(new InternalException((Node)this, (Throwable)noway));
            throw new RuntimeExceptionShell(noway);
        }
        catch (InvocationTargetException ite) {
            throw new CompilerExceptionShell(this.getOp1(), ite.getTargetException());
        }
        catch (InstantiationException e) {
            throw new CompilerExceptionShell(this.getOp1(), (Throwable)e);
        }
    }

    @Override
    void setLeftValue(boolean left) {
        this.getOperand().setLeftValue(left);
    }

    @Override
    void setParameter(boolean parameter) {
        this.getFirst().setParameter(parameter);
    }

    @Override
    void setParametric(boolean p) {
        this.getFirst().setParametric(p);
    }

    @Override
    void setSynthetic(boolean synthetic) {
        this.getOperand().setSynthetic(synthetic);
    }

    void setTargetElementClass(ClassConst classConst) {
        this.targetElementClass = classConst;
    }

    @Override
    Operation getOperationTree() {
        return this.getFirst().getOperationTree();
    }

    private static boolean isIdentityConversion(TypeDescription sourceType, TypeDescription targetType) {
        return sourceType.equals(targetType) || targetType.isObject() && sourceType.isPredefined() && !sourceType.isPrimitive() && sourceType.asObject().isStrictSubtype(targetType);
    }

    private static boolean isJavaLangObject(TypeDescription typeDescription) {
        return typeDescription != null && typeDescription.getText().equals(JAVA_LANG_OBJECT);
    }

    private static Node convertToPredefined(Node operand, TypeDescription targetType, TypeDescription opType) throws TypeException {
        Node result = null;
        int kind = targetType.getKind();
        boolean primitive = opType.isPrimitive();
        switch (kind) {
            case 0: {
                throw new IllegalStateException("Invalid target type");
            }
            case 1: {
                result = new Bool(operand, targetType);
                break;
            }
            case 2: 
            case 4: {
                if (targetType.isPrimitive() && opType.isNumber()) {
                    result = primitive ? Narrow.create(operand, targetType) : UnBox.create(operand, targetType);
                    break;
                }
                if (opType.isEnum() && !opType.isNativeEnum()) {
                    result = primitive == targetType.isPrimitive() ? Narrow.create(operand, targetType) : (primitive ? Box.create(operand) : UnBox.create(operand, targetType));
                    result.setTypeDescription(targetType);
                    break;
                }
                if (primitive && opType.isNumber()) {
                    TypeDescription toType = targetType.primitiveEquivalent(true);
                    result = Box.create(Narrow.create(operand, toType).checkType(toType));
                    break;
                }
                result = new IntReal(operand, targetType);
                break;
            }
            case 3: {
                result = Decimal.create(operand, targetType);
                break;
            }
            case 5: {
                result = Stringify.create(operand, targetType);
                break;
            }
            case 6: 
            case 7: {
                result = TimeInterval.create(operand, targetType);
                break;
            }
            case 8: {
                result = new Binary(operand);
                break;
            }
            case 15: {
                result = new Dynamic(operand, targetType);
                break;
            }
            case 10: {
                result = primitive && !opType.isArray() ? Box.create(operand) : operand;
            }
        }
        return result;
    }

    static class Wide
    extends Conversion {
        public Wide(Node operand, TypeDescription toType) {
            super(operand, toType);
            assert (operand.getTypeDescription().isPrimitive() == this.newType.isPrimitive()) : "primitive mismatch - ot: " + operand.getTypeDescription() + ", " + " nt: " + this.newType;
        }

        static Object run(RunningMonitor rm, Node op, TypeDescription newType) throws ExecutionException {
            Object value = op.value(rm);
            switch (newType.getKind()) {
                case 2: {
                    Number num = (Number)value;
                    value = IntConst.createValue(num != null ? num.longValue() : 0L, newType);
                    break;
                }
                case 4: {
                    Number num = (Number)value;
                    value = RealConst.createValue(num != null ? num.doubleValue() : 0.0, newType);
                    break;
                }
                case 11: {
                    Class iface;
                    boolean isJavaInterface;
                    boolean bl = isJavaInterface = "java".equals(newType.getComponentType()) && newType.isInterface();
                    if (!isJavaInterface || !(value instanceof Invokeable) || (iface = (Class)oracle.bpm.lang.Cast.force(new ClassConst(newType, op).run(rm, false))) == null) break;
                    Invokeable invokeable = (Invokeable)value;
                    value = invokeable.asInterface(iface);
                    break;
                }
            }
            return value;
        }

        @Override
        Node checkType() throws TypeException {
            Node result = this;
            Node operand = this.getOp1();
            if (operand.isConstant() && operand instanceof Const && !this.isGeneratingSource() && (operand = ((Const)operand).convertTo(this.newType)) != null) {
                result = operand;
            }
            this.setTypeDescription(this.newType);
            return result;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return Wide.run(rm, this.getOp1(), this.newType);
        }
    }

    static class UnBox
    extends Conversion {
        private UnBox(Node operand, TypeDescription targetType) {
            super(operand, targetType);
        }

        public static Node create(Node operand) {
            TypeDescription td = operand.getTypeDescription();
            return td.isPrimitive() ? operand : new UnBox(operand, td.primitiveEquivalent(true));
        }

        public static Node create(Node operand, TypeDescription targetType) {
            return new UnBox(operand, targetType);
        }

        @Override
        Node checkType() throws TypeException {
            Node op = this.getOp1().checkType();
            if (op instanceof Box) {
                return op.getFirst().checkType();
            }
            if (op.getTypeDescription().isPrimitive()) {
                return op;
            }
            return super.checkType();
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return super.run(rm);
        }
    }

    static class Type
    extends Conversion {
        Type(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        @Override
        Node checkType() throws TypeException {
            Node result;
            if (this.getKind() == -1) {
                result = super.checkType();
                if (result == this) {
                    throw new ConversionException(this.getOperand(), this.oldType, this.newType);
                }
            } else {
                result = this;
            }
            return result;
        }
    }

    static class ToGMT
    extends Conversion {
        public ToGMT(Node operand) {
            super(operand, TypeFactory.getTime());
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Time time = (Time)this.getOp1().value(rm);
            return time != null ? time.toGMT() : null;
        }
    }

    static class ToEnum
    extends Conversion {
        private ToEnum(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        public static Node create(Node operand, TypeDescription toType) {
            TypeDescription ot = operand.getTypeDescription();
            Node result = ot.equals(toType) ? operand : (toType.primitiveEquivalent(true).equals(ot) ? Box.create(operand) : (toType.primitiveEquivalent(false).equals(ot) ? UnBox.create(operand) : new ToEnum(operand, toType)));
            return result;
        }

        @Override
        Node checkType() throws TypeException {
            this.basicCheck();
            this.toEnum();
            return this;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }

    static class ToArray
    extends Conversion {
        private ClassConst targetClass;

        private ToArray(Node operand, TypeDescription toType) {
            super(operand, toType);
            if (!toType.isMap() && !toType.isPrimitive()) {
                this.targetClass = new ClassConst(this.newType, (Node)this);
            }
        }

        public static Node create(Node operand, TypeDescription toType) {
            TypeDescription ot = operand.getTypeDescription();
            if (ot.getJavaType().equals(toType.getJavaType())) {
                TypeDescription elementOldType = ot.getElementType();
                TypeDescription elementNewType = toType.getElementType();
                if (elementOldType != null && elementOldType.getJavaType().equals(elementNewType.getJavaType())) {
                    if (!elementNewType.isDecimal()) {
                        return operand;
                    }
                    if (elementNewType.getScale() < 0 || elementNewType.getScale() == elementOldType.getScale()) {
                        return operand;
                    }
                }
            }
            return new ToArray(operand, toType);
        }

        @Override
        void collectConstants(ConstantPool cp) {
            if (this.targetClass != null) {
                this.targetClass.collectConstants(cp);
            }
            super.collectConstants(cp);
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        ClassConst getTargetClass() {
            return this.targetClass;
        }
    }

    static class TimeInterval
    extends Conversion {
        private String sourceJavaType;

        public TimeInterval(Node operand, String javaType, TypeDescription toType) {
            super(operand, toType);
            this.sourceJavaType = javaType;
        }

        public static Node create(Node operand, TypeDescription toType) {
            return new TimeInterval(operand, operand.getTypeDescription().getJavaType(), toType);
        }

        public static Node create(Node operand, String javaType, TypeDescription toType) {
            return new TimeInterval(operand, javaType, toType);
        }

        public String getSourceJavaType() {
            return this.sourceJavaType;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }

    static class Stringify
    extends Conversion {
        private String javaType;

        private Stringify(Node operand, TypeDescription toType, String javaType) {
            super(operand, toType.primitiveEquivalent(false));
            this.javaType = javaType;
        }

        public static Node create(Node operand, TypeDescription toType) {
            TypeDescription ot = operand.getTypeDescription();
            String javaType = ot.isNone() ? TypeFactory.getString().getJavaType() : ot.getJavaType();
            return Stringify.create(operand, toType, javaType);
        }

        public static Node create(Node operand, TypeDescription toType, String javaType) {
            return new Stringify(operand, toType, javaType);
        }

        @Override
        public String getJavaType() {
            return this.javaType;
        }

        @Override
        Node checkType() throws TypeException {
            Node result = this;
            Node operand = this.basicCheck();
            if (operand != null) {
                if (operand instanceof Stringify && !this.isGeneratingSource()) {
                    this.javaType = operand.getJavaType();
                    operand = operand.getFirst();
                    this.setOperand(operand);
                }
                if (operand instanceof Const && operand.isConstant()) {
                    Const c = (Const)operand;
                    result = c.convertTo(this.newType);
                } else if (this.oldType.isEnum() && !this.isGeneratingSource()) {
                    result = this.enumToString(operand);
                }
            }
            return result;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return Str.valueOf(this.getOp1().value(rm), this.getTypeDescription().getLength());
        }
    }

    static class Null
    extends Conversion {
        public Null(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        @Override
        Node checkType() throws TypeException {
            this.basicCheck();
            return this;
        }

        int findInvalidValue(JavaEnumTypeDescription enumType) {
            int invalidValue = -1;
            if (enumType.isSequential()) {
                int[] values = enumType.getValues();
                invalidValue = values == null ? 0 : values[0];
            }
            return invalidValue;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        boolean isConstant() {
            return true;
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Serializable result = null;
            TypeDescription newType = this.getTypeDescription();
            if (newType.isPrimitive() && newType.isNumber()) {
                result = newType.isInt() ? (Number)IntConst.createValue(0L, newType) : (Number)RealConst.createValue(0.0, newType);
            } else if (newType.isEnum()) {
                if (!newType.isPrimitive()) {
                    result = null;
                } else {
                    JavaEnumTypeDescription enumType = (JavaEnumTypeDescription)newType;
                    result = Long.valueOf(this.findInvalidValue(enumType));
                }
            } else if (newType == TypeFactory.getPrimitiveBool()) {
                result = Boolean.FALSE;
            } else if (newType.isString() && newType.isPrimitive()) {
                result = Character.valueOf('\u0000');
            }
            return result;
        }
    }

    static class Narrow
    extends Conversion {
        private Narrow(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        public static Node create(Node operand, TypeDescription toType) {
            return new Narrow(operand, toType);
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }

    static class IntReal
    extends Conversion {
        public IntReal(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }

    static class Import
    extends Conversion {
        private String sourceJavaType;

        private Import(Node operand, String javaType, TypeDescription targetType) {
            super(operand, javaType, targetType);
            this.sourceJavaType = javaType;
        }

        public static Node create(Node operand, String jType, TypeDescription targetType) throws TypeException {
            Node result;
            boolean primitive;
            TypeDescription td = operand.getTypeDescription();
            if (td instanceof MethodTypeDescription) {
                td = ((MethodTypeDescription)td).getResultType();
            }
            String string = jType = (primitive = td.isPrimitive()) ? TDKit.toPrimitiveType((String)jType) : TDKit.toNonPrimitiveType((String)jType);
            if (Import.isAssignable(targetType, jType, true)) {
                result = operand;
            } else if (targetType.isString()) {
                result = Stringify.create(operand, targetType, jType);
            } else if (td.isStrictSubtype(targetType) && td.isPrimitive() && targetType.isPrimitive() && targetType.isPredefined()) {
                result = new Wide(operand, targetType);
            } else {
                if (Blob.isBlob(jType) && targetType.isBinary()) {
                    return new Binary(operand);
                }
                if (td.isTime()) {
                    return TimeInterval.create(operand, jType, targetType);
                }
                result = !TDKit.isArray((String)jType) && targetType.primitiveEquivalent(primitive).getJavaType().equals(jType) ? (primitive ? (td.isPrimitive() ? Box.create(operand).checkType() : operand) : (td.isPrimitive() ? operand : UnBox.create(operand, td.primitiveEquivalent(true)).checkType())) : new Import(operand, jType, targetType);
            }
            return result;
        }

        public String getSourceJavaType() {
            return this.sourceJavaType;
        }

        @Override
        Node checkType() throws TypeException {
            Conversion c;
            Node operand = this.getFirst();
            this.oldType = operand.getTypeDescription();
            if (this.oldType.isPrimitive()) {
                this.sourceJavaType = TDKit.toPrimitiveType((String)this.sourceJavaType);
                if (this.newType.primitiveEquivalent(true).getJavaType().equals(this.sourceJavaType)) {
                    return (operand.getTypeDescription().isPrimitive() ? Box.create(operand).checkType() : operand).checkType();
                }
            } else {
                this.sourceJavaType = TDKit.toNonPrimitiveType((String)this.sourceJavaType);
                if (this.newType.primitiveEquivalent(false).getJavaType().equals(this.sourceJavaType)) {
                    TypeDescription td = operand.getTypeDescription();
                    return (td.isPrimitive() ? operand : UnBox.create(operand, td.primitiveEquivalent(true)).checkType()).checkType();
                }
            }
            if (this.sourceJavaType.equals(this.newType.getJavaType())) {
                return operand;
            }
            if (this.newType.getKind() == 12) {
                this.setTargetElementClass(new ClassConst(this.newType.getElementType(), (Node)this));
            }
            Conversion conversion = c = operand instanceof Conversion ? (Conversion)operand : null;
            if (c != null && (c instanceof Import || c instanceof Export)) {
                operand = c.getFirst();
                this.setFirst(operand);
            }
            this.setTypeDescription(this.newType);
            return this;
        }

        @Override
        Node externalNode() {
            return this.getOperand();
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            if (TDKit.isArray((String)this.sourceJavaType)) {
                Object result = this.getFirst().value(rm);
                if (result == null) {
                    return this.checkResult(result);
                }
                Class c = (Class)oracle.bpm.lang.Cast.force(this.getTargetElementClass().value(rm));
                return ArrayUtils.convertElements(result, c);
            }
            return super.run(rm);
        }
    }

    static class Identity
    extends Conversion {
        Identity(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        @Override
        Node checkType() throws TypeException {
            this.basicCheck();
            return this;
        }

        @Override
        void generate(CodeGenerator cg) {
            this.getOp1().generate(cg);
        }
    }

    static class FromGMT
    extends Conversion {
        public FromGMT(Node operand) {
            super(operand, TypeFactory.getTime());
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Time time = (Time)this.getOp1().value(rm);
            return time != null ? time.fromGMT() : null;
        }
    }

    static class Export
    extends Conversion {
        private String targetJavaType;

        private Export(Node operand, String javaType, TypeDescription toType) {
            super(operand, javaType, toType);
            this.targetJavaType = javaType;
        }

        public static Node create(Node operand, String javaType, TypeDescription toType) throws TypeException {
            Node result;
            TypeDescription oldType = operand.getTypeDescription();
            boolean primitive = toType.isPrimitive();
            String string = javaType = primitive ? TDKit.toPrimitiveType((String)javaType) : TDKit.toNonPrimitiveType((String)javaType);
            if (operand.getJavaType().equals(javaType)) {
                result = operand;
            } else if (Export.isAssignable(oldType, javaType, false)) {
                result = operand;
            } else if (Char.isChar(javaType)) {
                result = Char.create(operand, toType);
            } else if (Blob.isBlob(javaType)) {
                result = Blob.create(operand, toType);
            } else if (oldType.primitiveEquivalent(primitive).getJavaType().equals(javaType)) {
                TypeDescription td = operand.getTypeDescription();
                result = primitive ? (td.isPrimitive() ? operand : UnBox.create(operand, td.primitiveEquivalent(true)).checkType()) : (operand.getTypeDescription().isPrimitive() ? Box.create(operand).checkType() : operand);
            } else {
                TypeDescription t = TypeMappings.getType(javaType);
                result = t == null || t.equals(toType) ? new Export(operand, javaType, toType) : Conversion.promote(operand, t);
            }
            return result;
        }

        public String getTargetJavaType() {
            return this.targetJavaType;
        }

        public boolean isArray() {
            int index = this.targetJavaType.lastIndexOf("[");
            return index != -1 && !this.targetJavaType.substring(0, index).trim().equals("byte");
        }

        @Override
        Node checkType() throws TypeException {
            Node operand = this.basicCheck();
            if (operand != null) {
                Conversion c;
                this.oldType = operand.getTypeDescription();
                String string = this.targetJavaType = this.newType.isPrimitive() ? TDKit.toPrimitiveType((String)this.targetJavaType) : TDKit.toNonPrimitiveType((String)this.targetJavaType);
                if (this.isArray()) {
                    this.setTargetElementClass(new ClassConst(TDKit.getElementType((String)this.targetJavaType), (Node)this));
                }
                Conversion conversion = c = operand instanceof Conversion ? (Conversion)operand : null;
                if (c != null && (c instanceof Import || c instanceof Export)) {
                    operand = c.getFirst();
                    this.setFirst(operand);
                }
            }
            return this;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Object result = this.getFirst().value(rm);
            if (result != null) {
                if (this.isArray()) {
                    Class c = (Class)oracle.bpm.lang.Cast.force(this.getTargetElementClass().value(rm));
                    result = ArrayUtils.convertElements(result, c);
                } else {
                    Method conversor = oracle.bpm.util.Conversion.getMethod(result.getClass(), this.targetJavaType);
                    if (conversor != null) {
                        try {
                            result = conversor.invoke(null, result);
                        }
                        catch (Exception e) {
                            throw new CompilerExceptionShell((Node)this, (Throwable)e);
                        }
                    }
                }
            }
            return this.checkResult(result);
        }
    }

    static class DynamicView
    extends Conversion {
        public DynamicView(Node operand) {
            super(operand, DynamicTypeDescription.INSTANCE);
            this.setSyntheticCast(true);
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Object value = this.getOp1().value(rm);
            return Display.getContentToShow(value);
        }
    }

    static class Dynamic
    extends Conversion {
        private ClassConst targetClass;

        public Dynamic(Node operand, TypeDescription toType) {
            super(operand, toType);
            TypeDescription ot;
            if (!(this.toDynamic() || (ot = operand.getTypeDescription()).isPredefined() && !ot.isAny())) {
                this.targetClass = new ClassConst(toType, (Node)this);
            }
        }

        public ClassConst getTargetClass() {
            return this.targetClass;
        }

        public boolean toDynamic() {
            return this.getTypeDescription().getKind() == 15;
        }

        @Override
        void collectConstants(ConstantPool cp) {
            super.collectConstants(cp);
            if (this.targetClass != null) {
                this.targetClass.collectConstants(cp);
            }
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Object value = this.getOp1().value(rm);
            if (this.toDynamic()) {
                value = DynamicObject.valueOf(value);
            } else {
                DynamicObject dobj = (DynamicObject)value;
                value = dobj.convertTo(this.getTypeDescription().getJavaClass());
            }
            return value;
        }
    }

    static class Deserialize
    extends Conversion {
        public Deserialize(Node operand, TypeDescription toType) {
            super(operand, toType);
            this.setSyntheticCast(false);
        }

        @Override
        Node checkType() throws TypeException {
            this.basicCheck();
            return this;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }

    static class Decimal
    extends Conversion {
        private Decimal(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        public static Node create(Node operand, TypeDescription toType) {
            TypeDescription from = operand.getTypeDescription();
            Node result = from.isDecimal() && (toType.getScale() < 0 || toType.getScale() == from.getScale()) && Decimal.getDecimalDigits(toType) >= Decimal.getDecimalDigits(from) ? operand : new Decimal(operand, toType);
            return result;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        private static int getDecimalDigits(TypeDescription decimalType) {
            assert (decimalType.isDecimal());
            int len = decimalType.getLength();
            int scale = decimalType.getScale();
            return len < 0 ? Integer.MAX_VALUE : (scale < 0 ? len : len - scale);
        }
    }

    static class Char
    extends Conversion {
        private Char(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        public static Node create(Node operand, TypeDescription toType) {
            return Char.isChar(operand.getJavaType()) ? operand : new Char(operand, toType);
        }

        static boolean isChar(String javaType) {
            return javaType.equals(Character.class.getName()) || javaType.equals(Character.TYPE.getName());
        }

        @Override
        Node checkType() throws TypeException {
            Node nested;
            Node operand = this.basicCheck();
            if (operand != null && operand instanceof Stringify && (nested = operand.getOp1()).getTypeDescription().isString()) {
                this.setOperand(nested);
            }
            return this;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return oracle.bpm.lang.Char.valueOf((String)this.getOp1().value(rm));
        }
    }

    static class Cast
    extends Conversion {
        private Cast(Node operand, TypeDescription toType) {
            super(operand, toType);
            this.setSyntheticCast(false);
        }

        public static Node create(Node operand, TypeDescription toType) {
            boolean op;
            boolean tp;
            TypeDescription oldType = operand.getTypeDescription();
            Node result = toType.isAssignableFrom(oldType) ? ((tp = toType.isPrimitive()) == (op = oldType.isPrimitive()) ? operand : (tp ? UnBox.create(operand) : Box.create(operand))) : (oldType.isBinary() ? new Deserialize(operand, toType) : new Cast(operand, toType));
            return result;
        }

        @Override
        public void generate(SourceGenerator cg) {
            cg.generate(this, this.getFirst());
        }

        @Override
        protected boolean isCast() {
            return true;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            TypeDescription targetType = this.getTypeDescription();
            Object result = super.run(rm);
            if (result instanceof Symbol) {
                result = ((Symbol)result).getValue();
            }
            if (targetType.isAny()) {
                return result;
            }
            if (result != null && !Is.run(targetType, result)) {
                throw new ClassCastException("Invalid cast from '" + result.toString() + "' to '" + targetType + "'");
            }
            return result;
        }
    }

    static class Box
    extends Conversion {
        private Box(Node operand) {
            super(operand, operand.getTypeDescription().primitiveEquivalent(false));
        }

        private Box(Node operand, TypeDescription type) {
            super(operand, type.primitiveEquivalent(false));
        }

        static Node create(Node operand) {
            return operand.getTypeDescription().isPrimitive() ? new Box(operand) : operand;
        }

        static Node create(Node operand, TypeDescription type) {
            return type.isPrimitive() ? new Box(operand, type) : operand;
        }

        @Override
        Node checkType() throws TypeException {
            Node op = this.basicCheck();
            if (op != null) {
                if (op instanceof UnBox && op.getFirst().getTypeDescription().equivalent(this.newType)) {
                    return op.getFirst();
                }
                if (!op.getTypeDescription().isPrimitive()) {
                    return op;
                }
                if (op instanceof Const) {
                    Const c = (Const)op;
                    return c.convertTo(this.newType);
                }
            }
            return this;
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return this.getFirst().run(rm);
        }
    }

    static class Bool
    extends Conversion {
        public Bool(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }

    static class Blob
    extends Conversion {
        private Blob(Node operand, TypeDescription toType) {
            super(operand, toType);
        }

        public static Node create(Node operand, TypeDescription toType) {
            Node result = Blob.isBlob(operand.getJavaType()) ? operand : new Blob(operand, toType);
            return result;
        }

        public static boolean isBlob(String javaType) {
            return javaType.equals(java.sql.Blob.class.getName());
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return BlobImpl.valueOf((byte[])this.getFirst().value(rm, byte[].class));
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }

    static class Binary
    extends Conversion {
        public Binary(Node operand) {
            super(operand, TypeFactory.getBinary());
        }

        @Override
        void generate(CodeGenerator cg) {
            cg.getConversionGenerator().generate(this);
        }
    }
}

