/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Const;
import oracle.bpm.lang.TypeDescription;

class ConstantPool {
    private int nextId;
    private List<Const> orderedList;
    private Map<String, Const> pool = CollectionPool.getHashMap();

    ConstantPool() {
        this.orderedList = CollectionPool.getLinkedList();
    }

    Const[] getConstants() {
        return this.orderedList.toArray(new Const[this.orderedList.size()]);
    }

    synchronized void add(Const constant) {
        String fieldName;
        String syntheticName = constant.getSyntheticName();
        TypeDescription constantTD = constant.getTypeDescription();
        String key = syntheticName != null ? syntheticName : ((Object)constantTD).toString() + constant.getText();
        Const prev = this.pool.get(key);
        if (prev != null) {
            fieldName = prev.getConstantFieldName();
            if (constantTD.isMap() && constantTD.isOrdered()) {
                prev.setTypeDescription(constantTD);
            } else {
                constant.setTypeDescription(prev.getTypeDescription());
            }
        } else {
            this.pool.put(key, constant);
            this.orderedList.add(constant);
            fieldName = syntheticName != null ? syntheticName : "$const" + this.nextId++;
        }
        constant.setConstantFieldName(fieldName);
    }

    void release() {
        CollectionPool.releaseHashMap(this.pool);
        CollectionPool.releaseLinkedList(this.orderedList);
    }
}

