/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.MappedArrayReference;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceTemplate;
import oracle.bpm.compiler.TemplateFactory;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;

public abstract class CompletionSuggestion
implements Comparable {
    boolean needsQualification;
    private String completionId;
    private String id;
    private int pasteLength;
    private int pasteOffset;
    private TypeRef type;
    public static final CompletionSuggestion[] ARRAY = new CompletionSuggestion[0];

    private CompletionSuggestion(Completion completion, String id, TypeRef type) {
        this.setPasteOffset(completion.getOffset());
        this.setPasteLength(completion.getLength());
        this.completionId = completion.getText();
        this.type = type;
        this.id = id;
    }

    public static CompletionSuggestion argument(Completion completion, Argument arg) {
        return new ArgumentCompletionSuggestion(completion, arg);
    }

    public static CompletionSuggestion enumeration(Completion completion, MethodTypeDescription member) {
        return new EnumCompletionSuggestion(completion, member);
    }

    public static CompletionSuggestion equals(Completion completion, Node object) {
        return new EqualsCompletionSuggestion(completion, object);
    }

    public static CompletionSuggestion id(Completion completion, String name) {
        return new IdCompletionSuggestion(completion, name, null);
    }

    public static CompletionSuggestion id(Completion completion, MethodTypeDescription member) {
        return new IdCompletionSuggestion(completion, member.getName(), member);
    }

    public static CompletionSuggestion local(Completion completion, String name, TypeDescription type) {
        return new LocalCompletionSuggestion(completion, name, type);
    }

    public static CompletionSuggestion statement(Completion completion, String id, Node tree) {
        return new StatementCompletionSuggestion(completion, id, tree);
    }

    public static CompletionSuggestion template(Completion completion, SourceTemplate template) {
        return new TemplateCompletionSuggestion(completion, template);
    }

    public static CompletionSuggestion token(Completion completion, String name) {
        return new TokenCompletionSuggestion(completion, name);
    }

    public static CompletionSuggestion type(Completion completion, TypeRef type, Node partialType) {
        return new TypeCompletionSuggestion(completion, type, partialType);
    }

    public String getCompletionId() {
        return this.completionId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setPasteLength(int pasteLength) {
        this.pasteLength = pasteLength;
    }

    public int getPasteLength() {
        return this.pasteLength;
    }

    public void setPasteOffset(int pasteOffset) {
        assert (pasteOffset >= 0) : "Invalid paste offset: " + pasteOffset;
        this.pasteOffset = pasteOffset;
    }

    public int getPasteOffset() {
        return this.pasteOffset;
    }

    public String getText() {
        StringBuilder result = new StringBuilder();
        if (this.id != null) {
            result.append(this.id);
            if (this.type != null) {
                result.append(" : ");
            }
        }
        if (this.type != null) {
            if (this.type instanceof AttributeTypeDescription) {
                result.append(((AttributeTypeDescription)this.type).getResultType().getText());
            } else {
                result.append(this.type.getText());
            }
        }
        return result.toString();
    }

    public void setType(TypeRef type) {
        this.type = type;
    }

    public TypeDescription getType() {
        return this.type != null ? this.type.get() : null;
    }

    public TypeRef getTypeRef() {
        return this.type;
    }

    public int compareTo(Object o) {
        return this.compareTo(o, true);
    }

    public int compareTo(Object o, boolean caseSensitive) {
        CompletionSuggestion other = (CompletionSuggestion)o;
        String currentId = this.id != null ? this.id : "";
        String otherId = other.id != null ? other.id : "";
        String currentTypeText = this.getTypeText();
        String otherTypeText = other.getTypeText();
        String a = currentId + currentTypeText;
        String b = otherId + otherTypeText;
        return caseSensitive ? a.compareTo(b) : a.compareToIgnoreCase(b);
    }

    public SourceTemplate createTemplate() {
        TypeDescription typeDescription = this.getType();
        String txt = this.needsQualification && typeDescription != null && (!typeDescription.isPredefined() || typeDescription.getParent() != null) ? typeDescription.getQualifiedName() : this.getId();
        return new SourceTemplate(new Identifier(txt));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CompletionSuggestion) {
            CompletionSuggestion completionSuggestion = (CompletionSuggestion)obj;
            return this.id.equals(completionSuggestion.id) && Any.equals(this.getTypeText(), completionSuggestion.getTypeText());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getText();
    }

    public void setNeedsQualification(boolean value) {
        this.needsQualification = value;
    }

    public boolean isNeedsQualification() {
        return this.needsQualification;
    }

    static CompletionSuggestion member(Completion completion, MethodTypeDescription member, Node object) {
        if (object instanceof MappedArrayReference) {
            return new MappedArrayCompletionSuggestion(completion, member, object);
        }
        return new MemberCompletionSuggestion(completion, member, object);
    }

    private String getTypeText() {
        return this.type != null ? this.type.getText() : "";
    }

    static class TypeCompletionSuggestion
    extends CompletionSuggestion {
        public TypeCompletionSuggestion(Completion completion, TypeRef type, Node partialType) {
            super(completion, type.getName(), type);
            this.setType(type);
            if (partialType != null) {
                int treeOffset = partialType.getTreeOffset();
                this.setPasteOffset(treeOffset);
                this.setPasteLength(completion.getOffset() - treeOffset + completion.getLength());
            }
        }

        @Override
        public SourceTemplate createTemplate() {
            return new SourceTemplate(new TypeSpec(this.getType(), (Token)null));
        }
    }

    static class TokenCompletionSuggestion
    extends CompletionSuggestion {
        public TokenCompletionSuggestion(Completion completion, String token) {
            super(completion, token, null);
        }

        @Override
        public SourceTemplate createTemplate() {
            return new SourceTemplate(new Identifier.TokenText(this.getId()));
        }
    }

    static class TemplateCompletionSuggestion
    extends CompletionSuggestion {
        private SourceTemplate template;

        public TemplateCompletionSuggestion(Completion completion, SourceTemplate template) {
            super(completion, template.getId(), null);
            this.template = template;
        }

        @Override
        public SourceTemplate createTemplate() {
            return this.template;
        }
    }

    static class StatementCompletionSuggestion
    extends CompletionSuggestion {
        private Node tree;

        public StatementCompletionSuggestion(Completion completion, String id, Node tree) {
            super(completion, id, null);
            this.tree = tree;
        }

        @Override
        public SourceTemplate createTemplate() {
            return new SourceTemplate(this.tree);
        }
    }

    static class MemberCompletionSuggestion
    extends CompletionSuggestion {
        protected Completion completion;
        protected Node object;

        public MemberCompletionSuggestion(Completion completion, MethodTypeDescription member, Node object) {
            super(completion, member.getName(), member);
            this.needsQualification = true;
            this.completion = completion;
            if (object != null) {
                this.object = object;
                int treeOffset = object.getTreeOffset();
                assert (treeOffset >= 0) : "Invalid offset for tree: " + object.dump();
                this.setPasteOffset(treeOffset);
                this.setPasteLength(completion.getOffset() - treeOffset + completion.getLength());
            }
            if (member.isAttribute()) {
                this.needsQualification = this.needsQualification(completion, member);
            }
        }

        @Override
        public SourceTemplate createTemplate() {
            if (this.needsQualification) {
                return TemplateFactory.createTemplate(this.getType().asMethod(), this.object, this.completion, true);
            }
            return super.createTemplate();
        }

        private boolean needsQualification(Completion completion, MethodTypeDescription member) {
            AttributeTypeDescription attributeTypeDescription;
            boolean result = true;
            ObjectTypeDescription currentType = completion.getCurrentClass().getObjectType();
            String name = member.getName();
            if (this.object == null && (attributeTypeDescription = currentType.findAttribute(name)) == member) {
                result = false;
            }
            return result;
        }
    }

    static class MappedArrayCompletionSuggestion
    extends MemberCompletionSuggestion {
        public MappedArrayCompletionSuggestion(Completion completion, MethodTypeDescription member, Node object) {
            super(completion, member, object);
        }

        @Override
        public SourceTemplate createTemplate() {
            return TemplateFactory.createMappedArray(this.getType().asMethod(), this.object, this.completion);
        }
    }

    static class LocalCompletionSuggestion
    extends CompletionSuggestion {
        public LocalCompletionSuggestion(Completion completion, String name, TypeDescription type) {
            super(completion, name, type);
        }
    }

    static class IdCompletionSuggestion
    extends CompletionSuggestion {
        public IdCompletionSuggestion(Completion completion, String name, MethodTypeDescription mtd) {
            super(completion, name, mtd);
        }
    }

    static class EqualsCompletionSuggestion
    extends CompletionSuggestion {
        protected Node object;

        public EqualsCompletionSuggestion(Completion completion, Node object) {
            super(completion, "equals", null);
            this.object = object;
            int treeOffset = object.getTreeOffset();
            assert (treeOffset >= 0) : "Invalid offset for tree: " + object.dump();
            this.setPasteOffset(treeOffset);
            this.setPasteLength(completion.getOffset() - treeOffset + completion.getLength());
        }

        @Override
        public SourceTemplate createTemplate() {
            SourceTemplate template = TemplateFactory.createEqualsTemplate(this.object);
            return template;
        }
    }

    static class EnumCompletionSuggestion
    extends CompletionSuggestion {
        public EnumCompletionSuggestion(Completion completion, MethodTypeDescription label) {
            super(completion, label.getName(), null);
        }
    }

    static class ArgumentCompletionSuggestion
    extends CompletionSuggestion {
        public ArgumentCompletionSuggestion(Completion completion, Argument arg) {
            super(completion, arg.getName(), arg.getType());
        }
    }
}

