/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.Arrays;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.WarningExceptionInterface;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.FixOption;
import oracle.bpm.util.Fixable;
import org.jetbrains.annotations.Nullable;

public class CompilerException
extends CilException
implements WarningExceptionInterface,
Fixable {
    protected Node node;
    @Nullable
    protected SourceCode sourceCode;
    private int column = -1;
    private FixOption[] fixOptions;
    private int length = 1;
    private int line = -1;
    private TypeDescription member;
    private int memberPart = 0;
    private String memberPartName;
    private int offset;
    private boolean reported;
    private boolean warning;
    public static final int NONE = 0;
    public static final int TRANSFORMATION_PRECODE = 1;
    public static final int TRANSFORMATION_POSTCODE = 2;
    public static final int TRANSFORMATION_MAPPING = 3;
    public static final int MEMBER_REQUIRE = 4;
    public static final int MEMBER_ENSURE = 5;
    public static final int MEMBER_CHECK = 6;
    public static final int ATTRIBUTE_SETTER = 7;
    public static final int ATTRIBUTE_GETTER = 8;
    static final long serialVersionUID = 149768032983185026L;
    static final long serialCheck = -6987753834417524566L;

    public CompilerException(Node node) {
        this(node, null);
    }

    public CompilerException(Node node, Msg key) {
        this.setNode(node);
        if (key != null) {
            this.setKey(key);
        }
    }

    @Override
    public void setColumn(int col) {
        this.column = col;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public FixOption[] getFixOptions() {
        return this.fixOptions;
    }

    @Override
    public boolean isFixable() {
        return this.fixOptions != null;
    }

    @Override
    public boolean isInternal() {
        return this instanceof InternalException;
    }

    @Override
    public Msg getKey() {
        return super.getKey();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void setMember(TypeDescription member) {
        this.member = member;
    }

    @Override
    public TypeDescription getMember() {
        return this.member;
    }

    @Override
    public String getMemberName() {
        String name = "";
        if (this.member != null) {
            name = this.member.isConstructor() ? "<constructor>" : this.member.getName();
        }
        return name;
    }

    @Override
    public void setMemberPart(int memberPart) {
        this.memberPart = memberPart;
    }

    @Override
    public void setMemberPartName(String memberPartName) {
        this.memberPartName = memberPartName;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setReported(boolean reported) {
        this.reported = reported;
    }

    @Override
    public boolean isReported() {
        return this.reported;
    }

    @Override
    public final void fix() throws Exception {
        this.fixOptions[0].fix();
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getMemberPart() {
        return this.memberPart;
    }

    @Override
    public String getMemberPartName() {
        return this.memberPartName;
    }

    @Override
    public void setSourceCode(SourceCode sourceCode) {
        this.sourceCode = sourceCode == null ? null : sourceCode.copy();
    }

    @Override
    @Nullable
    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    @Override
    public boolean isSyntactic() {
        return false;
    }

    @Override
    public void setWarning(boolean warning) {
        this.warning = warning;
    }

    @Override
    public boolean isWarning() {
        return this.warning;
    }

    @Override
    public String toString() {
        String line1 = super.toString();
        String sourceLine = this.getSourceLine();
        if (sourceLine == null) {
            return line1;
        }
        String prompt = "\tError (" + this.line + ',' + this.column + "): ";
        String line2 = prompt + sourceLine;
        String line3 = this.makeMarkerLine(prompt.length(), line2);
        return line1 + '\n' + line2 + '\n' + line3;
    }

    protected static String text(TypeDescription type, TypeRenderer renderer, int renderFlags) {
        String text;
        renderFlags |= 8;
        switch (type.getKind()) {
            case 12: {
                TypeDescription elementType = type.getElementType();
                String elementText = CompilerException.text(elementType, renderer, renderFlags);
                if (elementType.isArray()) {
                    elementText = "(" + elementText + ")";
                }
                text = CompilerMsg.ARRAY_OF(elementText).getString();
                break;
            }
            case 13: {
                TypeDescription elementType = type.getElementType();
                String elementText = CompilerException.text(elementType, renderer, renderFlags);
                if (elementType.isArray()) {
                    elementText = "(" + elementText + ")";
                }
                TypeDescription indexType = type.getIndexType();
                String indexText = CompilerException.text(indexType, renderer, renderFlags);
                if (indexType.isArray()) {
                    indexText = "(" + indexText + ")";
                }
                text = CompilerMsg.ASSOC_ARRAY(indexText, elementText).getString();
                break;
            }
            default: {
                text = renderer != null ? renderer.render((TypeRef)type, renderFlags) : type.getText();
            }
        }
        return text;
    }

    protected static String text(TypeDescription type, Node node) {
        return CompilerException.text(type, node, 16);
    }

    protected static String text(TypeDescription type, Node node, int renderFlags) {
        LanguageSpec currentLanguage = node.getCurrentLanguage();
        TypeRenderer typeRenderer = currentLanguage != null ? currentLanguage.getTypeRenderer() : null;
        return CompilerException.text(type, typeRenderer, renderFlags);
    }

    @Override
    protected void setFixOptions(FixOption[] fixOptions) {
        this.fixOptions = fixOptions;
    }

    protected void addFixOption(FixOption fixOption) {
        if (this.fixOptions == null) {
            this.fixOptions = new FixOption[]{fixOption};
        } else {
            int length = this.fixOptions.length;
            this.fixOptions = Arrays.copyOf(this.fixOptions, length + 1);
            this.fixOptions[length] = fixOption;
        }
    }

    void setNode(Node node) {
        this.node = node;
        if (node != null) {
            try {
                Method method = node.findCurrentMember();
                if (method != null) {
                    MethodTypeDescription methodType = method.getMethodType();
                    this.setSourceCode(methodType.getCode());
                    this.member = methodType;
                }
            }
            catch (Exception unexpected) {
                unexpected.printStackTrace();
            }
            while (this.line <= 0 && node != null) {
                this.line = node.getLine();
                this.column = node.getColumn();
                this.length = node.getLength();
                this.offset = node.getOffset();
                node = node.getParent();
            }
            if (this.length < 1) {
                this.length = 1;
            }
        }
    }

    Node getNode() {
        return this.node;
    }

    private String makeMarkerLine(int promptSize, String errorLine) {
        int errPos = this.column + promptSize - 1;
        int errEnd = errPos + this.length - 1;
        int size = errEnd + 1;
        int length = errorLine.length();
        if (size > length) {
            size = errPos + 1;
        }
        if (size > length) {
            size = 0;
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            char c = errorLine.charAt(i);
            if (i == errPos || i == errEnd) {
                sb.append('^');
            } else if (c != '\t') {
                sb.append((char)(i > errPos && i < errEnd ? 94 : 32));
            }
            if (c != '\t') continue;
            sb.append('\t');
        }
        return sb.toString();
    }

    @Nullable
    private String getSourceLine() {
        char c;
        int lineEnd;
        int errorPos;
        char c2;
        int lineBegin;
        int offset = this.offset;
        if (offset < 0) {
            return null;
        }
        SourceCode code = this.sourceCode;
        if (code == null) {
            return null;
        }
        char[] text = code.getText();
        int textBegin = code.getOffset();
        int textEnd = textBegin + code.getLength();
        for (lineBegin = errorPos = textBegin + offset; lineBegin > textBegin && (c2 = text[lineBegin - 1]) != '\n' && c2 != '\r'; --lineBegin) {
        }
        for (lineEnd = errorPos; lineEnd < textEnd && (c = text[lineEnd]) != '\n' && c != '\r'; ++lineEnd) {
        }
        return new String(text, lineBegin, lineEnd - lineBegin);
    }
}

