/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public class BoolConst
extends Const {
    boolean value;

    public BoolConst(Token t) {
        this(t, false);
    }

    public BoolConst(boolean value) {
        this((Token)null, value);
    }

    BoolConst(String txt) {
        this(txt, true);
    }

    BoolConst(Token t, boolean value) {
        this(t, value, true);
    }

    BoolConst(String txt, boolean primitive) {
        this(null, Boolean.parseBoolean(txt), primitive);
    }

    BoolConst(Token t, boolean value, boolean primitive) {
        super(t, primitive ? TypeFactory.getPrimitiveBool() : TypeFactory.getBool());
        this.setPrimitive(primitive);
        this.value = value;
        this.setParametric(false);
    }

    @Override
    public Object getPrimitiveValue() {
        return this.isPrimitive() ? Boolean.valueOf(this.value) : null;
    }

    @Override
    public String getText() {
        return String.valueOf(this.value);
    }

    @Override
    public final Node negate() {
        this.value = !this.value;
        return this;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        String txt = this.getText();
        return super.toString() + (this.isPrimitive() ? txt : txt.toUpperCase());
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public boolean booleanValue() {
        return this.value;
    }

    @Override
    boolean isCollectable() {
        return false;
    }

    final boolean equals(Node b) {
        return b instanceof BoolConst && this.value == ((BoolConst)b).value;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(24, null, null, this.getText());
    }

    @Override
    void generateSQLCode(StringBuffer query) {
        if (this.isParameter()) {
            query.append(" ? ");
        } else {
            query.append('\'').append(this.value ? 1 : 0).append('\'');
        }
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        return this.value;
    }

    public static class True
    extends BoolConst {
        public True(Token t) {
            super(t, true);
        }
    }
}

