/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

class BitwiseOp
extends Diadic {
    private final int operator;
    static final int AND = 0;
    static final int OR = 1;
    static final int XOR = 2;
    static final int SHIFT_LEFT = 3;
    static final int SHIFT_RIGHT = 4;
    static final int SHIFT_UNSIGNED_RIGHT = 5;
    static final String[] OPNAME = new String[]{"&", "|", "^", "<<", ">>", ">>>"};

    BitwiseOp(Token t, int op) {
        super(t);
        this.operator = op;
    }

    BitwiseOp(Node op1, int op, Node op2) {
        this(null, op);
        this.copyParentFrom(op1);
        if (BitwiseOp.needsParenthesis(op1)) {
            op1.setParenthesis(true);
        }
        if (BitwiseOp.needsParenthesis(op2)) {
            op2.setParenthesis(true);
        }
        this.setFirst(op1);
        op1.setNext(op2);
        op2.setNext(null);
        this.initialize(op1);
    }

    @Override
    public String getText() {
        return OPNAME[this.operator];
    }

    String getOperatorName() {
        return OPNAME[this.operator];
    }

    @Override
    Node checkType() throws TypeException {
        super.checkType();
        this.setTypeDescription(TypeFactory.getPrimitiveInt(32));
        Node o1 = this.getOp1();
        Node o2 = this.getOp2();
        if (o1.getKind() != 2 || o2.getKind() != 2) {
            throw new IncompatibleTypesException(this, o1, o2);
        }
        TypeDescription promotion = o1.getTypeDescription().promote(o2.getTypeDescription());
        promotion = promotion.primitiveEquivalent(true);
        this.setOperands(Conversion.promote(o1, promotion), Conversion.promote(o2, promotion));
        return this;
    }

    @Override
    void generate(CodeGenerator cg) {
        cg.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        long result;
        Number op1 = (Number)this.getOp1().notNullValue(rm);
        Number op2 = (Number)this.getOp2().notNullValue(rm);
        long lop1 = op1.longValue();
        long lop2 = op2.longValue();
        switch (this.operator) {
            case 0: {
                result = lop1 & lop2;
                break;
            }
            case 1: {
                result = lop1 | lop2;
                break;
            }
            case 2: {
                result = lop1 ^ lop2;
                break;
            }
            case 3: {
                result = lop1 << (int)lop2;
                break;
            }
            case 4: {
                result = lop1 >> (int)lop2;
                break;
            }
            case 5: {
                result = lop1 >>> (int)lop2;
                break;
            }
            default: {
                result = 0L;
                assert (false) : "Invalid operator: " + this.operator;
                break;
            }
        }
        int len = this.getOp1().getTypeDescription().getLength();
        if (len < 64) {
            return (int)result;
        }
        return result;
    }

    private static boolean needsParenthesis(Node op) {
        if (op instanceof BitwiseOp) {
            BitwiseOp logic = (BitwiseOp)op;
            return logic.operator != 0;
        }
        return false;
    }
}

