/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Variable;
import oracle.bpm.util.FixOption;

public class AutodeclaredException
extends CompilerException {
    static final long serialVersionUID = -3392324018999997570L;
    static final long serialCheck = 4854466279551068488L;

    public AutodeclaredException(Node node, String name) {
        super(node, CompilerMsg.AUTODECL(name));
    }

    public AutodeclaredException(Node node, Symbol var, MethodTypeDescription method) {
        super(node, CompilerMsg.AUTODECL(var.getName()));
        this.setMember(method);
        TypeDescription type = var.getType();
        if ("Instance".equals(type.getText())) {
            try {
                type = type.getCatalog().find("Fuego.Lib.ProcessInstance").get();
            }
            catch (AmbiguousTypeNameException e) {
                // empty catch block
            }
        }
        this.addFixOption(new AddLocalVar(var.getName(), type));
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
    }

    class AddLocalVar
    extends FixOption {
        String name;
        TypeDescription varType;

        public AddLocalVar(String name, TypeDescription type) {
            super("Declare local variable");
            this.name = name;
            this.varType = type;
            this.setType(AutodeclaredException.this.getMember());
        }

        @Override
        public void fix() throws CompilerException {
            AutodeclaredException.this.getMember().asMethod().addVariable(new Variable(this.name, this.varType));
        }
    }
}

