/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import org.jetbrains.annotations.Nullable;

public final class Arg
extends Node {
    Node init;
    private long argType;
    private Argument argument;
    private int index = -1;
    private Node postInvocationInstruction;

    public Arg(Argument arg, Node node, int index, long argType, boolean synthetic) {
        this(arg, node, argType, synthetic);
        this.index = index;
    }

    Arg(Argument arg, long argType) {
        this(arg, null, argType, false);
    }

    private Arg(Argument arg, Node node, long argType, boolean synthetic) {
        this.setArgument(arg);
        this.setValue(node);
        this.argType = argType;
        this.setSynthetic(synthetic);
        this.setTypeDescription(arg.getType());
    }

    public boolean hasNext() {
        return this.right != null;
    }

    public void runBinding(RunningMonitor rm, List<Object> bindings) throws ExecutionException {
        Argument sourceArg = this.getSourceArgument();
        Argument targetArg = this.getArgument();
        if (sourceArg == null) {
            bindings.add(new Any.Holder<Object>(this.getValue().value(rm)));
        } else if (sourceArg.isArgument()) {
            bindings.add("#" + sourceArg.getNumber());
        } else if (sourceArg.isReturnValue()) {
            bindings.add("#R");
        } else {
            String signature = sourceArg.getType().getSignature();
            Arg sourceArgNode = (Arg)this.getValue();
            if (sourceArgNode.isIndexed()) {
                signature = JavaClass.buildIndexedSignature(signature, sourceArgNode.getIndex());
            }
            bindings.add(signature);
        }
        assert (targetArg.isArgument()) : "targetArg is not an argument";
        bindings.add(targetArg.getName());
    }

    @Override
    public String getText() {
        String name = this.getName();
        return name != null ? name : "";
    }

    public boolean isIn() {
        return (this.argType & 1L) != 0L;
    }

    public boolean isOut() {
        return (this.argType & 2L) != 0L;
    }

    public Node getValue() {
        return this.getFirst();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public Argument getArgument() {
        return this.argument;
    }

    public void setArgument(Argument argument) {
        this.argument = argument;
    }

    boolean isArgument() {
        return this.getArgument().isArgument();
    }

    void setIndex(int index) {
        this.index = index;
    }

    int getIndex() {
        return this.index;
    }

    boolean isIndexed() {
        return this.index > -1;
    }

    @Nullable
    String getName() {
        Argument argument = this.getArgument();
        return argument != null ? argument.getName() : null;
    }

    void setPostInvocationInstruction(Node postInvocationInstruction) {
        this.postInvocationInstruction = postInvocationInstruction;
    }

    Node getPostInvocationInstruction() {
        assert (this.isOut()) : "Should be applied to output arguments only !";
        return this.postInvocationInstruction;
    }

    String getSignature() {
        String signature = this.getArgument().isArgument() ? "#" + this.getArgument().getNumber() : (this.getArgument().isAttribute() ? this.getArgument().getType().getSignature() : null);
        return signature;
    }

    Argument getSourceArgument() {
        Node value = this.getValue();
        return value instanceof Arg ? ((Arg)value).getArgument() : null;
    }

    void setValue(Node value) {
        this.setFirst(value);
    }

    String getWriteSignature(TypeDescription objType) {
        Argument arg = this.getArgument();
        return arg.isArgument() ? "#" + arg.getNumber() : MemberAccess.getWriteSignature(objType, arg.getType().asAttribute());
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node value;
        if (this.init != null) {
            this.init.checkFlow(context);
        }
        if ((value = this.getValue()) != null) {
            value.checkFlow(context);
        }
        context.breaksFlow(false);
        return context;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        Node value = this.getValue();
        if (value != null) {
            value.collectConstants(cp);
        }
        if (this.init != null) {
            this.init.collectConstants(cp);
        }
    }

    @Override
    void generate(CodeGenerator cg) {
        Node value = this.getValue();
        if (value != null) {
            value.gen(cg);
        }
    }

    void init(Node expr) throws TypeException {
        this.init = new Assignment(this.getValue(), expr);
        this.init.initialize(expr);
        this.init = this.init.checkType();
    }

    Object runInitCode(RunningMonitor rm) throws ExecutionException {
        if (this.init != null) {
            return this.init.run(rm);
        }
        return null;
    }

    public static class Type
    extends Node {
        private long argumentType;

        public Type(long argumentType) {
            this.argumentType = argumentType;
        }

        Type(Token t) {
            super(t);
        }

        @Override
        public String getText() {
            return Modifier.getText(this.argumentType);
        }

        @Override
        public Node setNext(Node n) {
            assert (!(n instanceof Type)) : "Attempt to set an Arg.Type as next of a Arg.Type: " + n;
            return super.setNext(n);
        }

        long getArgumentType() {
            return this.argumentType;
        }

        boolean isIn() {
            return (this.argumentType & 1L) != 0L;
        }

        boolean isOut() {
            return (this.argumentType & 2L) != 0L;
        }
    }
}

