/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import fuego.debugger.DebugSession;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteDebugSession
extends DebugSession {
    private final String host;
    private final int port;
    @NonNls
    private static final String JDI_SOCKET_ATTACH = "com.sun.jdi.SocketAttach";
    @NonNls
    private static final String HOSTNAME_ARG = "hostname";
    @NonNls
    private static final String PORT_ARG = "port";

    RemoteDebugSession(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    VirtualMachine doConnect() throws IOException, IllegalConnectorArgumentsException {
        AttachingConnector connector = RemoteDebugSession.findAttachingConnector();
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        Connector.IntegerArgument portArg = (Connector.IntegerArgument)arguments.get(PORT_ARG);
        Connector.Argument hostArg = arguments.get(HOSTNAME_ARG);
        portArg.setValue(this.port);
        hostArg.setValue(this.host);
        return connector.attach(arguments);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static AttachingConnector findAttachingConnector() throws IOException {
        AttachingConnector attachingConnector = RemoteDebugSession.findConnector(JDI_SOCKET_ATTACH, Bootstrap.virtualMachineManager().attachingConnectors());
        if (attachingConnector == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/RemoteDebugSession.findAttachingConnector must not return null");
        }
        return attachingConnector;
    }
}

