/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import fuego.debugger.DebugThread;
import fuego.debugger.IDebugLocalVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.TypeFinder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebugValue {
    @NonNls
    private static final String VALUE_FIELD_NAME = "value";
    private static final DebugValue NULL_VALUE = new DebugValue(){

        public String toString() {
            return "null";
        }

        @Override
        public String getTypeName() {
            return "";
        }

        @Override
        public boolean hasVariables() {
            return false;
        }

        @Override
        @NotNull
        public IDebugLocalVariable[] getVariables() {
            return NO_VARIABLES;
        }
    };
    private static final IDebugLocalVariable[] NO_VARIABLES = new IDebugLocalVariable[0];

    protected DebugValue() {
    }

    public abstract String getTypeName();

    public abstract boolean hasVariables();

    @NotNull
    public abstract IDebugLocalVariable[] getVariables();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static DebugValue create(@NotNull DebugThread debugThread, @Nullable Value value) {
        DebugValue debugValue;
        if (debugThread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugValue.create must not be null");
        }
        if ((value = DebugValue.unwrapHolders(value)) == null) {
            debugValue = NULL_VALUE;
            if (debugValue == null) throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue.create must not return null");
            return debugValue;
        }
        ObjectTypeDescription otd = debugThread.getSession().findCatalogObject(value);
        if (otd != null) {
            debugValue = new OtdMirror(debugThread, otd, value);
            if (debugValue == null) throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue.create must not return null");
            return debugValue;
        }
        debugValue = new Mirror(debugThread, value);
        if (debugValue != null) return debugValue;
        throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue.create must not return null");
    }

    @Nullable
    private static Value unwrapHolders(@Nullable Value value) {
        ObjectReference holder;
        Field valueField;
        while (value != null && value instanceof ObjectReference && value.type().name().endsWith("Holder") && (valueField = (holder = (ObjectReference)value).referenceType().fieldByName(VALUE_FIELD_NAME)) != null && !valueField.isFinal() && valueField.isPublic()) {
            value = holder.getValue(valueField);
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static String stringify(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugValue.stringify must not be null");
        }
        String string = '{' + e.toString() + '}';
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue.stringify must not return null");
        }
        return string;
    }

    private static final class OtdMirror
    extends Mirror {
        @Nullable
        IDebugLocalVariable[] variables;
        @NotNull
        private final ObjectTypeDescription otd;

        OtdMirror(@NotNull DebugThread debugThread, @NotNull ObjectTypeDescription otd, @NotNull Value value) {
            if (debugThread == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugValue$OtdMirror.<init> must not be null");
            }
            if (otd == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of fuego/debugger/DebugValue$OtdMirror.<init> must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of fuego/debugger/DebugValue$OtdMirror.<init> must not be null");
            }
            super(debugThread, value);
            this.otd = otd;
        }

        @Override
        public String getTypeName() {
            return this.otd.getName();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public IDebugLocalVariable[] getVariables() {
            IDebugLocalVariable[] result = this.variables;
            if (result == null) {
                MethodTypeDescription[] attributes = this.otd.getMembers(18, 0L, 0L, TypeFinder.Scope.DEFAULT);
                HashSet<String> added = new HashSet<String>(attributes.length);
                ArrayList<IDebugLocalVariable> vars = new ArrayList<IDebugLocalVariable>(attributes.length);
                for (MethodTypeDescription attribute : attributes) {
                    if (!OtdMirror.isValidAttribute(attribute) || !added.add(attribute.getName())) continue;
                    vars.add(this.createDebugLocalVariable(attribute));
                }
                if (vars.isEmpty()) {
                    result = NO_VARIABLES;
                } else {
                    result = new IDebugLocalVariable[vars.size()];
                    vars.toArray(result);
                }
                this.variables = result;
            }
            IDebugLocalVariable[] iDebugLocalVariableArray = (IDebugLocalVariable[])result.clone();
            if (iDebugLocalVariableArray == null) {
                throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue$OtdMirror.getVariables must not return null");
            }
            return iDebugLocalVariableArray;
        }

        private static boolean isValidAttribute(MethodTypeDescription attribute) {
            return attribute.hasGetter() && !attribute.isStatic() && !attribute.isHidden();
        }

        private IDebugLocalVariable createDebugLocalVariable(final @NotNull MethodTypeDescription attribute) {
            if (attribute == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugValue$OtdMirror.createDebugLocalVariable must not be null");
            }
            return new DebugLocalVariable(){

                @Override
                public String getName() {
                    return attribute.getName();
                }

                @Override
                public String getTypeName() {
                    return attribute.getResultType().getName();
                }

                @Override
                @NotNull
                DebugValue createDebugValue() {
                    Value v;
                    String javaSignature = attribute.getSignature();
                    assert (javaSignature != null);
                    try {
                        v = this.callMethod(javaSignature);
                    }
                    catch (Exception e) {
                        return new ExceptionValue(e);
                    }
                    return OtdMirror.this.create(v);
                }

                @Nullable
                private Value callMethod(String javaSignature) throws Exception {
                    String signature;
                    assert (javaSignature.charAt(0) == 'M');
                    int pos = javaSignature.indexOf(40);
                    assert (pos >= 0);
                    ObjectReference obj = (ObjectReference)OtdMirror.this.value;
                    String getterName = javaSignature.substring(1, pos);
                    Method method = Mirror.findMethod(obj, getterName, signature = javaSignature.substring(pos).replace('.', '/'));
                    if (method == null) {
                        return null;
                    }
                    return OtdMirror.this.debugThread.invokeMethod(obj, method);
                }
            };
        }

        private static class ExceptionValue
        extends DebugValue {
            private final Exception e;

            ExceptionValue(Exception e) {
                this.e = e;
            }

            @Override
            public String getTypeName() {
                return "";
            }

            @Override
            public boolean hasVariables() {
                return false;
            }

            public String toString() {
                return DebugValue.stringify(this.e);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public IDebugLocalVariable[] getVariables() {
                IDebugLocalVariable[] iDebugLocalVariableArray = NO_VARIABLES;
                if (iDebugLocalVariableArray == null) {
                    throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue$OtdMirror$ExceptionValue.getVariables must not return null");
                }
                return iDebugLocalVariableArray;
            }
        }
    }

    private static class Mirror
    extends DebugValue {
        @NotNull
        DebugThread debugThread;
        @NotNull
        final Value value;
        @Nullable
        private String stringValue;
        @Nullable
        private IDebugLocalVariable[] variables;
        @NonNls
        private static final String TO_STRING_METHOD_SIGNATURE = "()Ljava/lang/String;";
        private static final IDebugLocalVariable LAST_ARRAY_ELEMENT = new IDebugLocalVariable(){

            @Override
            public String getName() {
                return "...";
            }

            @Override
            public String getTypeName() {
                return "";
            }

            @Override
            @NotNull
            public DebugValue getValue() {
                return Empty.INSTANCE;
            }
        };

        Mirror(@NotNull DebugThread debugThread, @NotNull Value value) {
            if (debugThread == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugValue$Mirror.<init> must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of fuego/debugger/DebugValue$Mirror.<init> must not be null");
            }
            this.debugThread = debugThread;
            this.value = value;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public DebugValue create(@Nullable Value value) {
            DebugValue debugValue = Mirror.create(this.debugThread, value);
            if (debugValue == null) {
                throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue$Mirror.create must not return null");
            }
            return debugValue;
        }

        public String toString() {
            String result = this.stringValue;
            if (result == null) {
                this.stringValue = result = this.makeStringValue();
            }
            return result;
        }

        @Override
        public String getTypeName() {
            return this.value.type().name();
        }

        @Override
        public boolean hasVariables() {
            return this.value instanceof ObjectReference && !(this.value instanceof StringReference);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public IDebugLocalVariable[] getVariables() {
            IDebugLocalVariable[] result = this.variables;
            if (result == null) {
                this.variables = result = !this.hasVariables() ? NO_VARIABLES : (this.value instanceof ArrayReference ? this.buildArrayValues((ArrayReference)this.value) : this.buildFieldValues((ObjectReference)this.value));
            }
            IDebugLocalVariable[] iDebugLocalVariableArray = (IDebugLocalVariable[])result.clone();
            if (iDebugLocalVariableArray == null) {
                throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue$Mirror.getVariables must not return null");
            }
            return iDebugLocalVariableArray;
        }

        @Nullable
        static Method findMethod(@NotNull ObjectReference obj, @NotNull String name, @NotNull String signature) {
            if (obj == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugValue$Mirror.findMethod must not be null");
            }
            if (name == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of fuego/debugger/DebugValue$Mirror.findMethod must not be null");
            }
            if (signature == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of fuego/debugger/DebugValue$Mirror.findMethod must not be null");
            }
            List<Method> methods = obj.referenceType().methodsByName(name, signature);
            for (Method method : methods) {
                if (method.isAbstract()) continue;
                return method;
            }
            return null;
        }

        @Nullable
        private static Method toStringMethod(ObjectReference obj) {
            if (obj instanceof ArrayReference) {
                return null;
            }
            Method method = Mirror.findMethod(obj, "toString", TO_STRING_METHOD_SIGNATURE);
            if (method == null) {
                return null;
            }
            if (Object.class.getName().equals(method.declaringType().name())) {
                return null;
            }
            return method;
        }

        @Nullable
        private String callToString(@NotNull ObjectReference obj) {
            String result;
            if (obj == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugValue$Mirror.callToString must not be null");
            }
            Method method = Mirror.toStringMethod(obj);
            if (method == null) {
                return null;
            }
            try {
                Value value = this.debugThread.invokeMethod(obj, method);
                result = value == null ? null : ((StringReference)value).value();
            }
            catch (Exception e) {
                return DebugValue.stringify(e);
            }
            return String.valueOf(result);
        }

        private String makeStringValue() {
            String stringResult;
            Value v = this.value;
            if (v instanceof ObjectReference && !(v instanceof StringReference) && (stringResult = this.callToString((ObjectReference)v)) != null) {
                return stringResult;
            }
            return String.valueOf(v);
        }

        private IDebugLocalVariable maveArrayValue(final ArrayReference reference, final int index) {
            return new DebugLocalVariable(){

                @Override
                public String getName() {
                    return String.valueOf(index);
                }

                @Override
                public String getTypeName() {
                    return ((ArrayType)reference.referenceType()).componentTypeName();
                }

                @Override
                @NotNull
                DebugValue createDebugValue() {
                    return Mirror.this.create(reference.getValue(index));
                }
            };
        }

        private IDebugLocalVariable[] buildArrayValues(ArrayReference array) {
            int length = array.length();
            boolean tooLarge = length > 60;
            int tooLargeSize = 51;
            IDebugLocalVariable[] result = new IDebugLocalVariable[tooLarge ? 51 : length];
            for (int i = 0; i < result.length; ++i) {
                IDebugLocalVariable variable = !tooLarge || i != 50 ? this.maveArrayValue(array, i) : LAST_ARRAY_ELEMENT;
                result[i] = variable;
            }
            return result;
        }

        private IDebugLocalVariable[] buildFieldValues(final ObjectReference reference) {
            List<Field> fieldList = reference.referenceType().allFields();
            ArrayList<Field> relevantFields = new ArrayList<Field>(fieldList.size());
            for (Field field : fieldList) {
                if (field.isSynthetic() || field.isStatic()) continue;
                relevantFields.add(field);
            }
            IDebugLocalVariable[] result = new IDebugLocalVariable[relevantFields.size()];
            for (int i = 0; i < result.length; ++i) {
                final Field field = (Field)relevantFields.get(i);
                result[i] = new DebugLocalVariable(){

                    @Override
                    public String getName() {
                        return field.name();
                    }

                    @Override
                    public String getTypeName() {
                        return field.typeName();
                    }

                    @Override
                    @NotNull
                    DebugValue createDebugValue() {
                        return Mirror.this.create(reference.getValue(field));
                    }
                };
            }
            return result;
        }
    }

    private static final class Empty
    extends DebugValue {
        static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        public String toString() {
            return "";
        }

        @Override
        public String getTypeName() {
            return "";
        }

        @Override
        public boolean hasVariables() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public IDebugLocalVariable[] getVariables() {
            IDebugLocalVariable[] iDebugLocalVariableArray = NO_VARIABLES;
            if (iDebugLocalVariableArray == null) {
                throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue$Empty.getVariables must not return null");
            }
            return iDebugLocalVariableArray;
        }
    }

    private static abstract class DebugLocalVariable
    implements IDebugLocalVariable {
        @Nullable
        private DebugValue value;

        private DebugLocalVariable() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public final synchronized DebugValue getValue() {
            DebugValue result = this.value;
            if (result == null) {
                this.value = result = this.createDebugValue();
            }
            DebugValue debugValue = result;
            if (debugValue == null) {
                throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugValue$DebugLocalVariable.getValue must not return null");
            }
            return debugValue;
        }

        @NotNull
        abstract DebugValue createDebugValue();
    }
}

