/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import fuego.debugger.DebugSession;
import fuego.debugger.DebugStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.lang.ObjectTypeDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugThread {
    @NotNull
    private final DebugSession session;
    private boolean snapshotDone;
    @Nullable
    private List<DebugStackFrame> stackTrace;
    @NotNull
    private final ThreadReference thread;

    DebugThread(@NotNull DebugSession session, @NotNull ThreadReference thread) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of fuego/debugger/DebugThread.<init> must not be null");
        }
        if (thread == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of fuego/debugger/DebugThread.<init> must not be null");
        }
        this.session = session;
        this.thread = thread;
    }

    public String toString() {
        return "DebugThread{" + this.locationString() + '}';
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<DebugStackFrame> getStackTrace() {
        void var1_5;
        List<DebugStackFrame> list = this.stackTrace;
        if (list == null) {
            void var1_4;
            try {
                List<DebugStackFrame> list2 = this.makeTrace();
            }
            catch (IncompatibleThreadStateException e) {
                List list3 = Collections.emptyList();
            }
            this.stackTrace = var1_4;
        }
        void v0 = var1_5;
        if (v0 == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugThread.getStackTrace must not return null");
        }
        return v0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    ThreadReference getThread() {
        ThreadReference threadReference = this.thread;
        if (threadReference == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugThread.getThread must not return null");
        }
        return threadReference;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    DebugSession getSession() {
        DebugSession debugSession = this.session;
        if (debugSession == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugThread.getSession must not return null");
        }
        return debugSession;
    }

    synchronized Value invokeMethod(ObjectReference obj, Method method) throws Exception {
        this.makeSnapshot();
        return obj.invokeMethod(this.getThread(), method, Collections.emptyList(), 0);
    }

    private String locationString() {
        StackFrame stackFrame;
        try {
            stackFrame = this.thread.frame(0);
        }
        catch (IncompatibleThreadStateException e) {
            return "";
        }
        return String.valueOf(stackFrame.location());
    }

    private void makeSnapshot() {
        if (this.snapshotDone) {
            return;
        }
        this.snapshotDone = true;
        for (DebugStackFrame frame : this.getStackTrace()) {
            frame.getLocalVariables();
        }
    }

    private List<DebugStackFrame> makeTrace() throws IncompatibleThreadStateException {
        ArrayList<DebugStackFrame> result = new ArrayList<DebugStackFrame>();
        ThreadReference thread = this.thread;
        int count = thread.frameCount();
        for (int i = 0; i < count; ++i) {
            StackFrame frame = thread.frame(i);
            ObjectTypeDescription otd = this.getSession().getLocationObjectTypeDescription(frame.location());
            if (otd == null) continue;
            result.add(new DebugStackFrame(this, frame, otd));
        }
        return result;
    }
}

