/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.EventRequest;
import fuego.debugger.DebugSession;
import oracle.bpm.log.Log;
import oracle.bpm.log.Trace;
import oracle.bpm.util.LifecycleLock;

class DebugEventDispatcher {
    private final LifecycleLock lifecycle = new LifecycleLock();
    private final EventQueue queue;
    private volatile boolean running;
    private DebugSession session;
    private static final Trace TRACE = Trace.getInstance(DebugEventDispatcher.class);

    DebugEventDispatcher(DebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session is not optional");
        }
        this.session = session;
        this.queue = session.getVirtualMachine().eventQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.lifecycle.beginStartup();
        try {
            this.session.resumeEvents();
            this.running = true;
            Thread t = new Thread((Runnable)new ConsumeTask(), "DebugEventDispatcher");
            t.setDaemon(true);
            t.start();
        }
        finally {
            this.lifecycle.endStartup();
        }
    }

    public void shutdown() {
        this.lifecycle.beginShutdown();
        this.running = false;
        this.lifecycle.endShutdown();
    }

    private class ConsumeTask
    implements Runnable {
        private ConsumeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    while (DebugEventDispatcher.this.running) {
                        EventSet eventSet = DebugEventDispatcher.this.queue.remove();
                        DebugEventDispatcher.this.lifecycle.beginWork();
                        try {
                            if (!this.handleEventSet(eventSet)) continue;
                            break;
                        }
                        finally {
                            DebugEventDispatcher.this.lifecycle.endWork();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Log.logDebug(e);
                }
                catch (IllegalStateException e) {
                    if (!DebugEventDispatcher.this.running || !TRACE.isEnabled()) break block7;
                    TRACE.log("Unexpected exception processing events.", e);
                }
            }
            DebugEventDispatcher.this.running = false;
            this.handleDisconnected();
        }

        private boolean handleStepEvent(StepEvent event) {
            if (DebugEventDispatcher.this.session.getLocationObjectTypeDescription(event.location()) != null) {
                DebugEventDispatcher.this.session.fireStepFinished(event);
                return false;
            }
            EventRequest request = event.request();
            request.disable();
            request.addCountFilter(1);
            request.enable();
            return true;
        }

        private boolean handleClassPrepare(ClassPrepareEvent event) {
            DebugEventDispatcher.this.session.fireClassPrepared(event);
            return true;
        }

        private boolean handleBreakpoint(BreakpointEvent event) {
            DebugEventDispatcher.this.session.fireBreakpointActivated(event);
            return false;
        }

        private boolean handleMethodEntry(MethodEntryEvent event) {
            DebugEventDispatcher.this.session.fireMethodEntered(event);
            return true;
        }

        private void handleDisconnected() {
            DebugEventDispatcher.this.session.fireDisconnected();
        }

        private boolean handleEventSet(EventSet eventSet) {
            boolean nestedEvent;
            DebugSession session = DebugEventDispatcher.this.session;
            boolean bl = nestedEvent = session.getEventSet() != null;
            if (!nestedEvent) {
                session.setEventSet(eventSet);
            }
            boolean resume = true;
            boolean disconnected = false;
            for (Event event : eventSet) {
                boolean res;
                if (event instanceof VMDisconnectEvent) {
                    disconnected = true;
                    res = true;
                } else {
                    res = event instanceof ClassPrepareEvent ? this.handleClassPrepare((ClassPrepareEvent)event) : (!nestedEvent ? (event instanceof MethodEntryEvent ? this.handleMethodEntry((MethodEntryEvent)event) : (event instanceof BreakpointEvent ? this.handleBreakpoint((BreakpointEvent)event) : (event instanceof StepEvent ? this.handleStepEvent((StepEvent)event) : true))) : true);
                }
                resume &= res;
            }
            if (resume) {
                if (!nestedEvent) {
                    session.setEventSet(null);
                }
                eventSet.resume();
            }
            return disconnected;
        }
    }
}

