/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.sca;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileEventListener;
import oracle.bpm.io.fs.VFileSystem;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JdevComponentTypesAccessor {
    private Map<String, Component> componentByName;
    private SCAController controller;
    private static final String COMPONENT_TYPE_EXT = ".componentType";

    public JdevComponentTypesAccessor(@NotNull VFileSystem fileSystem, @NotNull SCAController controller) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevComponentTypesAccessor.<init> must not be null");
        }
        if (controller == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/sca/JdevComponentTypesAccessor.<init> must not be null");
        }
        this.componentByName = new HashMap<String, Component>();
        this.controller = controller;
        fileSystem.addListener(new VFileEventListener(){

            public void onFileEvent(@NotNull VFileEvent event) {
                String name;
                int index;
                VEventType type = event.getType();
                if ((type == VEventType.CHANGE || type == VEventType.REMOVE) && (index = (name = event.getSource().getName()).lastIndexOf(JdevComponentTypesAccessor.COMPONENT_TYPE_EXT)) > 0) {
                    JdevComponentTypesAccessor.this.componentByName.remove(name.substring(0, index));
                }
            }
        });
    }

    public InterfaceInfo getInterfaceInfoForName(@NotNull String name, @Nullable String linkName) {
        InterfaceInfo interfaceInfo;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/JdevComponentTypesAccessor.getInterfaceInfoForName must not be null");
        }
        if (linkName != null) {
            Component component = this.componentByName.get(name);
            if (component == null) {
                component = this.createNewComponent(name);
            }
            interfaceInfo = component.getInterfaceInfo(linkName);
        } else {
            interfaceInfo = this.controller.getInterfaceInfoForName(name, linkName);
        }
        return interfaceInfo;
    }

    public List<PropertyInfo> getComponentTypeProperties(String name, String serviceOrReferenceName) {
        Component component = this.componentByName.get(name);
        if (component == null) {
            component = this.createNewComponent(name);
        }
        return component.getComponentTypeProperties(serviceOrReferenceName);
    }

    public void clear() {
        this.componentByName.clear();
    }

    private Component createNewComponent(String name) {
        Component component = new Component(this.controller, name);
        this.componentByName.put(name, component);
        return component;
    }

    static class Component {
        Map<String, InterfaceInfo> interfaceByLinkname = new HashMap<String, InterfaceInfo>();
        String name;
        Map<String, List<PropertyInfo>> propertiesByServiceName = new HashMap<String, List<PropertyInfo>>();
        private SCAController controller;

        Component(SCAController controller, String name) {
            this.name = name;
            this.controller = controller;
        }

        public InterfaceInfo getInterfaceInfo(String linkName) {
            String validName = this.getValidName(linkName);
            InterfaceInfo interfaceInfo = this.interfaceByLinkname.get(validName);
            if (interfaceInfo == null) {
                interfaceInfo = this.controller.getInterfaceInfoForName(this.name, validName);
                this.addInterfaceInfo(validName, interfaceInfo);
            }
            return interfaceInfo;
        }

        public List<PropertyInfo> getComponentTypeProperties(String serviceOrReferenceName) {
            String validName = this.getValidName(serviceOrReferenceName);
            List properties = this.propertiesByServiceName.get(validName);
            if (properties == null) {
                properties = this.controller.getComponentTypeProperties(this.name, validName);
                this.addComponentTypeProperties(validName, properties);
            }
            return properties;
        }

        void addInterfaceInfo(String linkName, InterfaceInfo interfaceInfo) {
            this.interfaceByLinkname.put(this.getValidName(linkName), interfaceInfo);
        }

        void addComponentTypeProperties(String serviceOrReferenceName, List<PropertyInfo> properties) {
            this.propertiesByServiceName.put(this.getValidName(serviceOrReferenceName), properties);
        }

        private String getValidName(String name) {
            if (name == null) {
                name = "";
            }
            return name;
        }
    }
}

