/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bac.core.impl.svn.Literals;
import oracle.bpm.bac.core.model.AssetProperties;
import org.jetbrains.annotations.NotNull;

public abstract class Node
implements Serializable {
    private List<Node> children;
    private String id;
    private Map<String, String> properties;
    private String svnUrl;

    public Node(@NotNull Map<String, String> props) {
        if (props == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/model/Node.<init> must not be null");
        }
        this.children = new ArrayList<Node>();
        this.properties = new HashMap<String, String>();
        this.properties = props;
    }

    public Node(@NotNull Map<String, String> props, @NotNull String svnUrl) {
        if (props == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/model/Node.<init> must not be null");
        }
        if (svnUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/model/Node.<init> must not be null");
        }
        this(props);
        this.svnUrl = svnUrl;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getRawProperties() {
        return this.properties;
    }

    public String getSvnUrl() {
        return this.svnUrl;
    }

    public String getType() {
        return this.properties.get(Literals.BAC_PROPERTY_PREFIX + (Object)((Object)AssetProperties.TYPE));
    }

    public String getSvnPath() {
        return this.getProperty(Literals.BAC_PROPERTY_PREFIX + AssetProperties.SVN_PATH.name());
    }

    public String getName() {
        return this.getProperty(Literals.BAC_PROPERTY_PREFIX + AssetProperties.NAME.name());
    }

    public String getCreator() {
        return this.getProperty(Literals.BAC_PROPERTY_PREFIX + AssetProperties.CREATOR.name());
    }

    public String getRevision() {
        return this.getProperty(Literals.BAC_PROPERTY_PREFIX + AssetProperties.REVISION.name());
    }

    public void addChild(Node node) {
        this.children.add(node);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return other.getSvnPath().equals(this.getSvnPath());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        Set<String> stringSet = this.properties.keySet();
        for (String key : stringSet) {
            str.append(key).append("=").append(this.properties.get(key));
            str.append(";");
        }
        return str.toString();
    }

    protected String getProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/model/Node.getProperty must not be null");
        }
        return this.properties.get(key);
    }
}

