/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.io;

import oracle.bpm.bac.core.exception.BacTransactionException;

public abstract class Transaction {
    private int activesSessions = 0;
    private boolean autocommit = true;
    private boolean isCommited = false;
    private boolean isRollback = false;

    public Transaction() {
        this(true);
    }

    public Transaction(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public void begin() throws BacTransactionException {
        if ((this.isAutoCommit() || !this.isOpen()) && this.activesSessions == 0) {
            this.doBegin();
        }
        this.isRollback = false;
        this.isCommited = false;
        ++this.activesSessions;
    }

    public void setAutoCommit(boolean autocommit) throws BacTransactionException {
        boolean change = this.autocommit != autocommit;
        this.autocommit = autocommit;
        if (change && autocommit) {
            this.commit();
        }
    }

    public boolean isAutoCommit() {
        return this.autocommit;
    }

    public boolean isRollback() {
        return this.isRollback;
    }

    public boolean isCommited() {
        return this.isCommited;
    }

    public void rollback() {
        if (this.isAutoCommit() || --this.activesSessions <= 0) {
            this.doRollback();
            this.isRollback = true;
            this.isCommited = false;
        }
    }

    public void commit() throws BacTransactionException {
        if (this.isRollback) {
            throw BacTransactionException.createTxRollbackedException();
        }
        if (this.activesSessions == 0) {
            throw BacTransactionException.createNoActiveTransactionException();
        }
        if (this.isAutoCommit() || this.activesSessions - 1 <= 0) {
            this.doCommit();
            this.isCommited = true;
            this.isRollback = false;
            this.activesSessions = 0;
        } else {
            --this.activesSessions;
        }
    }

    public boolean isOpen() {
        return !this.isRollback() && !this.isCommited();
    }

    protected abstract void doBegin() throws BacTransactionException;

    protected abstract void doCommit() throws BacTransactionException;

    protected abstract void doRollback();
}

