/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.impl.svn.vfs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.exception.BacTransactionException;
import oracle.bpm.bac.core.impl.svn.SvnConnection;
import oracle.bpm.bac.core.impl.svn.SvnTransaction;
import oracle.bpm.bac.core.impl.svn.utils.SvnKitHelper;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

public class SvnFilesystem
extends VFileSystem {
    private SvnConnection connection;

    public SvnFilesystem(@NotNull SvnConnection connection) throws IOException {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.<init> must not be null");
        }
        this.connection = connection;
    }

    public void flush() throws IOException {
    }

    public VFile[] list(@NotNull VFile vFile, @Nullable VFileFilter filter) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.list must not be null");
        }
        ArrayList<VFile> ret = new ArrayList<VFile>();
        try {
            Collection<SVNDirEntry> svnDirEntries = SvnKitHelper.list(this.connection.getRepository(), vFile.getCanonicalPath());
            for (SVNDirEntry svnDirEntry : svnDirEntries) {
                VFile newVFile = this.createFile(vFile.getCanonicalPath() + "/" + svnDirEntry.getName());
                if (filter != null && !filter.accept(newVFile)) continue;
                ret.add(newVFile);
            }
        }
        catch (BacException e) {
            // empty catch block
        }
        return !ret.isEmpty() ? ret.toArray(new VFile[ret.size()]) : new VFile[]{};
    }

    public void closeOutputStream(@NotNull VFile vFile, @NotNull OutputStream out) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.closeOutputStream must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.closeOutputStream must not be null");
        }
        try {
            this.connection.begin();
            ISVNEditor svnEditor = this.getSVNEditor();
            String filePath = vFile.getCanonicalPath();
            svnEditor.addFile(filePath, null, -1L);
            svnEditor.applyTextDelta(filePath, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            byte[] in = ((ByteArrayOutputStream)out).toByteArray();
            String checksum = deltaGenerator.sendDelta(filePath, (InputStream)new BufferedInputStream(new ByteArrayInputStream(in)), (ISVNDeltaConsumer)svnEditor, true);
            svnEditor.closeFile(filePath, checksum);
            this.connection.commit();
            super.closeOutputStream(vFile, out);
        }
        catch (SVNException e) {
            this.connection.rollback();
            throw new IOException(e);
        }
        catch (BacTransactionException e) {
            this.connection.rollback();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getUniqueID() {
        String string = (Object)((Object)this.connection.getConfig().getConnectionType()) + ":" + this.connection.getConfig().getConnectionString();
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.getUniqueID must not return null");
        }
        return string;
    }

    protected long lastModified(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.lastModified must not be null");
        }
        String filePath = vFile.getCanonicalPath();
        try {
            return SvnKitHelper.lastModified(this.connection.getRepository(), filePath);
        }
        catch (BacException e) {
            return 0L;
        }
    }

    protected boolean isZeroLength(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.isZeroLength must not be null");
        }
        return false;
    }

    protected boolean delete(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.delete must not be null");
        }
        boolean deleted = false;
        if (!this.exists(vFile)) {
            return deleted;
        }
        try {
            this.connection.begin();
            ISVNEditor svnEditor = this.getSVNEditor();
            svnEditor.deleteEntry(vFile.getCanonicalPath(), -1L);
            this.connection.commit();
            deleted = true;
        }
        catch (BacTransactionException e) {
            this.connection.rollback();
        }
        catch (SVNException e) {
            this.connection.rollback();
        }
        if (deleted) {
            this.fireEvent(new VFileEvent(VEventType.REMOVE, vFile));
        }
        return deleted;
    }

    protected boolean mkdirs(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.mkdirs must not be null");
        }
        boolean created = false;
        if (this.exists(vFile)) {
            return created;
        }
        try {
            this.connection.begin();
            ISVNEditor svnEditor = this.getSVNEditor();
            svnEditor.addDir(vFile.getCanonicalPath(), null, -1L);
            svnEditor.closeDir();
            created = true;
            this.connection.commit();
        }
        catch (SVNException e) {
            this.connection.rollback();
        }
        catch (BacTransactionException e) {
            this.connection.rollback();
        }
        return created;
    }

    protected boolean exists(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.exists must not be null");
        }
        return SVNNodeKind.NONE.compareTo((Object)this.getSVNNodeKind(vFile)) != 0;
    }

    protected boolean isDirectory(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.isDirectory must not be null");
        }
        return SVNNodeKind.DIR.compareTo((Object)this.getSVNNodeKind(vFile)) == 0;
    }

    protected boolean isFile(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.isFile must not be null");
        }
        return SVNNodeKind.FILE.compareTo((Object)this.getSVNNodeKind(vFile)) == 0;
    }

    protected boolean canWrite(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.canWrite must not be null");
        }
        boolean canWrite = false;
        try {
            canWrite = this.connection.getRepository().getLock(vFile.getCanonicalPath()) == null;
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return canWrite;
    }

    protected InputStream openInputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.openInputStream must not be null");
        }
        if (!this.exists(vFile)) {
            throw new FileNotFoundException(vFile.getCanonicalPath());
        }
        return SvnKitHelper.openInputStream(this.connection.getRepository(), vFile.getCanonicalPath());
    }

    protected OutputStream openOutputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.openOutputStream must not be null");
        }
        if (vFile.isDirectory() || !vFile.getParentFile().exists()) {
            throw new FileNotFoundException(vFile.getCanonicalPath());
        }
        vFile.setCreated(!vFile.exists());
        return new ByteArrayOutputStream();
    }

    protected boolean isHidden(@NotNull VFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/vfs/SvnFilesystem.isHidden must not be null");
        }
        return false;
    }

    private SVNNodeKind getSVNNodeKind(VFile vFile) {
        SVNNodeKind nodeKind = null;
        try {
            nodeKind = this.connection.getRepository().checkPath(vFile.getCanonicalPath(), -1L);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return nodeKind;
    }

    private ISVNEditor getSVNEditor() {
        return ((SvnTransaction)this.connection.getTransaction()).getSVNEditor();
    }
}

