/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.impl.svn.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.impl.svn.Literals;
import oracle.bpm.bac.core.impl.svn.SvnProtocol;
import oracle.bpm.bac.core.model.AssetProperties;
import oracle.bpm.bac.core.msg.BacMsg;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;

public final class SvnKitHelper {
    public static void abortEditor(@Nullable ISVNEditor editor) throws SVNException {
        if (editor != null) {
            editor.abortEdit();
        }
    }

    public static void closeEditor(@Nullable ISVNEditor editor) throws SVNException {
        if (editor != null) {
            editor.closeDir();
            editor.closeEdit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static ISVNEditor createEditor(@NotNull SVNRepository repository, @NotNull String logMessage) throws BacException {
        ISVNEditor iSVNEditor;
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createEditor must not be null");
        }
        if (logMessage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createEditor must not be null");
        }
        try {
            ISVNEditor editor = repository.getCommitEditor(logMessage, null, true, null);
            editor.openRoot(-1L);
            iSVNEditor = editor;
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
        if (iSVNEditor == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createEditor must not return null");
        }
        return iSVNEditor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static SVNRepository createLocalRepository(@NotNull String path) throws BacException {
        SVNRepository repository;
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createLocalRepository must not be null");
        }
        try {
            FSRepositoryFactory.setup();
            String url = SvnProtocol.FILE.getProtocol() + path;
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
        SVNRepository sVNRepository = repository;
        if (sVNRepository == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createLocalRepository must not return null");
        }
        return sVNRepository;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static SVNRepository createRemoteRepository(@NotNull String remotePath) throws BacException {
        SVNRepository repository;
        if (remotePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createRemoteRepository must not be null");
        }
        try {
            SVNRepositoryFactoryImpl.setup();
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)remotePath));
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
        SVNRepository sVNRepository = repository;
        if (sVNRepository == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createRemoteRepository must not return null");
        }
        return sVNRepository;
    }

    public static void createFolder(@NotNull ISVNEditor editor, @NotNull String fullPath, @NotNull Map<String, String> properties) throws BacException {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createFolder must not be null");
        }
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createFolder must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createFolder must not be null");
        }
        if (SvnKitHelper.existsDir(editor, fullPath)) {
            throw new BacException(BacMsg.FOLDER_ALREADY_EXISTS(fullPath));
        }
        try {
            editor.addDir(VFileUtils.getCanonicalPath((String)fullPath), null, -1L);
            for (String key : properties.keySet()) {
                editor.changeDirProperty(key, SVNPropertyValue.create((String)properties.get(key)));
            }
            editor.closeDir();
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
    }

    public static void removeFolder(@NotNull ISVNEditor editor, @NotNull String fullPath) throws BacException {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.removeFolder must not be null");
        }
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.removeFolder must not be null");
        }
        if (!SvnKitHelper.existsDir(editor, fullPath)) {
            throw new BacException(BacMsg.FOLDER_NOT_EXISTS(fullPath));
        }
        try {
            editor.deleteEntry(VFileUtils.getCanonicalPath((String)fullPath), -1L);
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Collection<SVNDirEntry> list(@NotNull SVNRepository repository, @NotNull String path) throws BacException {
        Collection collection;
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.list must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.list must not be null");
        }
        try {
            collection = repository.getDir(VFileUtils.getCanonicalPath((String)path), -1L, null, (Collection)null);
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
        if (collection == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.list must not return null");
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static HashMap<String, String> getProperties(@NotNull SVNRepository repository, @NotNull SVNDirEntry svnDirEntry, @NotNull String fullPath) throws BacException {
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.getProperties must not be null");
        }
        if (svnDirEntry == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.getProperties must not be null");
        }
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.getProperties must not be null");
        }
        HashMap<String, String> assetProperties = new HashMap<String, String>();
        assetProperties.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.NAME.name(), svnDirEntry.getName());
        assetProperties.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.CREATOR.name(), svnDirEntry.getAuthor());
        assetProperties.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.REVISION.name(), Long.toString(svnDirEntry.getRevision()));
        assetProperties.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.SVN_PATH.name(), fullPath);
        try {
            SVNNodeKind nodeKind = svnDirEntry.getKind();
            SVNProperties props = new SVNProperties();
            if (SVNNodeKind.DIR.compareTo((Object)nodeKind) == 0) {
                repository.getDir(fullPath, -1L, props, (Collection)null);
            } else if (SVNNodeKind.FILE.compareTo((Object)nodeKind) == 0) {
                repository.getFile(fullPath, -1L, props, null);
            }
            Set propertyNames = props.nameSet();
            for (String propertyName : propertyNames) {
                assetProperties.put(propertyName, props.getStringValue(propertyName));
            }
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
        HashMap<String, String> hashMap = assetProperties;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.getProperties must not return null");
        }
        return hashMap;
    }

    public static boolean existsDir(@NotNull ISVNEditor editor, @NotNull String fullPath) throws BacException {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.existsDir must not be null");
        }
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.existsDir must not be null");
        }
        try {
            editor.openDir(fullPath, -1L);
            return true;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode().getCode() == 160016) {
                return false;
            }
            throw new BacException((Exception)((Object)e));
        }
    }

    public static boolean checkPath(@NotNull SVNRepository repository, @NotNull String fullPath) throws BacException {
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.checkPath must not be null");
        }
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.checkPath must not be null");
        }
        try {
            SVNNodeKind nodeKind = repository.checkPath(VFileUtils.getCanonicalPath((String)fullPath), -1L);
            return SVNNodeKind.NONE.compareTo((Object)nodeKind) != 0;
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
    }

    public static InputStream openInputStream(final @NotNull SVNRepository repository, final @NotNull String canonicalPath) throws IOException {
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.openInputStream must not be null");
        }
        if (canonicalPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.openInputStream must not be null");
        }
        PipedInputStream in = new PipedInputStream();
        final PipedOutputStream out = new PipedOutputStream(in);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(out);
                try {
                    repository.getFile(canonicalPath, -1L, null, (OutputStream)bufferedOutputStream);
                    bufferedOutputStream.close();
                }
                catch (SVNException e) {
                    e.printStackTrace();
                    StreamUtils.close(bufferedOutputStream);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            StreamUtils.close(bufferedOutputStream);
                            throw throwable;
                        }
                    }
                    StreamUtils.close(bufferedOutputStream);
                }
                StreamUtils.close(bufferedOutputStream);
            }
        }).start();
        return new BufferedInputStream(in);
    }

    public static void createBranch(@NotNull SVNRepository repository, @NotNull String from, @NotNull String to) throws BacException {
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createBranch must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createBranch must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.createBranch must not be null");
        }
        SVNClientManager svnClientManager = SVNClientManager.newInstance();
        SVNCopyClient copyClient = svnClientManager.getCopyClient();
        SVNURL location = repository.getLocation();
        try {
            SVNURL srcURL = SVNURL.parseURIEncoded((String)(location + from));
            SVNURL dstURL = SVNURL.parseURIEncoded((String)(location + to));
            SVNCopySource source = new SVNCopySource(SVNRevision.HEAD, SVNRevision.HEAD, srcURL);
            copyClient.doCopy(new SVNCopySource[]{source}, dstURL, false, false, true, "Create new Branch", null);
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
    }

    public static void removeBranch(@NotNull SVNRepository repository, @NotNull String branchFullPathLocation) {
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.removeBranch must not be null");
        }
        if (branchFullPathLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/utils/SvnKitHelper.removeBranch must not be null");
        }
        SVNClientManager svnClientManager = SVNClientManager.newInstance();
    }

    public static long lastModified(SVNRepository repository, String filePath) throws BacException {
        try {
            return repository.info(filePath, -1L).getDate().getTime();
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
    }
}

