/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.impl.svn;

import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.exception.BacTransactionException;
import oracle.bpm.bac.core.impl.svn.utils.SvnKitHelper;
import oracle.bpm.bac.core.io.Transaction;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;

public final class SvnTransaction
extends Transaction {
    private SVNRepository repository;
    private ISVNEditor svnEditor;

    public SvnTransaction(@NotNull SVNRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnTransaction.<init> must not be null");
        }
        this.repository = null;
        this.svnEditor = null;
        this.repository = repository;
    }

    public ISVNEditor getSVNEditor() {
        return this.svnEditor;
    }

    @Override
    public boolean isOpen() {
        return !this.isRollback() && !this.isCommited() && this.svnEditor != null;
    }

    @Override
    protected void doBegin() throws BacTransactionException {
        try {
            this.svnEditor = SvnKitHelper.createEditor(this.repository, "");
        }
        catch (BacException e) {
            throw BacTransactionException.createTransactionException(e);
        }
    }

    @Override
    protected void doCommit() throws BacTransactionException {
        try {
            SvnKitHelper.closeEditor(this.svnEditor);
        }
        catch (SVNException e) {
            throw BacTransactionException.createTransactionException(e);
        }
    }

    @Override
    protected void doRollback() {
        try {
            SvnKitHelper.abortEditor(this.svnEditor);
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }
}

