/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.impl.svn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.impl.svn.Literals;
import oracle.bpm.bac.core.impl.svn.SvnConnection;
import oracle.bpm.bac.core.impl.svn.SvnTransaction;
import oracle.bpm.bac.core.impl.svn.Types;
import oracle.bpm.bac.core.impl.svn.utils.SvnKitHelper;
import oracle.bpm.bac.core.io.Persistence;
import oracle.bpm.bac.core.model.AssetProperties;
import oracle.bpm.bac.core.model.BranchType;
import oracle.bpm.bac.core.model.Folder;
import oracle.bpm.bac.core.model.LockInfo;
import oracle.bpm.bac.core.model.Node;
import oracle.bpm.bac.core.model.Project;
import oracle.bpm.bac.core.msg.BacMsg;
import oracle.bpm.io.fs.VFileUtils;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;

public final class SvnPersistence
implements Persistence {
    private SvnConnection connection;
    private SVNRepository repository;

    public SvnPersistence(@NotNull SvnConnection connection) throws BacException {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.<init> must not be null");
        }
        this.connection = connection;
        this.repository = connection.getRepository();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Folder getRoot() throws BacException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.IS_FOLDER.name(), Boolean.TRUE.toString());
        props.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.NAME.name(), "Repository");
        props.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.CREATOR.name(), "Bac");
        props.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.SVN_PATH.name(), "/");
        Folder rootNode = new Folder(props);
        this.fillTree(rootNode, "/");
        Folder folder = rootNode;
        if (folder == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bac/core/impl/svn/SvnPersistence.getRoot must not return null");
        }
        return folder;
    }

    @Override
    public void createFolder(@NotNull String fullPath) throws BacException {
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createFolder must not be null");
        }
        if (SvnKitHelper.existsDir(this.getSVNEditor(), fullPath)) {
            throw new BacException(BacMsg.FOLDER_ALREADY_EXISTS(fullPath));
        }
        try {
            this.connection.begin();
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.TYPE.name(), Types.FOLDER.getCode());
            SvnKitHelper.createFolder(this.getSVNEditor(), fullPath, props);
            this.connection.commit();
        }
        catch (BacException e) {
            this.connection.rollback();
            throw e;
        }
    }

    @Override
    public void deleteFolder(@NotNull String fullPath) throws BacException {
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.deleteFolder must not be null");
        }
        if (!SvnKitHelper.existsDir(this.getSVNEditor(), fullPath)) {
            throw new BacException(BacMsg.FOLDER_NOT_EXISTS(fullPath));
        }
        try {
            this.connection.begin();
            SvnKitHelper.removeFolder(this.getSVNEditor(), fullPath);
            this.connection.commit();
        }
        catch (BacException e) {
            this.connection.rollback();
            throw e;
        }
    }

    @Override
    public boolean existsFolder(@NotNull String fullPath) throws BacException {
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.existsFolder must not be null");
        }
        return SvnKitHelper.checkPath(this.repository, fullPath);
    }

    @Override
    public Project createProject(@NotNull String location, @NotNull String name) throws BacException {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createProject must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createProject must not be null");
        }
        if (!SvnKitHelper.existsDir(this.getSVNEditor(), location)) {
            throw new BacException(BacMsg.FOLDER_NOT_EXISTS(location));
        }
        String projectFolder = location + "/" + name;
        if (SvnKitHelper.existsDir(this.getSVNEditor(), projectFolder)) {
            throw new BacException(BacMsg.FOLDER_ALREADY_EXISTS(projectFolder));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(Literals.BAC_PROPERTY_PREFIX + AssetProperties.TYPE.name(), Types.PROJECT.getCode());
        props.put(Literals.BAC_PROPERTY_PREFIX + (Object)((Object)AssetProperties.SVN_PATH), projectFolder);
        SvnKitHelper.createFolder(this.getSVNEditor(), projectFolder, props);
        SvnKitHelper.createFolder(this.getSVNEditor(), projectFolder + "/" + BranchType.MAIN.getCode(), props);
        SvnKitHelper.createFolder(this.getSVNEditor(), projectFolder + "/" + BranchType.BRANCH.getCode(), props);
        SvnKitHelper.createFolder(this.getSVNEditor(), projectFolder + "/" + BranchType.TAG.getCode(), props);
        SvnKitHelper.createFolder(this.getSVNEditor(), projectFolder + "/" + BranchType.SESSION.getCode(), props);
        ArrayList<String> empty = new ArrayList<String>();
        return new Project(props, empty, empty, projectFolder, null);
    }

    @Override
    public void deleteProject(@NotNull Project project) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.deleteProject must not be null");
        }
        SvnKitHelper.removeFolder(this.getSVNEditor(), project.getSvnPath());
    }

    @Override
    public boolean existsProject(@NotNull String svnLocation) throws BacException {
        if (svnLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.existsProject must not be null");
        }
        String typePropertyName = Literals.BAC_PROPERTY_PREFIX + AssetProperties.TYPE.name();
        if (!SvnKitHelper.checkPath(this.repository, svnLocation)) {
            return false;
        }
        try {
            SVNDirEntry svnDirEntry = this.repository.info(svnLocation, -1L);
            HashMap<String, String> properties = SvnKitHelper.getProperties(this.repository, svnDirEntry, svnLocation);
            return properties.get(typePropertyName).equals(Types.PROJECT.getCode());
        }
        catch (SVNException e) {
            throw new BacException((Exception)((Object)e));
        }
    }

    @Override
    public void createBranch(@NotNull String from, @NotNull BranchType type, @NotNull String branchName) throws BacException {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createBranch must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createBranch must not be null");
        }
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createBranch must not be null");
        }
        String mainFullPath = from + "/" + BranchType.MAIN.getCode();
        String branchFullPath = from + "/" + type.getCode() + "/" + branchName;
        SvnKitHelper.createBranch(this.repository, mainFullPath, branchFullPath);
    }

    @Override
    public Project loadProject(@NotNull String fullProjectLocation) throws BacException {
        if (fullProjectLocation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.loadProject must not be null");
        }
        try {
            SVNDirEntry svnDirEntry = this.repository.getDir(VFileUtils.getCanonicalPath((String)fullProjectLocation), -1L, true, null);
            HashMap<String, String> props = SvnKitHelper.getProperties(this.repository, svnDirEntry, fullProjectLocation);
            boolean isFolderType = this.isFolderType(props);
            if (isFolderType) {
                // empty if block
            }
            return this.createProject(fullProjectLocation, props);
        }
        catch (SVNException e) {
            throw new BacException(BacMsg.BAC_IO_ERROR, (Throwable)e);
        }
    }

    @Override
    public void deleteBranch(@NotNull Project project, @NotNull BranchType type, @NotNull String branchName) throws BacException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.deleteBranch must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.deleteBranch must not be null");
        }
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.deleteBranch must not be null");
        }
        String svnPath = project.getSvnPath();
        LinkedList pathParts = VFileUtils.canonicalDecomposition((String)svnPath);
        pathParts.removeLast();
        String basePath = VFileUtils.makePathName((Iterable)pathParts);
        String relativeBranchPath = type.getCode() + "/" + branchName;
        String fullBranchPath = VFileUtils.getCanonicalPath((String)(basePath + "/" + relativeBranchPath));
        if (!this.existsProject(fullBranchPath)) {
            throw new BacException(BacMsg.PROJECT_NOT_EXISTS(branchName, relativeBranchPath));
        }
        SvnKitHelper.removeBranch(this.repository, fullBranchPath);
    }

    @Override
    public void mergeBranch(@NotNull String branchName, @NotNull String to) throws BacException {
        if (branchName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.mergeBranch must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.mergeBranch must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void aquireLock(@NotNull String pathToLock) throws BacException {
        if (pathToLock == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.aquireLock must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseLock(@NotNull String pathToUnlock) throws BacException {
        if (pathToUnlock == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.releaseLock must not be null");
        }
        throw new UnsupportedOperationException();
    }

    private ISVNEditor getSVNEditor() {
        return ((SvnTransaction)this.connection.getTransaction()).getSVNEditor();
    }

    private void fillTree(@NotNull Node currentNode, @NotNull String path) throws BacException {
        if (currentNode == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.fillTree must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.fillTree must not be null");
        }
        Collection<SVNDirEntry> entries = SvnKitHelper.list(this.repository, path);
        for (SVNDirEntry svnDirEntry : entries) {
            SVNNodeKind nodeKind = svnDirEntry.getKind();
            String fullPath = path.equals("") ? svnDirEntry.getName() : path + "/" + svnDirEntry.getName();
            boolean isFolder = SVNNodeKind.DIR.compareTo((Object)nodeKind) == 0;
            if (!isFolder) continue;
            HashMap<String, String> props = SvnKitHelper.getProperties(this.repository, svnDirEntry, fullPath);
            boolean isFolderType = this.isFolderType(props);
            Node bacNode = isFolderType ? new Folder(props) : this.createProject(fullPath, props);
            currentNode.addChild(bacNode);
            if (!isFolderType) continue;
            this.fillTree(bacNode, fullPath);
        }
    }

    private boolean isFolderType(HashMap<String, String> props) {
        String type = props.get(Literals.BAC_PROPERTY_PREFIX + (Object)((Object)AssetProperties.TYPE));
        return Types.FOLDER.getCode().equals(type);
    }

    private Project createProject(@NotNull String fullPath, @NotNull HashMap<String, String> props) throws BacException {
        String tagsFolder;
        if (fullPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createProject must not be null");
        }
        if (props == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnPersistence.createProject must not be null");
        }
        ArrayList<String> branchesList = new ArrayList<String>();
        ArrayList<String> tagsList = new ArrayList<String>();
        String branchesFolder = fullPath + "/" + BranchType.BRANCH.getCode();
        if (this.existsFolder(branchesFolder)) {
            Collection<SVNDirEntry> list = SvnKitHelper.list(this.repository, branchesFolder);
            for (SVNDirEntry dirEntry : list) {
                branchesList.add(dirEntry.getName());
            }
        }
        if (this.existsFolder(tagsFolder = fullPath + "/" + BranchType.BRANCH.getCode())) {
            Collection<SVNDirEntry> list = SvnKitHelper.list(this.repository, tagsFolder);
            for (SVNDirEntry dirEntry : list) {
                tagsList.add(dirEntry.getName());
            }
        }
        LockInfo lockInfo = null;
        return new Project(props, branchesList, tagsList, fullPath, lockInfo);
    }
}

