/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.impl.svn;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bac.core.BacConfig;
import oracle.bpm.bac.core.BacConnection;
import oracle.bpm.bac.core.BacConnectionType;
import oracle.bpm.bac.core.exception.BacException;
import oracle.bpm.bac.core.exception.BacTransactionException;
import oracle.bpm.bac.core.impl.svn.SvnPersistence;
import oracle.bpm.bac.core.impl.svn.SvnTransaction;
import oracle.bpm.bac.core.impl.svn.utils.SvnKitHelper;
import oracle.bpm.bac.core.io.Persistence;
import oracle.bpm.bac.core.io.Transaction;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.io.SVNRepository;

public final class SvnConnection
extends BacConnection {
    private final Object lock;
    private SVNRepository repository;
    private static final ThreadLocal<Map<SVNRepository, Transaction>> context = new ThreadLocal();

    private SvnConnection(@NotNull BacConfig bacConfig) throws BacException {
        if (bacConfig == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnConnection.<init> must not be null");
        }
        this.lock = new Object();
        this.config = bacConfig;
        this.repository = bacConfig.getConnectionType() == BacConnectionType.LOCAL ? SvnKitHelper.createLocalRepository(bacConfig.getConnectionString()) : SvnKitHelper.createRemoteRepository(bacConfig.getConnectionString());
    }

    public static SvnConnection create(@NotNull BacConfig bacConfig) throws BacException {
        if (bacConfig == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnConnection.create must not be null");
        }
        return new SvnConnection(bacConfig);
    }

    @Override
    public Persistence createBacPersistence() throws BacException {
        return new SvnPersistence(this);
    }

    @Override
    public void begin() throws BacTransactionException {
        this.getCurrentTransaction(this.repository).begin();
    }

    @Override
    public void commit() throws BacTransactionException {
        this.getCurrentTransaction(this.repository).commit();
    }

    @Override
    public void rollback() {
        this.getCurrentTransaction(this.repository).rollback();
    }

    @Override
    public Transaction getTransaction() {
        return this.getCurrentTransaction(this.repository);
    }

    @Override
    public void release(@NotNull Transaction tx) {
        if (tx == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnConnection.release must not be null");
        }
        this.releaseCurrentTransaction(this.repository, true);
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction getCurrentTransaction(@NotNull SVNRepository repository) {
        Transaction transaction;
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnConnection.getCurrentTransaction must not be null");
        }
        Map<SVNRepository, Transaction> txs = context.get();
        Object object = this.lock;
        synchronized (object) {
            if (txs == null) {
                txs = new HashMap<SVNRepository, Transaction>();
                context.set(txs);
            }
            if ((transaction = txs.get(repository)) == null) {
                transaction = new SvnTransaction(repository);
                txs.put(repository, transaction);
            }
        }
        return transaction;
    }

    private void releaseCurrentTransaction(@NotNull SVNRepository repository, boolean force) {
        Transaction transaction;
        if (repository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/impl/svn/SvnConnection.releaseCurrentTransaction must not be null");
        }
        Map<SVNRepository, Transaction> txs = context.get();
        if (txs != null && (transaction = txs.get(repository)) != null && (force || transaction.isCommited() || transaction.isRollback())) {
            context.remove();
        }
    }
}

