/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bac.core.exception;

import oracle.bpm.bac.core.model.BranchType;
import oracle.bpm.bac.core.msg.BacMsg;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class BacException
extends DefaultException {
    private static final long serialVersionUID = -1L;

    public BacException(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.<init> must not be null");
        }
        super(BacMsg.BAC_EXCEPTION, (Throwable)e);
    }

    public BacException(@NotNull Msg msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.<init> must not be null");
        }
        super(msg);
    }

    public BacException(@NotNull Msg msg, @NotNull Throwable e) {
        if (msg == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.<init> must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.<init> must not be null");
        }
        super(msg, e);
    }

    public static BacException createInitError(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.createInitError must not be null");
        }
        return new BacException(BacMsg.INIT_EXCEPTION, e);
    }

    public static BacException createIOReadingBacConfiguration(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.createIOReadingBacConfiguration must not be null");
        }
        return new BacException(BacMsg.BAC_IO_READ_CONFIG, e);
    }

    public static BacException createIOError(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.createIOError must not be null");
        }
        return new BacException(BacMsg.BAC_IO_ERROR, e);
    }

    public static BacException createConfigNameNotExists(@NotNull String configName) {
        if (configName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.createConfigNameNotExists must not be null");
        }
        return new BacException(BacMsg.CONFIG_NAME_NOT_EXISTS(configName));
    }

    public static BacException createInvalidBranchType(@NotNull BranchType branchType) {
        if (branchType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bac/core/exception/BacException.createInvalidBranchType must not be null");
        }
        return new BacException(BacMsg.INVALID_BRANCH_TYPE(branchType.name()));
    }

    public static BacException createConfigNameAlreadyExists(String configName) {
        return new BacException(BacMsg.CONFIG_NAME_ALREADY_EXISTS(configName));
    }
}

