/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import oracle.bpm.tutor.bpmapi.BPMProject;
import oracle.bpm.tutor.bpmapi.convert2bpm;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.Coordinate;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.ProgressNotifier;
import oracle.tutor.docx.TutorDoc;
import oracle.tutor.docx.Utils;
import oracle.tutor.visio.UserCancelException;
import oracle.tutor.wft.WFTConverter;
import oracle.tutor.xpdl.Utility;

public class io {
    private static Logger mlog = Logger.getLogger(convert2bpm.class.getName());

    public static BusinessProcessDiagram[] importModel(String filename, ProgressNotifier notifier) throws UserCancelException, FileNotFoundException, IOException {
        return io.importModel(filename, notifier, null);
    }

    public static BusinessProcessDiagram[] importModel(String filepath, ProgressNotifier notifier, String xmlFolder) throws UserCancelException, FileNotFoundException, IOException {
        BusinessProcessDiagram[] bpdArray = new BusinessProcessDiagram[1];
        notifier.update("Reading " + new File(filepath).getName(), 10.0);
        FileExtension extension = io.getFileExtension(filepath);
        if (xmlFolder == null) {
            Utils docx_utils = new Utils(mlog);
            xmlFolder = docx_utils.getTutorXMLFolderPath();
        }
        if (extension == FileExtension.VDX) {
            try {
                oracle.tutor.visio.Utility util = new oracle.tutor.visio.Utility();
                bpdArray = util.importVdx(filepath, notifier, 100, xmlFolder);
            }
            catch (UserCancelException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (extension == FileExtension.XPDL) {
            try {
                bpdArray = Utility.importFromXPDL(filepath, xmlFolder);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (extension == FileExtension.DOCX) {
            TutorDoc td = new TutorDoc();
            try {
                td.loadDocx(filepath);
                bpdArray[0] = td.getBpdDiagram("Enterprise");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (extension == FileExtension.BPMN) {
            BPMProject bpmProj = new BPMProject();
            bpdArray[0] = bpmProj.importBPM(filepath);
        } else if (extension == FileExtension.WFT) {
            WFTConverter wft = new WFTConverter();
            filepath = "file:///".concat(filepath.replace("\\", "/").replaceFirst(":", ":/"));
            try {
                bpdArray = wft.importWft(filepath);
                if (bpdArray == null) {
                    throw new RuntimeException("No BPD created");
                }
                for (BusinessProcessDiagram bpd : bpdArray) {
                    bpd.shift(50.0f, 50.0f);
                    for (FlowObject node : bpd.getAllNodes().values()) {
                        if (node.getParentSubProcess() == null) continue;
                        node.setX(node.getX() - 50.0f);
                        node.setY(node.getY() - 50.0f);
                    }
                    Lane tempLane = bpd.getPool("P0").getLane("SYSADMIN");
                    tempLane.setHeight(tempLane.getY() + tempLane.getHeight());
                    tempLane.setWidth(tempLane.getX() + tempLane.getWidth());
                    tempLane.setPosition(new Coordinate(0.0f, 0.0f));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("File type not supported");
        }
        notifier.update("Model Successfully Converted to BPD", 100.0);
        return bpdArray;
    }

    public static FileExtension getFileExtension(String filepath) {
        String extension = filepath.lastIndexOf(".") == -1 ? "" : filepath.substring(filepath.lastIndexOf(".") + 1).toLowerCase();
        FileExtension temp = null;
        if (extension.equals("xpdl")) {
            temp = FileExtension.XPDL;
        } else if (extension.equals("docx")) {
            temp = FileExtension.DOCX;
        } else if (extension.equals("bpmn")) {
            temp = FileExtension.BPMN;
        } else if (extension.equals("vdx")) {
            temp = FileExtension.VDX;
        } else if (extension.equals("wft")) {
            temp = FileExtension.WFT;
        }
        return temp;
    }

    public static String getUniqueOutputFile(String outputFolder, String baseName, String extension) {
        String outputFile = "";
        String suffix = "";
        int counter = 0;
        do {
            if (counter > 0) {
                suffix = "(" + counter + ")";
            }
            outputFile = baseName + suffix + extension;
            ++counter;
        } while (new File(outputFolder, outputFile).exists());
        return outputFile;
    }

    static enum FileExtension {
        XPDL,
        DOCX,
        VDX,
        WFT,
        BPMN;

    }
}

