/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.tutor.bpmapi.createBPMActivity;
import oracle.tutor.bpmn.Activity;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Task;

class createBPMTask
extends createBPMActivity {
    createBPMTask(FlowObject bpmnFlowObject, NodeContainer container, LinkedList<ConversionMessage> messages) {
        this.setMessages(messages);
        this.setBpmnFlowObject(bpmnFlowObject);
        this.setContainer(container);
    }

    @Override
    public void create() throws ProjectException {
        Task bpmnTask = (Task)this.getBpmnFlowObject();
        Activity bpmActivity = this.getContainer().createActivity();
        switch (bpmnTask.getTaskType()) {
            case NONE: {
                break;
            }
            case SERVICE: {
                bpmActivity = bpmActivity.toServiceTask();
                break;
            }
            case SCRIPT: {
                bpmActivity = bpmActivity.toScriptTask();
                break;
            }
            case USER: {
                bpmActivity = bpmActivity.toUserTask();
                break;
            }
            case SEND: {
                bpmActivity = bpmActivity.toSendTask();
                break;
            }
            case MANUAL: {
                bpmActivity = bpmActivity.toManualTask();
                break;
            }
            case RECEIVE: {
                bpmActivity = bpmActivity.toReceiveTask();
            }
        }
        if (bpmnTask.getLoopType() == Activity.LoopType.STANDARD || bpmnTask.getLoopType() == Activity.LoopType.MULTIINSTANCE) {
            this.getMessages().add(new ConversionMessage(bpmnTask.getID(), bpmnTask.getName() + " : LoopTypes are not supported for Tasks."));
        }
        createBPMTask.setCommonAttributes((FlowNode)bpmActivity, bpmnTask);
        this.getContainer().addChild((ProjectObject)bpmActivity);
    }
}

