/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileGenerator;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.tutor.bpmapi.CreateBPMActivitiesRecursively;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.bpm.tutor.bpmapi.createBPMFlows;
import oracle.bpm.tutor.bpmapi.createBPMGraphicalElements;
import oracle.bpm.tutor.bpmapi.createBPMLanes;
import oracle.bpm.util.Identifier;
import oracle.tutor.bpmn.Annotation;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConnectingObject;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.DataObject;
import oracle.tutor.bpmn.FlowObject;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.SequenceFlow;

class createBPMProcess {
    private BusinessProcessDiagram _bpd = null;
    private Process _bpmProcess = null;
    private Project _bpmProject = null;
    private LinkedList<ConversionMessage> _messages = new LinkedList();
    private static final String TUTOR_TOOL_ID = "Oracle Tutor";
    private static Logger _sLog = Logger.getLogger(createBPMProcess.class.getName());

    createBPMProcess(BusinessProcessDiagram bpd, Project bpmProject) {
        this._bpd = bpd;
        this._bpmProject = bpmProject;
    }

    public Process create(Pool poolToExport) throws ProjectException {
        String bpmProcessId;
        if (poolToExport == null) {
            if (this._bpd.getPools().size() == 0 || this._bpd.getPools().size() == 1 && !Utils.poolHasChild(this._bpd.getPools().values().iterator().next(), this._bpd)) {
                _sLog.info("no pool found in _bpd : " + this._bpd.getName() + ". Creating a default pool\n");
                final BusinessProcessDiagram bpd1 = this._bpd;
                poolToExport = new Pool("P0", "Default", bpd1){
                    {
                        super(x0, x1, x2);
                        this._setLaneToAllActivities();
                        this._setPoolDimensions();
                        this.setX(0.0f);
                        this.setY(0.0f);
                    }

                    private void _setLaneToAllActivities() {
                        for (FlowObject bpmnNode : bpd1.getAllNodes().values()) {
                            if (bpmnNode instanceof Annotation || bpmnNode instanceof DataObject) continue;
                            bpmnNode.setLane(this);
                        }
                    }

                    private void _setPoolDimensions() {
                        double maxXAndWidthSum = 0.0;
                        double maxYAndHeightSum = 0.0;
                        for (FlowObject bpmnNode : bpd1.getAllNodes().values()) {
                            maxXAndWidthSum = Math.max(maxXAndWidthSum, (double)(bpmnNode.getX() + bpmnNode.getWidth()));
                            maxYAndHeightSum = Math.max(maxYAndHeightSum, (double)(bpmnNode.getY() + bpmnNode.getHeight()));
                        }
                        this.setWidth(maxXAndWidthSum + 100.0);
                        this.setHeight(maxYAndHeightSum + 100.0);
                    }
                };
                String bpmProcessId2 = Utils.normalizeProcessId(this._bpd.getID() + "_" + this._bpd.getName() + "_" + poolToExport.getName());
                bpmProcessId2 = this._getUniqueProcessId(bpmProcessId2);
                this._bpmProcess = this._bpmProject.getModelsRoot().createEmptyModel(bpmProcessId2);
                this._bpmProcess.setId(bpmProcessId2);
                this._bpmProcess.setDefaultLabel(this._getUniqueProcessLabel(this._bpd.getName()));
                this._messages.add(new ConversionMessage(poolToExport.getID(), "Default pool created"));
                this._messages.add(new ConversionMessage(poolToExport.getID(), "Default pool is set as parent lane to all activities"));
            } else if (this._bpd.getPools().size() != 0) {
                this._bpdSimplifyMergePools(this._bpd);
                poolToExport = this._bpd.getPools().values().iterator().next();
                bpmProcessId = Utils.normalizeProcessId(this._bpd.getID() + "_" + this._bpd.getName() + "_" + poolToExport.getName());
                bpmProcessId = this._getUniqueProcessId(bpmProcessId);
                this._bpmProcess = this._bpmProject.getModelsRoot().createEmptyModel(bpmProcessId);
                this._bpmProcess.setId(bpmProcessId);
                String processLabel = "".equals(poolToExport.getName()) ? this._bpd.getName() : this._bpd.getName() + "_" + poolToExport.getName();
                this._bpmProcess.setDefaultLabel(this._getUniqueProcessLabel(processLabel));
                Utils.makeLanesAdjacent(poolToExport, this._bpd);
            }
        } else {
            if (!Utils.poolHasChild(poolToExport, this._bpd)) {
                return null;
            }
            bpmProcessId = Utils.normalizeProcessId(this._bpd.getID() + "_" + this._bpd.getName() + "_" + poolToExport.getName());
            bpmProcessId = this._getUniqueProcessId(bpmProcessId);
            this._bpmProcess = this._bpmProject.getModelsRoot().createEmptyModel(bpmProcessId);
            this._bpmProcess.setId(bpmProcessId);
            String processLabel = "".equals(poolToExport.getName()) ? this._bpd.getName() : this._bpd.getName() + "_" + poolToExport.getName();
            this._bpmProcess.setDefaultLabel(this._getUniqueProcessLabel(processLabel));
            Utils.makeLanesAdjacent(poolToExport, this._bpd);
            this._removeOrphanNodes(this._bpd, false);
        }
        if (this._bpd.getDocumentation() != null) {
            this._bpmProcess.setDefaultDescription(this._bpd.getDocumentation());
        }
        createBPMGraphicalElements creator = null;
        creator = new createBPMLanes(this._bpd, this._bpmProcess, this._messages);
        creator.create(poolToExport);
        creator = new CreateBPMActivitiesRecursively(this._bpmProcess, this._bpd, this._messages);
        creator.create(poolToExport);
        this._bpd.simplify(BusinessProcessDiagram.SimplifyFlags.DETACH_SUBPROCESS_START_END);
        creator = new createBPMFlows(this._bpd, this._bpmProcess, this._messages);
        creator.create(poolToExport);
        this._createMessagesNote(this._bpmProcess, poolToExport);
        if (this._bpmProcess.getChildren() != null && this._bpmProcess.getChildren().toArray().length != 0) {
            DocumentationFileGenerator.generateDocumentationFileFor((Process)this._bpmProcess);
            this._bpmProject.getModelsRoot().addChild((ProjectObject)this._bpmProcess);
            this._bpmProcess.getProject().getWriter().write(new ProjectObject[]{this._bpmProcess});
        }
        return this._bpmProcess;
    }

    private void _createMessagesNote(Process bpmProcess, Pool pool) throws ProjectException {
        String text = "";
        int maxWide = 0;
        int ctr = 1;
        boolean firstMsg = true;
        for (ConversionMessage msg : this._messages) {
            if (firstMsg) {
                firstMsg = false;
                text = "Conversion Notes \n --------------------\n";
                maxWide = 17;
            }
            maxWide = maxWide > msg.getMessage().length() ? maxWide : msg.getMessage().length();
            text = text + ctr + ". " + msg.getMessage() + "\n";
            ++ctr;
        }
        if (!"".equals(text)) {
            TextAnnotation bpmTextAnnotation = bpmProcess.createTextAnnotation("tmpMsgNote");
            bpmTextAnnotation.setId("tmpMsgNote");
            bpmTextAnnotation.setDefaultLabel(text);
            bpmTextAnnotation.setHeight((4 + this._messages.size()) * 15);
            bpmTextAnnotation.setWidth(maxWide * 10 + 10);
            bpmTextAnnotation.setX(Math.round(pool.getWidth() / 2.0f));
            bpmTextAnnotation.setY(Math.round(pool.getHeight() + (float)(bpmTextAnnotation.getHeight() / 2)));
            bpmProcess.addChild((ProjectObject)bpmTextAnnotation);
        }
    }

    private void _bpdSimplifyMergePools(BusinessProcessDiagram bpd) {
        _sLog.info("merging pools of _bpd : " + bpd.getName() + "\n");
        this._messages = bpd.simplify(BusinessProcessDiagram.SimplifyFlags.MERGE_POOLS);
        this._removeOrphanNodes(bpd, true);
        if (bpd.getToolID() != null && TUTOR_TOOL_ID.equals(bpd.getToolID())) {
            Pool newPool = bpd.getPools().get("_merged_");
            LinkedList<Lane> tempLanesList = new LinkedList<Lane>(newPool.getLanes().values());
            for (Lane lane : tempLanesList) {
                boolean laneDeleted;
                if (Utils.laneHasChild(lane, bpd) || !(laneDeleted = newPool.getLanes().values().remove(lane))) continue;
                this._messages.add(new ConversionMessage(lane.getID(), "Lane \"" + lane.getID() + "\" has no child and is removed."));
            }
        }
    }

    private void _removeOrphanNodes(BusinessProcessDiagram bpd, boolean poolsMerged) {
        LinkedList<FlowObject> tempNodes = new LinkedList<FlowObject>(bpd.getAllNodes().values());
        for (FlowObject bpmnNode : tempNodes) {
            if (bpmnNode instanceof Annotation || bpmnNode instanceof DataObject || bpmnNode.getLane() != null) continue;
            if ("".equals(bpmnNode.getName())) {
                if (poolsMerged) {
                    this._messages.add(new ConversionMessage(bpmnNode.getID(), "'" + bpmnNode.getID() + "' orphan node removed. Due to merging of pools this node has become an orphan node"));
                } else {
                    this._messages.add(new ConversionMessage(bpmnNode.getID(), bpmnNode.getID() + " orphan node removed because it is outside pools and lanes"));
                }
            } else if (poolsMerged) {
                this._messages.add(new ConversionMessage(bpmnNode.getID(), "'" + bpmnNode.getName() + "' node removed. Due to merging of pools this node has become an orphan node"));
            } else {
                this._messages.add(new ConversionMessage(bpmnNode.getID(), bpmnNode.getName() + " orphan node removed because it is outside pools and lanes"));
            }
            LinkedList<ConnectingObject> inFlows = new LinkedList<ConnectingObject>(bpmnNode.getInflows(SequenceFlow.class));
            LinkedList<ConnectingObject> outFlows = new LinkedList<ConnectingObject>(bpmnNode.getOutflows(SequenceFlow.class));
            for (ConnectingObject flow : inFlows) {
                flow.remove();
            }
            for (ConnectingObject flow : outFlows) {
                flow.remove();
            }
            _sLog.info(this._messages.getLast().getMessage());
            _sLog.info("in and out flows from " + bpmnNode.getID() + " are removed.\n");
            bpd.getAllNodes().remove(bpmnNode.getID());
        }
    }

    private String _getUniqueProcessId(String processId) {
        String newId = Identifier.classname((String)processId, (boolean)true);
        int suffix = 0;
        while (this._bpmProject.findProcess(newId) != null) {
            newId = Identifier.classname((String)(processId + "_" + ++suffix), (boolean)true);
        }
        return newId;
    }

    private String _getUniqueProcessLabel(String processName) {
        String newName = processName;
        int suffix = 0;
        while (this._findProcessByLabel(newName) != null) {
            newName = processName + " (" + ++suffix + ")";
        }
        return newName;
    }

    private Process _findProcessByLabel(String label) {
        Process foundProc = null;
        for (Process proc : this._bpmProject.getProcesses()) {
            if (!proc.getDefaultLabel().equals(label)) continue;
            foundProc = proc;
            break;
        }
        return foundProc;
    }
}

