/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.tutor.bpmapi;

import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.tutor.bpmapi.Utils;
import oracle.bpm.tutor.bpmapi.createBPMFlows;
import oracle.bpm.tutor.bpmapi.createBPMGraphicalElements;
import oracle.tutor.bpmn.BusinessProcessDiagram;
import oracle.tutor.bpmn.ConversionMessage;
import oracle.tutor.bpmn.Lane;
import oracle.tutor.bpmn.Pool;
import oracle.tutor.bpmn.Swimlane;

class createBPMLanes
extends createBPMGraphicalElements {
    private LinkedList<ConversionMessage> _messages;
    private int _unknownNameCount = 0;
    private static final Logger _sLog = Logger.getLogger(createBPMFlows.class.getName());

    createBPMLanes(BusinessProcessDiagram bpd, Process bpmProcess, LinkedList<ConversionMessage> messages) {
        this.setBpd(bpd);
        this.setBpmProcess(bpmProcess);
        this._messages = messages;
    }

    @Override
    public void create(Pool poolToExport) throws ProjectException {
        oracle.bpm.project.model.processes.Lane bpmLane = null;
        if (poolToExport.getLanes().size() != 0) {
            _sLog.info("creating bpm lanes.\n");
            for (Lane bpmnLane : poolToExport.getLanes().values()) {
                bpmLane = this._createBPMLane(bpmnLane);
                this._setBPMLaneAttributes(bpmLane, bpmnLane);
            }
        } else if (Utils.poolHasChild(poolToExport, this.getBpd())) {
            _sLog.info("creating bpm lanes.\n");
            bpmLane = this._createBPMLane(poolToExport);
            this._setBPMLaneAttributes(bpmLane, poolToExport);
        }
    }

    private oracle.bpm.project.model.processes.Lane _createBPMLane(Swimlane bpmnLane) throws ProjectException {
        String name = bpmnLane.getName() != null && !"".equals(bpmnLane.getName()) ? bpmnLane.getName() : "anonymousLane " + ++this._unknownNameCount;
        Project tempProject = this.getBpmProcess().getProject();
        Organization org = tempProject.getOrganization();
        Role role = org.createRole(name, name);
        this.getBpmProcess().getProject().getOrganization().addOrganizationalObject((ProjectObject)role);
        return this.getBpmProcess().createLane(name);
    }

    private void _setBPMLaneAttributes(oracle.bpm.project.model.processes.Lane bpmLane, Swimlane bpmnLane) throws ProjectException {
        bpmLane.setSize(Math.round(bpmnLane.getHeight()));
        bpmLane.setOffset(Math.round(bpmnLane.getY()));
        bpmLane.setDefaultLabel(bpmnLane.getName());
        this.getBpmProcess().addChild((ProjectObject)bpmLane);
    }
}

